/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.HijrahChronology;
import java.time.chrono.HijrahEra;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;

public final class HijrahDate
extends ChronoLocalDateImpl<HijrahDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -5207853542612002020L;
    private final transient HijrahChronology chrono;
    private final transient int prolepticYear;
    private final transient int monthOfYear;
    private final transient int dayOfMonth;

    static HijrahDate of(HijrahChronology chrono, int prolepticYear, int monthOfYear, int dayOfMonth) {
        return new HijrahDate(chrono, prolepticYear, monthOfYear, dayOfMonth);
    }

    static HijrahDate ofEpochDay(HijrahChronology chrono, long epochDay) {
        return new HijrahDate(chrono, epochDay);
    }

    public static HijrahDate now() {
        return HijrahDate.now(Clock.systemDefaultZone());
    }

    public static HijrahDate now(ZoneId zone) {
        return HijrahDate.now(Clock.system(zone));
    }

    public static HijrahDate now(Clock clock) {
        return HijrahDate.ofEpochDay(HijrahChronology.INSTANCE, LocalDate.now(clock).toEpochDay());
    }

    public static HijrahDate of(int prolepticYear, int month, int dayOfMonth) {
        return HijrahChronology.INSTANCE.date(prolepticYear, month, dayOfMonth);
    }

    public static HijrahDate from(TemporalAccessor temporal) {
        return HijrahChronology.INSTANCE.date(temporal);
    }

    private HijrahDate(HijrahChronology chrono, int prolepticYear, int monthOfYear, int dayOfMonth) {
        chrono.getEpochDay(prolepticYear, monthOfYear, dayOfMonth);
        this.chrono = chrono;
        this.prolepticYear = prolepticYear;
        this.monthOfYear = monthOfYear;
        this.dayOfMonth = dayOfMonth;
    }

    private HijrahDate(HijrahChronology chrono, long epochDay) {
        int[] dateInfo = chrono.getHijrahDateInfo((int)epochDay);
        this.chrono = chrono;
        this.prolepticYear = dateInfo[0];
        this.monthOfYear = dateInfo[1];
        this.dayOfMonth = dateInfo[2];
    }

    @Override
    public HijrahChronology getChronology() {
        return this.chrono;
    }

    @Override
    public HijrahEra getEra() {
        return HijrahEra.AH;
    }

    @Override
    public int lengthOfMonth() {
        return this.chrono.getMonthLength(this.prolepticYear, this.monthOfYear);
    }

    @Override
    public int lengthOfYear() {
        return this.chrono.getYearLength(this.prolepticYear);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                ChronoField f = (ChronoField)field;
                switch (f) {
                    case DAY_OF_MONTH: {
                        return ValueRange.of(1L, this.lengthOfMonth());
                    }
                    case DAY_OF_YEAR: {
                        return ValueRange.of(1L, this.lengthOfYear());
                    }
                    case ALIGNED_WEEK_OF_MONTH: {
                        return ValueRange.of(1L, 5L);
                    }
                }
                return this.getChronology().range(f);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case DAY_OF_WEEK: {
                    return this.getDayOfWeek();
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return (this.getDayOfWeek() - 1) % 7 + 1;
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return (this.getDayOfYear() - 1) % 7 + 1;
                }
                case DAY_OF_MONTH: {
                    return this.dayOfMonth;
                }
                case DAY_OF_YEAR: {
                    return this.getDayOfYear();
                }
                case EPOCH_DAY: {
                    return this.toEpochDay();
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return (this.dayOfMonth - 1) / 7 + 1;
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return (this.getDayOfYear() - 1) / 7 + 1;
                }
                case MONTH_OF_YEAR: {
                    return this.monthOfYear;
                }
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    return this.prolepticYear;
                }
                case YEAR: {
                    return this.prolepticYear;
                }
                case ERA: {
                    return this.getEraValue();
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.prolepticYear * 12L + (long)this.monthOfYear - 1L;
    }

    @Override
    public HijrahDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            this.chrono.range(f).checkValidValue(newValue, f);
            int nvalue = (int)newValue;
            switch (f) {
                case DAY_OF_WEEK: {
                    return this.plusDays(newValue - (long)this.getDayOfWeek());
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return this.plusDays(newValue - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return this.plusDays(newValue - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                }
                case DAY_OF_MONTH: {
                    return this.resolvePreviousValid(this.prolepticYear, this.monthOfYear, nvalue);
                }
                case DAY_OF_YEAR: {
                    return this.plusDays(Math.min(nvalue, this.lengthOfYear()) - this.getDayOfYear());
                }
                case EPOCH_DAY: {
                    return new HijrahDate(this.chrono, newValue);
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return this.plusDays((newValue - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH)) * 7L);
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return this.plusDays((newValue - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR)) * 7L);
                }
                case MONTH_OF_YEAR: {
                    return this.resolvePreviousValid(this.prolepticYear, nvalue, this.dayOfMonth);
                }
                case PROLEPTIC_MONTH: {
                    return this.plusMonths(newValue - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: {
                    return this.resolvePreviousValid(this.prolepticYear >= 1 ? nvalue : 1 - nvalue, this.monthOfYear, this.dayOfMonth);
                }
                case YEAR: {
                    return this.resolvePreviousValid(nvalue, this.monthOfYear, this.dayOfMonth);
                }
                case ERA: {
                    return this.resolvePreviousValid(1 - this.prolepticYear, this.monthOfYear, this.dayOfMonth);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return (HijrahDate)super.with(field, newValue);
    }

    private HijrahDate resolvePreviousValid(int prolepticYear, int month, int day) {
        int monthDays = this.chrono.getMonthLength(prolepticYear, month);
        if (day > monthDays) {
            day = monthDays;
        }
        return HijrahDate.of(this.chrono, prolepticYear, month, day);
    }

    @Override
    public HijrahDate with(TemporalAdjuster adjuster) {
        return (HijrahDate)super.with(adjuster);
    }

    public HijrahDate withVariant(HijrahChronology chronology) {
        if (this.chrono == chronology) {
            return this;
        }
        int monthDays = chronology.getDayOfYear(this.prolepticYear, this.monthOfYear);
        return HijrahDate.of(chronology, this.prolepticYear, this.monthOfYear, this.dayOfMonth > monthDays ? monthDays : this.dayOfMonth);
    }

    @Override
    public HijrahDate plus(TemporalAmount amount) {
        return (HijrahDate)super.plus(amount);
    }

    @Override
    public HijrahDate minus(TemporalAmount amount) {
        return (HijrahDate)super.minus(amount);
    }

    @Override
    public long toEpochDay() {
        return this.chrono.getEpochDay(this.prolepticYear, this.monthOfYear, this.dayOfMonth);
    }

    private int getDayOfYear() {
        return this.chrono.getDayOfYear(this.prolepticYear, this.monthOfYear) + this.dayOfMonth;
    }

    private int getDayOfWeek() {
        int dow0 = Math.floorMod(this.toEpochDay() + 3L, 7);
        return dow0 + 1;
    }

    private int getEraValue() {
        return this.prolepticYear > 1 ? 1 : 0;
    }

    @Override
    public boolean isLeapYear() {
        return this.chrono.isLeapYear(this.prolepticYear);
    }

    @Override
    HijrahDate plusYears(long years) {
        if (years == 0L) {
            return this;
        }
        int newYear = Math.addExact(this.prolepticYear, (int)years);
        return this.resolvePreviousValid(newYear, this.monthOfYear, this.dayOfMonth);
    }

    @Override
    HijrahDate plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        long monthCount = (long)this.prolepticYear * 12L + (long)(this.monthOfYear - 1);
        long calcMonths = monthCount + monthsToAdd;
        int newYear = this.chrono.checkValidYear(Math.floorDiv(calcMonths, 12L));
        int newMonth = (int)Math.floorMod(calcMonths, 12L) + 1;
        return this.resolvePreviousValid(newYear, newMonth, this.dayOfMonth);
    }

    @Override
    HijrahDate plusWeeks(long weeksToAdd) {
        return (HijrahDate)super.plusWeeks(weeksToAdd);
    }

    @Override
    HijrahDate plusDays(long days) {
        return new HijrahDate(this.chrono, this.toEpochDay() + days);
    }

    @Override
    public HijrahDate plus(long amountToAdd, TemporalUnit unit) {
        return (HijrahDate)super.plus(amountToAdd, unit);
    }

    @Override
    public HijrahDate minus(long amountToSubtract, TemporalUnit unit) {
        return (HijrahDate)super.minus(amountToSubtract, unit);
    }

    @Override
    HijrahDate minusYears(long yearsToSubtract) {
        return (HijrahDate)super.minusYears(yearsToSubtract);
    }

    @Override
    HijrahDate minusMonths(long monthsToSubtract) {
        return (HijrahDate)super.minusMonths(monthsToSubtract);
    }

    @Override
    HijrahDate minusWeeks(long weeksToSubtract) {
        return (HijrahDate)super.minusWeeks(weeksToSubtract);
    }

    @Override
    HijrahDate minusDays(long daysToSubtract) {
        return (HijrahDate)super.minusDays(daysToSubtract);
    }

    public final ChronoLocalDateTime<HijrahDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDate) {
        HijrahDate end = this.getChronology().date(endDate);
        long totalMonths = (end.prolepticYear - this.prolepticYear) * 12 + (end.monthOfYear - this.monthOfYear);
        int days = end.dayOfMonth - this.dayOfMonth;
        if (totalMonths > 0L && days < 0) {
            HijrahDate calcDate = this.plusMonths(--totalMonths);
            days = (int)(end.toEpochDay() - calcDate.toEpochDay());
        } else if (totalMonths < 0L && days > 0) {
            ++totalMonths;
            days -= end.lengthOfMonth();
        }
        long years = totalMonths / 12L;
        int months = (int)(totalMonths % 12L);
        return this.getChronology().period(Math.toIntExact(years), months, days);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HijrahDate) {
            HijrahDate otherDate = (HijrahDate)obj;
            return this.prolepticYear == otherDate.prolepticYear && this.monthOfYear == otherDate.monthOfYear && this.dayOfMonth == otherDate.dayOfMonth && this.getChronology().equals(otherDate.getChronology());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int yearValue = this.prolepticYear;
        int monthValue = this.monthOfYear;
        int dayValue = this.dayOfMonth;
        return this.getChronology().getId().hashCode() ^ yearValue & 0xFFFFF800 ^ (yearValue << 11) + (monthValue << 6) + dayValue;
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(6, this);
    }

    void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getChronology());
        out.writeInt(this.get(ChronoField.YEAR));
        out.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        out.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static HijrahDate readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        HijrahChronology chrono = (HijrahChronology)in.readObject();
        int year = in.readInt();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        return chrono.date(year, month, dayOfMonth);
    }
}

