/*
 * Decompiled with CFR 0.152.
 */
package desugar.sun.nio.fs;

import desugar.sun.nio.fs.DesugarBasicFileAttributeView;
import desugar.sun.nio.fs.DesugarLinuxFileSystem;
import desugar.sun.nio.fs.DesugarMimeTypesFileTypeDetector;
import desugar.sun.nio.fs.DesugarSeekableByteChannel;
import desugar.sun.nio.fs.DesugarUnixPath;
import desugar.sun.nio.fs.DesugarUnixUriUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class DesugarLinuxFileSystemProvider
extends FileSystemProvider {
    private static final String FILE_SCHEME = "file";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final String userDir;
    private final String rootDir;
    private volatile DesugarLinuxFileSystem theFileSystem;

    public static DesugarLinuxFileSystemProvider create() {
        return new DesugarLinuxFileSystemProvider(System.getProperty("user.dir"), "/");
    }

    DesugarLinuxFileSystemProvider(String userDir, String rootDir) {
        this.userDir = userDir;
        this.rootDir = rootDir;
    }

    @Override
    public String getScheme() {
        return FILE_SCHEME;
    }

    @Override
    public DesugarLinuxFileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.checkFileUri(uri);
        throw new FileSystemAlreadyExistsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DesugarLinuxFileSystem getFileSystem(URI uri) {
        this.checkFileUri(uri);
        DesugarLinuxFileSystem fs = this.theFileSystem;
        if (fs == null) {
            DesugarLinuxFileSystemProvider desugarLinuxFileSystemProvider = this;
            synchronized (desugarLinuxFileSystemProvider) {
                fs = this.theFileSystem;
                if (fs == null) {
                    this.theFileSystem = fs = new DesugarLinuxFileSystem(this, this.userDir, this.rootDir);
                }
            }
        }
        return fs;
    }

    @Override
    public Path getPath(URI uri) {
        return DesugarUnixUriUtils.fromUri(this.theFileSystem, uri, this.userDir, this.rootDir);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        File dirAsFile = dir.toFile();
        ArrayList<Path> listedFilePaths = new ArrayList<Path>();
        File[] files = dirAsFile.listFiles();
        if (files != null) {
            for (File file : files) {
                DesugarUnixPath pathEntry = new DesugarUnixPath(this.theFileSystem, file.getPath(), this.userDir, this.rootDir);
                if (!filter.accept(pathEntry)) continue;
                listedFilePaths.add(pathEntry);
            }
        }
        return new PathCollectionBasedDirectoryStream(listedFilePaths);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        File dirFile = dir.toFile();
        boolean mkdirStatus = dirFile.mkdirs();
        if (!mkdirStatus) {
            throw new FileAlreadyExistsException(dir.toString());
        }
    }

    private boolean exists(Path file) {
        try {
            this.checkAccess(file, new AccessMode[0]);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        if (this.exists(path)) {
            this.deleteIfExists(path);
            return;
        }
        throw new IOException(String.format("Expected there exists %s before deletion.", path));
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return path.toFile().delete();
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return new FileInputStream(path.toFile());
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return new FileOutputStream(path.toFile());
    }

    @Override
    public DesugarSeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (path.toFile().isDirectory()) {
            throw new UnsupportedOperationException("The desugar library does not support creating a file channel on a directory: " + path);
        }
        return DesugarSeekableByteChannel.create(path, options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return ((DesugarSeekableByteChannel)this.newByteChannel(path, (Set)options, (FileAttribute[])attrs)).getFileChannel();
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return new DesugarUnixPath(this.theFileSystem, link.toFile().getCanonicalPath(), this.userDir, this.rootDir);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        try (FileInputStream in = new FileInputStream(source.toFile());
             FileOutputStream out = new FileOutputStream(target.toFile());){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = ((InputStream)in).read(buffer, 0, 8192)) >= 0) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        File sourceFile = source.toFile();
        File targetFile = target.toFile();
        sourceFile.renameTo(targetFile);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return path.toFile().equals(path2.toFile());
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return path.toFile().isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new SecurityException("getFileStore");
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            return (V)((FileAttributeView)type.cast(new DesugarBasicFileAttributeView(path)));
        }
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        File file = path.toFile();
        if (!file.exists()) {
            throw new NoSuchFileException(path.toString());
        }
        boolean permittedToAccess = true;
        block5: for (AccessMode accessMode : modes) {
            switch (accessMode) {
                case READ: {
                    permittedToAccess &= file.canRead();
                    continue block5;
                }
                case WRITE: {
                    permittedToAccess &= file.canWrite();
                    continue block5;
                }
                case EXECUTE: {
                    permittedToAccess &= file.canExecute();
                }
            }
        }
        if (!permittedToAccess) {
            throw new IOException(String.format("Unable to access file %s", path));
        }
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type != BasicFileAttributes.class) {
            throw new UnsupportedOperationException();
        }
        Class<BasicFileAttributeView> view = BasicFileAttributeView.class;
        return (A)((BasicFileAttributes)type.cast(this.getFileAttributeView(path, view, options).readAttributes()));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        String[] requestedAttributes;
        Class<BasicFileAttributeView> attributeViewType;
        int attributesTypeIndexEnd = attributes.indexOf(":");
        if (attributesTypeIndexEnd == -1) {
            attributeViewType = BasicFileAttributeView.class;
            requestedAttributes = attributes.split(",");
        } else {
            String attributeTypeSpec = attributes.substring(0, attributesTypeIndexEnd);
            if (!"basic".equals(attributeTypeSpec)) {
                throw new UnsupportedOperationException(String.format("Requested attribute type for: %s is not available.", attributeTypeSpec));
            }
            attributeViewType = BasicFileAttributeView.class;
            requestedAttributes = attributes.substring(attributesTypeIndexEnd + 1).split(",");
        }
        if (attributeViewType == BasicFileAttributeView.class) {
            DesugarBasicFileAttributeView attrView = new DesugarBasicFileAttributeView(path);
            return attrView.readAttributes(requestedAttributes);
        }
        throw new AssertionError((Object)("Unexpected View '" + attributeViewType + "' requested"));
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        String requestedAttribute;
        Class<BasicFileAttributeView> attributeViewType;
        int attributesTypeIndexEnd = attribute.indexOf(":");
        if (attributesTypeIndexEnd == -1) {
            attributeViewType = BasicFileAttributeView.class;
            requestedAttribute = attribute;
        } else {
            String attributeTypeSpec = attribute.substring(0, attributesTypeIndexEnd);
            if (!"basic".equals(attributeTypeSpec)) {
                throw new UnsupportedOperationException(String.format("Requested attribute type for: %s is not available.", attributeTypeSpec));
            }
            attributeViewType = BasicFileAttributeView.class;
            requestedAttribute = attribute.substring(attributesTypeIndexEnd + 1);
        }
        if (attributeViewType == BasicFileAttributeView.class) {
            DesugarBasicFileAttributeView attrView = new DesugarBasicFileAttributeView(path);
            attrView.setAttribute(requestedAttribute, value);
            return;
        }
        throw new AssertionError((Object)("Unexpected View '" + attributeViewType + "' requested"));
    }

    FileTypeDetector getFileTypeDetector() {
        return new DesugarMimeTypesFileTypeDetector();
    }

    private void checkFileUri(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!path.equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
    }

    static class PathCollectionBasedDirectoryStream
    implements DirectoryStream<Path> {
        private final Collection<Path> paths;

        PathCollectionBasedDirectoryStream(Collection<Path> paths) {
            this.paths = paths;
        }

        @Override
        public Iterator<Path> iterator() {
            return this.paths.iterator();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

