/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.math.BigInteger;
import java.util.Objects;

public final class DesugarLong {
    private DesugarLong() {
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(DesugarInteger.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(DesugarInteger.toUnsignedLong(lower)));
    }

    public static String toUnsignedString(long i) {
        return Long.toUnsignedString(i, 10);
    }

    public static long parseLong(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = beginIndex;
        long limit = -9223372036854775807L;
        if (i < endIndex) {
            char firstChar = s.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
            }
            if (i >= endIndex) {
                throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
            }
            long multmin = limit / (long)radix;
            long result = 0L;
            while (i < endIndex) {
                int digit = Character.digit(s.charAt(i), radix);
                if (digit < 0 || result < multmin) {
                    throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= (long)digit;
            }
            return negative ? result : -result;
        }
        throw new NumberFormatException("");
    }

    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, radix);
            }
            long first = DesugarLong.parseLong(s, 0, len - 1, radix);
            int second = Character.digit(s.charAt(len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException("Bad digit at end of " + s);
            }
            long result = first * (long)radix + (long)second;
            int guard = radix * (int)(first >>> 57);
            if (guard >= 128 || result >= 0L && guard >= 92) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
            }
            return result;
        }
        throw DesugarNumberFormatException.forInputString(s);
    }

    public static long parseUnsignedLong(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        int start = beginIndex;
        int len = endIndex - beginIndex;
        if (len > 0) {
            char firstChar = s.charAt(start);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s.subSequence(start, start + len)));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return DesugarLong.parseLong(s, start, start + len, radix);
            }
            long first = DesugarLong.parseLong(s, start, start + len - 1, radix);
            int second = Character.digit(s.charAt(start + len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException("Bad digit at end of " + s.subSequence(start, start + len));
            }
            long result = first * (long)radix + (long)second;
            int guard = radix * (int)(first >>> 57);
            if (guard >= 128 || result >= 0L && guard >= 92) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s.subSequence(start, start + len)));
            }
            return result;
        }
        throw DesugarNumberFormatException.forInputString("");
    }

    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return DesugarLong.parseUnsignedLong(s, 10);
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(long x, long y) {
        return DesugarLong.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor < 0L) {
            return DesugarLong.compareUnsigned(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend > 0L) {
            return dividend / divisor;
        }
        return DesugarLong.toUnsignedBigInteger(dividend).divide(DesugarLong.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (dividend > 0L && divisor > 0L) {
            return dividend % divisor;
        }
        if (DesugarLong.compareUnsigned(dividend, divisor) < 0) {
            return dividend;
        }
        return DesugarLong.toUnsignedBigInteger(dividend).remainder(DesugarLong.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }
}

