/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DesugarGregorianCalendar {
    private DesugarGregorianCalendar() {
    }

    public static ZonedDateTime toZonedDateTime(GregorianCalendar this_) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this_.getTimeInMillis()), this_.getTimeZone().toZoneId());
    }

    public static GregorianCalendar from(ZonedDateTime zdt) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone(zdt.getZone()));
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        try {
            cal.setTimeInMillis(DesugarMath.addExact(DesugarMath.multiplyExact(zdt.toEpochSecond(), 1000), (long)zdt.get(ChronoField.MILLI_OF_SECOND)));
        }
        catch (ArithmeticException ex) {
            throw new IllegalArgumentException(ex);
        }
        return cal;
    }
}

