/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import sun.misc.DesugarUnsafe;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class PollSelectorImpl
extends SelectorImpl {
    private static final int INITIAL_CAPACITY = 16;
    private int pollArrayCapacity = 16;
    private int pollArraySize;
    private AllocatedNativeObject pollArray;
    private final int fd0;
    private final int fd1;
    private final List<SelectionKeyImpl> pollKeys = new ArrayList<SelectionKeyImpl>();
    private final Object updateLock = new Object();
    private final Deque<SelectionKeyImpl> updateKeys = new ArrayDeque<SelectionKeyImpl>();
    private final Object interruptLock = new Object();
    private boolean interruptTriggered;
    private static final short SIZE_POLLFD = 8;
    private static final short FD_OFFSET = 0;
    private static final short EVENT_OFFSET = 4;
    private static final short REVENT_OFFSET = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PollSelectorImpl(SelectorProvider sp) throws IOException {
        super(sp);
        int size = this.pollArrayCapacity * 8;
        this.pollArray = new AllocatedNativeObject(size, false);
        try {
            long fds = IOUtil.makePipe(false);
            this.fd0 = (int)(fds >>> 32);
            this.fd1 = (int)fds;
        }
        catch (IOException ioe) {
            this.pollArray.free();
            throw ioe;
        }
        PollSelectorImpl pollSelectorImpl = this;
        synchronized (pollSelectorImpl) {
            this.setFirst(this.fd0, Net.POLLIN);
        }
    }

    private void ensureOpen() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(Consumer<SelectionKey> action, long timeout) throws IOException {
        assert (Thread.holdsLock(this));
        int to = (int)Math.min(timeout, Integer.MAX_VALUE);
        boolean blocking = to != 0;
        boolean timedPoll = to > 0;
        this.processUpdateQueue();
        this.processDeregisterQueue();
        try {
            int numPolled;
            this.begin(blocking);
            do {
                long adjust;
                long startTime = timedPoll ? System.nanoTime() : 0L;
                numPolled = PollSelectorImpl.poll(this.pollArray.address(), this.pollArraySize, to);
                if (numPolled != -3 || !timedPoll || (to = (int)((long)to - TimeUnit.MILLISECONDS.convert(adjust = System.nanoTime() - startTime, TimeUnit.NANOSECONDS))) > 0) continue;
                numPolled = 0;
            } while (numPolled == -3);
            assert (numPolled <= this.pollArraySize);
        }
        finally {
            this.end(blocking);
        }
        this.processDeregisterQueue();
        return this.processEvents(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdateQueue() {
        assert (Thread.holdsLock(this));
        Object object = this.updateLock;
        synchronized (object) {
            SelectionKeyImpl ski;
            while ((ski = this.updateKeys.pollFirst()) != null) {
                int newEvents = ski.translateInterestOps();
                if (!ski.isValid()) continue;
                int index = ski.getIndex();
                assert (index >= 0 && index < this.pollArraySize);
                if (index > 0) {
                    assert (this.pollKeys.get(index) == ski);
                    if (newEvents == 0) {
                        this.remove(ski);
                        continue;
                    }
                    this.update(ski, newEvents);
                    continue;
                }
                if (newEvents == 0) continue;
                this.add(ski, newEvents);
            }
        }
    }

    private int processEvents(Consumer<SelectionKey> action) throws IOException {
        assert (Thread.holdsLock(this));
        assert (this.pollArraySize > 0 && this.pollArraySize == this.pollKeys.size());
        int numKeysUpdated = 0;
        for (int i = 1; i < this.pollArraySize; ++i) {
            int rOps = this.getReventOps(i);
            if (rOps == 0) continue;
            SelectionKeyImpl ski = this.pollKeys.get(i);
            assert (ski.getFDVal() == this.getDescriptor(i));
            if (!ski.isValid()) continue;
            numKeysUpdated += this.processReadyEvents(rOps, ski, action);
        }
        if (this.getReventOps(0) != 0) {
            assert (this.getDescriptor(0) == this.fd0);
            this.clearInterrupt();
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        assert (!this.isOpen());
        assert (Thread.holdsLock(this));
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = true;
        }
        this.pollArray.free();
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
    }

    @Override
    protected void implRegister(SelectionKeyImpl ski) {
        assert (ski.getIndex() == 0);
        this.ensureOpen();
    }

    @Override
    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        assert (!ski.isValid());
        assert (Thread.holdsLock(this));
        int index = ski.getIndex();
        if (index > 0) {
            this.remove(ski);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventOps(SelectionKeyImpl ski) {
        this.ensureOpen();
        Object object = this.updateLock;
        synchronized (object) {
            this.updateKeys.addLast(ski);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                try {
                    IOUtil.write1(this.fd1, (byte)0);
                }
                catch (IOException ioe) {
                    throw new InternalError(ioe);
                }
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInterrupt() throws IOException {
        Object object = this.interruptLock;
        synchronized (object) {
            IOUtil.drain(this.fd0);
            this.interruptTriggered = false;
        }
    }

    private void setFirst(int fd, int ops) {
        assert (this.pollArraySize == 0);
        assert (this.pollKeys.isEmpty());
        this.putDescriptor(0, fd);
        this.putEventOps(0, ops);
        this.pollArraySize = 1;
        this.pollKeys.add(null);
    }

    private void add(SelectionKeyImpl ski, int ops) {
        this.expandIfNeeded();
        int index = this.pollArraySize;
        assert (index > 0);
        this.putDescriptor(index, ski.getFDVal());
        this.putEventOps(index, ops);
        this.putReventOps(index, 0);
        ski.setIndex(index);
        ++this.pollArraySize;
        this.pollKeys.add(ski);
        assert (this.pollKeys.size() == this.pollArraySize);
    }

    private void update(SelectionKeyImpl ski, int ops) {
        int index = ski.getIndex();
        assert (index > 0 && index < this.pollArraySize);
        assert (this.getDescriptor(index) == ski.getFDVal());
        this.putEventOps(index, ops);
    }

    private void remove(SelectionKeyImpl ski) {
        int index = ski.getIndex();
        assert (index > 0 && index < this.pollArraySize);
        assert (this.getDescriptor(index) == ski.getFDVal());
        int lastIndex = this.pollArraySize - 1;
        if (lastIndex != index) {
            SelectionKeyImpl lastKey = this.pollKeys.get(lastIndex);
            assert (lastKey.getIndex() == lastIndex);
            int lastFd = this.getDescriptor(lastIndex);
            int lastOps = this.getEventOps(lastIndex);
            int lastRevents = this.getReventOps(lastIndex);
            assert (lastKey.getFDVal() == lastFd);
            this.putDescriptor(index, lastFd);
            this.putEventOps(index, lastOps);
            this.putReventOps(index, lastRevents);
            this.pollKeys.set(index, lastKey);
            lastKey.setIndex(index);
        }
        this.pollKeys.remove(lastIndex);
        --this.pollArraySize;
        assert (this.pollKeys.size() == this.pollArraySize);
        ski.setIndex(0);
    }

    private void expandIfNeeded() {
        if (this.pollArraySize == this.pollArrayCapacity) {
            int oldSize = this.pollArrayCapacity * 8;
            int newCapacity = this.pollArrayCapacity + 16;
            int newSize = newCapacity * 8;
            AllocatedNativeObject newPollArray = new AllocatedNativeObject(newSize, false);
            DesugarUnsafe.getUnsafe().copyMemory(this.pollArray.address(), newPollArray.address(), oldSize);
            this.pollArray.free();
            this.pollArray = newPollArray;
            this.pollArrayCapacity = newCapacity;
        }
    }

    private void putDescriptor(int i, int fd) {
        int offset = 8 * i + 0;
        this.pollArray.putInt(offset, fd);
    }

    private int getDescriptor(int i) {
        int offset = 8 * i + 0;
        return this.pollArray.getInt(offset);
    }

    private void putEventOps(int i, int event) {
        int offset = 8 * i + 4;
        this.pollArray.putShort(offset, (short)event);
    }

    private int getEventOps(int i) {
        int offset = 8 * i + 4;
        return this.pollArray.getShort(offset);
    }

    private void putReventOps(int i, int revent) {
        int offset = 8 * i + 6;
        this.pollArray.putShort(offset, (short)revent);
    }

    private int getReventOps(int i) {
        int offset = 8 * i + 6;
        return this.pollArray.getShort(offset);
    }

    private static native int poll(long var0, int var2, int var3);

    static {
        IOUtil.load();
    }
}

