/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.DelegatableDecoder;
import sun.nio.cs.DoubleByte;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.JIS_X_0201;
import sun.nio.cs.JIS_X_0208;
import sun.nio.cs.JIS_X_0212;
import sun.nio.cs.SingleByte;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;

public class EUC_JP
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP() {
        super("EUC-JP", StandardCharsets.aliases_EUC_JP());
    }

    @Override
    public String historicalName() {
        return "EUC_JP";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof JIS_X_0201 || cs instanceof JIS_X_0208 || cs instanceof JIS_X_0212 || cs instanceof EUC_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static class Encoder
    extends CharsetEncoder {
        static final SingleByte.Encoder ENC0201 = (SingleByte.Encoder)new JIS_X_0201().newEncoder();
        static final DoubleByte.Encoder ENC0208 = (DoubleByte.Encoder)new JIS_X_0208().newEncoder();
        static final DoubleByte.Encoder ENC0212 = (DoubleByte.Encoder)new JIS_X_0212().newEncoder();
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private final SingleByte.Encoder enc0201;
        private final DoubleByte.Encoder enc0208;
        private final DoubleByte.Encoder enc0212;

        protected Encoder(Charset cs) {
            this(cs, 3.0f, 3.0f, ENC0201, ENC0208, ENC0212);
        }

        protected Encoder(Charset cs, float avgBpc, float maxBpc, SingleByte.Encoder enc0201, DoubleByte.Encoder enc0208, DoubleByte.Encoder enc0212) {
            super(cs, avgBpc, maxBpc);
            this.enc0201 = enc0201;
            this.enc0208 = enc0208;
            this.enc0212 = enc0212;
        }

        @Override
        public boolean canEncode(char c) {
            byte[] encodedBytes = new byte[3];
            return this.encodeSingle(c, encodedBytes) != 0 || this.encodeDouble(c) != 65533;
        }

        protected int encodeSingle(char inputChar, byte[] outputByte) {
            int b = this.enc0201.encode(inputChar);
            if (b == 65533) {
                return 0;
            }
            if (b >= 0 && b < 128) {
                outputByte[0] = (byte)b;
                return 1;
            }
            outputByte[0] = -114;
            outputByte[1] = (byte)b;
            return 2;
        }

        protected int encodeDouble(char ch) {
            int b = this.enc0208.encodeChar(ch);
            if (b != 65533) {
                return b + 32896;
            }
            if (this.enc0212 != null && (b = this.enc0212.encodeChar(ch)) != 65533) {
                b += 0x8F8080;
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            int outputSize = 0;
            boolean inputSize = false;
            byte[] tmpBuf = new byte[3];
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; ++sp) {
                    byte[] outputByte = tmpBuf;
                    char c = sa[sp];
                    if (DesugarCharacter.isSurrogate(c)) {
                        if (this.sgp.parse(c, sa, sp, sl) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    outputSize = this.encodeSingle(c, outputByte);
                    if (outputSize == 0) {
                        int ncode = this.encodeDouble(c);
                        if (ncode != 65533) {
                            if ((ncode & 0xFF0000) == 0) {
                                outputByte[0] = (byte)((ncode & 0xFF00) >> 8);
                                outputByte[1] = (byte)(ncode & 0xFF);
                                outputSize = 2;
                            } else {
                                outputByte[0] = -113;
                                outputByte[1] = (byte)((ncode & 0xFF00) >> 8);
                                outputByte[2] = (byte)(ncode & 0xFF);
                                outputSize = 3;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (dl - dp < outputSize) {
                        CoderResult ncode = CoderResult.OVERFLOW;
                        return ncode;
                    }
                    for (int i = 0; i < outputSize; ++i) {
                        da[dp++] = outputByte[i];
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int outputSize = 0;
            boolean inputSize = false;
            byte[] tmpBuf = new byte[3];
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    byte[] outputByte = tmpBuf;
                    char c = src.get();
                    if (DesugarCharacter.isSurrogate(c)) {
                        if (this.sgp.parse(c, src) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    outputSize = this.encodeSingle(c, outputByte);
                    if (outputSize == 0) {
                        int ncode = this.encodeDouble(c);
                        if (ncode != 65533) {
                            if ((ncode & 0xFF0000) == 0) {
                                outputByte[0] = (byte)((ncode & 0xFF00) >> 8);
                                outputByte[1] = (byte)(ncode & 0xFF);
                                outputSize = 2;
                            } else {
                                outputByte[0] = -113;
                                outputByte[1] = (byte)((ncode & 0xFF00) >> 8);
                                outputByte[2] = (byte)(ncode & 0xFF);
                                outputSize = 3;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (dst.remaining() < outputSize) {
                        CoderResult ncode = CoderResult.OVERFLOW;
                        return ncode;
                    }
                    for (int i = 0; i < outputSize; ++i) {
                        dst.put(outputByte[i]);
                    }
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }

    static class Decoder
    extends CharsetDecoder
    implements DelegatableDecoder {
        static final SingleByte.Decoder DEC0201 = (SingleByte.Decoder)new JIS_X_0201().newDecoder();
        static final DoubleByte.Decoder DEC0208 = (DoubleByte.Decoder)new JIS_X_0208().newDecoder();
        static final DoubleByte.Decoder DEC0212 = (DoubleByte.Decoder)new JIS_X_0212().newDecoder();
        private final SingleByte.Decoder dec0201;
        private final DoubleByte.Decoder dec0208;
        private final DoubleByte.Decoder dec0212;

        protected Decoder(Charset cs) {
            this(cs, 0.5f, 1.0f, DEC0201, DEC0208, DEC0212);
        }

        protected Decoder(Charset cs, float avgCpb, float maxCpb, SingleByte.Decoder dec0201, DoubleByte.Decoder dec0208, DoubleByte.Decoder dec0212) {
            super(cs, avgCpb, maxCpb);
            this.dec0201 = dec0201;
            this.dec0208 = dec0208;
            this.dec0212 = dec0212;
        }

        protected char decodeDouble(int byte1, int byte2) {
            if (byte1 == 142) {
                if (byte2 < 128) {
                    return '\ufffd';
                }
                return this.dec0201.decode((byte)byte2);
            }
            return this.dec0208.decodeDouble(byte1 - 128, byte2 - 128);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            int b1 = 0;
            int b2 = 0;
            int inputSize = 0;
            int outputChar = 65533;
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; sp += inputSize) {
                    b1 = sa[sp] & 0xFF;
                    inputSize = 1;
                    if ((b1 & 0x80) == 0) {
                        outputChar = (char)b1;
                    } else if (b1 == 143) {
                        if (sp + 3 > sl) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        b1 = sa[sp + 1] & 0xFF;
                        b2 = sa[sp + 2] & 0xFF;
                        inputSize += 2;
                        if (this.dec0212 == null) {
                            CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                            return coderResult;
                        }
                        outputChar = this.dec0212.decodeDouble(b1 - 128, b2 - 128);
                    } else {
                        if (sp + 2 > sl) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        b2 = sa[sp + 1] & 0xFF;
                        ++inputSize;
                        outputChar = this.decodeDouble(b1, b2);
                    }
                    if (outputChar == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                        return coderResult;
                    }
                    if (dp + 1 > dl) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = outputChar;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            int b1 = 0;
            int b2 = 0;
            int inputSize = 0;
            char outputChar = '\ufffd';
            try {
                while (src.hasRemaining()) {
                    b1 = src.get() & 0xFF;
                    inputSize = 1;
                    if ((b1 & 0x80) == 0) {
                        outputChar = (char)b1;
                    } else if (b1 == 143) {
                        if (src.remaining() < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        b1 = src.get() & 0xFF;
                        b2 = src.get() & 0xFF;
                        inputSize += 2;
                        if (this.dec0212 == null) {
                            CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                            return coderResult;
                        }
                        outputChar = this.dec0212.decodeDouble(b1 - 128, b2 - 128);
                    } else {
                        if (src.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        b2 = src.get() & 0xFF;
                        ++inputSize;
                        outputChar = this.decodeDouble(b1, b2);
                    }
                    if (outputChar == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                        return coderResult;
                    }
                    if (dst.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    dst.put(outputChar);
                    mark += inputSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer out) {
            return super.implFlush(out);
        }
    }
}

