/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.lang.ref.Cleaner;
import jdk.internal.ref.CleanerFactory;
import sun.misc.DesugarUnsafe;
import sun.nio.fs.NativeBuffers;

class NativeBuffer {
    private static final DesugarUnsafe unsafe = DesugarUnsafe.getUnsafe();
    private final long address;
    private final int size;
    private final Cleaner.Cleanable cleanable;
    private Object owner;

    NativeBuffer(int size) {
        this.address = unsafe.allocateMemory(size);
        this.size = size;
        this.cleanable = CleanerFactory.cleaner().register(this, new Deallocator(this.address));
    }

    void release() {
        NativeBuffers.releaseNativeBuffer(this);
    }

    long address() {
        return this.address;
    }

    int size() {
        return this.size;
    }

    void free() {
        this.cleanable.clean();
    }

    void setOwner(Object owner) {
        this.owner = owner;
    }

    Object owner() {
        return this.owner;
    }

    private static class Deallocator
    implements Runnable {
        private final long address;

        Deallocator(long address) {
            this.address = address;
        }

        @Override
        public void run() {
            unsafe.freeMemory(this.address);
        }
    }
}

