/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;

public class DesugarAtomicLong {
    private DesugarAtomicLong() {
    }

    public static long getAndUpdate(AtomicLong atomic, LongUnaryOperator updateFunction) {
        long next;
        long prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = updateFunction.applyAsLong(prev))) {
        }
        return prev;
    }

    public static long updateAndGet(AtomicLong atomic, LongUnaryOperator updateFunction) {
        long next;
        long prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = updateFunction.applyAsLong(prev))) {
        }
        return next;
    }

    public static long getAndAccumulate(AtomicLong atomic, long x, LongBinaryOperator accumulatorFunction) {
        long next;
        long prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = accumulatorFunction.applyAsLong(prev, x))) {
        }
        return prev;
    }

    public static long accumulateAndGet(AtomicLong atomic, long x, LongBinaryOperator accumulatorFunction) {
        long next;
        long prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = accumulatorFunction.applyAsLong(prev, x))) {
        }
        return next;
    }
}

