/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Spliterator;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.PipelineHelper;

abstract class AbstractTask<P_IN, P_OUT, R, K extends AbstractTask<P_IN, P_OUT, R, K>>
extends CountedCompleter<R> {
    private static final int LEAF_TARGET = ForkJoinPool.getCommonPoolParallelism() << 2;
    protected final PipelineHelper<P_OUT> helper;
    protected Spliterator<P_IN> spliterator;
    protected long targetSize;
    protected K leftChild;
    protected K rightChild;
    private R localResult;

    protected AbstractTask(PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator) {
        super(null);
        this.helper = helper;
        this.spliterator = spliterator;
        this.targetSize = 0L;
    }

    protected AbstractTask(K parent, Spliterator<P_IN> spliterator) {
        super((CountedCompleter<?>)parent);
        this.spliterator = spliterator;
        this.helper = ((AbstractTask)parent).helper;
        this.targetSize = ((AbstractTask)parent).targetSize;
    }

    public static int getLeafTarget() {
        return LEAF_TARGET;
    }

    protected abstract K makeChild(Spliterator<P_IN> var1);

    protected abstract R doLeaf();

    public static long suggestTargetSize(long sizeEstimate) {
        long est = sizeEstimate / (long)AbstractTask.getLeafTarget();
        return est > 0L ? est : 1L;
    }

    protected final long getTargetSize(long sizeEstimate) {
        long s = this.targetSize;
        return s != 0L ? s : (this.targetSize = AbstractTask.suggestTargetSize(sizeEstimate));
    }

    @Override
    public R getRawResult() {
        return this.localResult;
    }

    @Override
    protected void setRawResult(R result) {
        if (result != null) {
            throw new IllegalStateException();
        }
    }

    protected R getLocalResult() {
        return this.localResult;
    }

    protected void setLocalResult(R localResult) {
        this.localResult = localResult;
    }

    protected boolean isLeaf() {
        return this.leftChild == null;
    }

    protected boolean isRoot() {
        return this.getParent() == null;
    }

    protected K getParent() {
        return (K)((AbstractTask)this.getCompleter());
    }

    @Override
    public void compute() {
        Spliterator<P_IN> ls;
        Spliterator<P_IN> rs = this.spliterator;
        long sizeEstimate = rs.estimateSize();
        long sizeThreshold = this.getTargetSize(sizeEstimate);
        boolean forkRight = false;
        AbstractTask<P_IN, P_OUT, R, K> task = this;
        while (sizeEstimate > sizeThreshold && (ls = rs.trySplit()) != null) {
            K taskToFork;
            K leftChild = task.makeChild(ls);
            task.leftChild = leftChild;
            K rightChild = task.makeChild(rs);
            task.rightChild = rightChild;
            task.setPendingCount(1);
            if (forkRight) {
                forkRight = false;
                rs = ls;
                task = leftChild;
                taskToFork = rightChild;
            } else {
                forkRight = true;
                task = rightChild;
                taskToFork = leftChild;
            }
            ((ForkJoinTask)taskToFork).fork();
            sizeEstimate = rs.estimateSize();
        }
        task.setLocalResult(task.doLeaf());
        task.tryComplete();
    }

    @Override
    public void onCompletion(CountedCompleter<?> caller) {
        this.spliterator = null;
        this.rightChild = null;
        this.leftChild = null;
    }

    protected boolean isLeftmostNode() {
        AbstractTask<P_IN, P_OUT, R, K> node = this;
        while (node != null) {
            K parent = node.getParent();
            if (parent != null && ((AbstractTask)parent).leftChild != node) {
                return false;
            }
            node = parent;
        }
        return true;
    }
}

