/*
 * Decompiled with CFR 0.152.
 */
package desugar.sun.nio.fs;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

class DesugarBasicFileAttributes
implements BasicFileAttributes {
    private final FileTime lastModifiedTime;
    private final FileTime lastAccessTime;
    private final FileTime creationTime;
    private final boolean isRegularFile;
    private final boolean isDirectory;
    private final boolean isSymbolicLink;
    private final boolean isOther;
    private final long size;
    private final Object fileKey;

    public static DesugarBasicFileAttributes create(File file) {
        FileTime lastModifiedTime = FileTime.from(file.lastModified(), TimeUnit.MILLISECONDS);
        boolean isRegularFile = file.isFile();
        boolean isDirectory = file.isDirectory();
        boolean isSymbolicLink = DesugarBasicFileAttributes.isSymlink(file);
        return new DesugarBasicFileAttributes(lastModifiedTime, lastModifiedTime, lastModifiedTime, isRegularFile, isDirectory, isSymbolicLink, !isRegularFile && !isDirectory && !isSymbolicLink, file.length(), file.hashCode());
    }

    public DesugarBasicFileAttributes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime, boolean isRegularFile, boolean isDirectory, boolean isSymbolicLink, boolean isOther, long size, Object fileKey) {
        this.lastModifiedTime = lastModifiedTime;
        this.lastAccessTime = lastAccessTime;
        this.creationTime = creationTime;
        this.isRegularFile = isRegularFile;
        this.isDirectory = isDirectory;
        this.isSymbolicLink = isSymbolicLink;
        this.isOther = isOther;
        this.size = size;
        this.fileKey = fileKey;
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public FileTime lastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public FileTime creationTime() {
        return this.creationTime;
    }

    @Override
    public boolean isRegularFile() {
        return this.isRegularFile;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.isSymbolicLink;
    }

    @Override
    public boolean isOther() {
        return this.isOther;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object fileKey() {
        return this.fileKey;
    }

    public static boolean isSymlink(File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        try {
            File canonicalFile;
            if (file.getParent() == null) {
                canonicalFile = file;
            } else {
                File canonicalDir = file.getParentFile().getCanonicalFile();
                canonicalFile = new File(canonicalDir, file.getName());
            }
            return !canonicalFile.getCanonicalFile().equals(canonicalFile.getAbsoluteFile());
        }
        catch (IOException e) {
            return false;
        }
    }
}

