/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface Path
extends Comparable<Path>,
Iterable<Path>,
Watchable {
    public static Path of(String first, String ... more) {
        return FileSystems.getDefault().getPath(first, more);
    }

    public static Path of(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Missing scheme");
        }
        if (scheme.equalsIgnoreCase("file")) {
            return FileSystems.getDefault().provider().getPath(uri);
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!provider.getScheme().equalsIgnoreCase(scheme)) continue;
            return provider.getPath(uri);
        }
        throw new FileSystemNotFoundException("Provider \"" + scheme + "\" not installed");
    }

    public FileSystem getFileSystem();

    public boolean isAbsolute();

    public Path getRoot();

    public Path getFileName();

    public Path getParent();

    public int getNameCount();

    public Path getName(int var1);

    public Path subpath(int var1, int var2);

    public boolean startsWith(Path var1);

    default public boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    public boolean endsWith(Path var1);

    default public boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    public Path normalize();

    public Path resolve(Path var1);

    default public Path resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    default public Path resolveSibling(Path other) {
        if (other == null) {
            throw new NullPointerException();
        }
        Path parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    default public Path resolveSibling(String other) {
        return this.resolveSibling(this.getFileSystem().getPath(other, new String[0]));
    }

    public Path relativize(Path var1);

    public URI toUri();

    public Path toAbsolutePath();

    public Path toRealPath(LinkOption ... var1) throws IOException;

    default public File toFile() {
        if (this.getFileSystem() == FileSystems.getDefault()) {
            return new File(this.toString());
        }
        throw new UnsupportedOperationException("Path not associated with default file system.");
    }

    @Override
    public WatchKey register(WatchService var1, WatchEvent.Kind<?>[] var2, WatchEvent.Modifier ... var3) throws IOException;

    @Override
    default public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }

    @Override
    default public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Path.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < Path.this.getNameCount()) {
                    Path result = Path.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int compareTo(Path var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

