/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Objects;

public final class DesugarDuration {
    static final int SECONDS_PER_DAY = 86400;
    static final int MINUTES_PER_HOUR = 60;
    static final long NANOS_PER_DAY = 86400000000000L;
    static final int SECONDS_PER_MINUTE = 60;

    public static long dividedBy(Duration receiver, Duration divisor) {
        Objects.requireNonNull(divisor, "divisor");
        BigDecimal dividendBigD = DesugarDuration.toBigDecimalSeconds(receiver);
        BigDecimal divisorBigD = DesugarDuration.toBigDecimalSeconds(divisor);
        return dividendBigD.divideToIntegralValue(divisorBigD).longValueExact();
    }

    public static long toSeconds(Duration receiver) {
        return receiver.getSeconds();
    }

    public static long toDaysPart(Duration receiver) {
        long seconds = receiver.getSeconds();
        return seconds / 86400L;
    }

    public static int toHoursPart(Duration receiver) {
        return (int)(receiver.toHours() % 24L);
    }

    public static int toMinutesPart(Duration receiver) {
        return (int)(receiver.toMinutes() % 60L);
    }

    public static int toSecondsPart(Duration receiver) {
        long seconds = receiver.getSeconds();
        return (int)(seconds % 60L);
    }

    public static int toMillisPart(Duration receiver) {
        int nanos = receiver.getNano();
        return nanos / 1000000;
    }

    public static int toNanosPart(Duration receiver) {
        int nanos = receiver.getNano();
        return nanos;
    }

    public static Duration truncatedTo(Duration receiver, TemporalUnit unit) {
        long seconds = receiver.getSeconds();
        int nanos = receiver.getNano();
        Objects.requireNonNull(unit, "unit");
        if (unit == ChronoUnit.SECONDS && (seconds >= 0L || nanos == 0)) {
            return Duration.ofSeconds(seconds);
        }
        if (unit == ChronoUnit.NANOS) {
            return receiver;
        }
        Duration unitDur = unit.getDuration();
        if (unitDur.getSeconds() > 86400L) {
            throw new UnsupportedTemporalTypeException("Unit is too large to be used for truncation");
        }
        long dur = unitDur.toNanos();
        if (86400000000000L % dur != 0L) {
            throw new UnsupportedTemporalTypeException("Unit must divide into a standard day without remainder");
        }
        long nod = seconds % 86400L * 1000000000L + (long)nanos;
        long result = nod / dur * dur;
        return receiver.plusNanos(result - nod);
    }

    private static BigDecimal toBigDecimalSeconds(Duration receiver) {
        long seconds = receiver.getSeconds();
        int nanos = receiver.getNano();
        return BigDecimal.valueOf(seconds).add(BigDecimal.valueOf(nanos, 9));
    }
}

