/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    private static final int DONE = Integer.MIN_VALUE;
    private static final int ABNORMAL = 262144;
    private static final int THROWN = 131072;
    private static final int SIGNAL = 65536;
    private static final int SMASK = 65535;
    private static final ExceptionNode[] exceptionTable = new ExceptionNode[32];
    private static final ReentrantLock exceptionTableLock = new ReentrantLock();
    private static final ReferenceQueue<ForkJoinTask<?>> exceptionTableRefQueue = new ReferenceQueue();
    private static final long serialVersionUID = -7721805057305804111L;
    private static final VarHandle STATUS;

    static boolean isExceptionalStatus(int s) {
        return (s & 0x20000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setDone() {
        int s = STATUS.getAndBitwiseOr(this, Integer.MIN_VALUE);
        if ((s & 0x10000) != 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
            }
        }
        return s | Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abnormalCompletion(int completion) {
        int ns;
        int s;
        do {
            if ((s = this.status) >= 0) continue;
            return s;
        } while (!STATUS.weakCompareAndSet(this, s, ns = s | completion));
        if ((s & 0x10000) != 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
            }
        }
        return ns;
    }

    final int doExec() {
        int s = this.status;
        if (s >= 0) {
            boolean completed;
            try {
                completed = this.exec();
            }
            catch (Throwable rex) {
                completed = false;
                s = this.setExceptionalCompletion(rex);
            }
            if (completed) {
                s = this.setDone();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalWait(long timeout) {
        if (STATUS.getAndBitwiseOr(this, 65536) >= 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                if (this.status >= 0) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalAwaitDone() {
        int s = this.tryExternalHelp();
        if (s >= 0 && (s = STATUS.getAndBitwiseOr(this, 65536)) >= 0) {
            boolean interrupted = false;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                while ((s = this.status) >= 0) {
                    try {
                        this.wait(0L);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
                this.notifyAll();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalInterruptibleAwaitDone() throws InterruptedException {
        int s = this.tryExternalHelp();
        if (s >= 0 && (s = STATUS.getAndBitwiseOr(this, 65536)) >= 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                while ((s = this.status) >= 0) {
                    this.wait(0L);
                }
                this.notifyAll();
            }
        } else if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return s;
    }

    private int tryExternalHelp() {
        int s = this.status;
        return s < 0 ? s : (this instanceof CountedCompleter ? ForkJoinPool.common.externalHelpComplete((CountedCompleter)this, 0) : (ForkJoinPool.common.tryExternalUnpush(this) ? this.doExec() : 0));
    }

    private int doJoin() {
        int n;
        int s = this.status;
        if (s < 0) {
            n = s;
        } else {
            Thread t = Thread.currentThread();
            if (t instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
                ForkJoinPool.WorkQueue w = wt.workQueue;
                n = w.tryUnpush(this) && (s = this.doExec()) < 0 ? s : wt.pool.awaitJoin(w, this, 0L);
            } else {
                n = this.externalAwaitDone();
            }
        }
        return n;
    }

    private int doInvoke() {
        int n;
        int s = this.doExec();
        if (s < 0) {
            n = s;
        } else {
            Thread t = Thread.currentThread();
            if (t instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
                n = wt.pool.awaitJoin(wt.workQueue, this, 0L);
            } else {
                n = this.externalAwaitDone();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int recordExceptionalCompletion(Throwable ex) {
        int s = this.status;
        if (s >= 0) {
            int h = System.identityHashCode(this);
            ReentrantLock lock = exceptionTableLock;
            lock.lock();
            try {
                ForkJoinTask.expungeStaleExceptions();
                ExceptionNode[] t = exceptionTable;
                int i = h & t.length - 1;
                ExceptionNode e = t[i];
                while (true) {
                    if (e == null) {
                        t[i] = new ExceptionNode(this, ex, t[i], exceptionTableRefQueue);
                        break;
                    }
                    if (e.get() == this) {
                        break;
                    }
                    e = e.next;
                }
            }
            finally {
                lock.unlock();
            }
            s = this.abnormalCompletion(-2147090432);
        }
        return s;
    }

    private int setExceptionalCompletion(Throwable ex) {
        int s = this.recordExceptionalCompletion(ex);
        if ((s & 0x20000) != 0) {
            this.internalPropagateException(ex);
        }
        return s;
    }

    void internalPropagateException(Throwable ex) {
    }

    static final void cancelIgnoringExceptions(ForkJoinTask<?> t) {
        if (t != null && t.status >= 0) {
            try {
                t.cancel(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExceptionalCompletion() {
        int h = System.identityHashCode(this);
        ReentrantLock lock = exceptionTableLock;
        lock.lock();
        try {
            ExceptionNode[] t = exceptionTable;
            int i = h & t.length - 1;
            ExceptionNode e = t[i];
            ExceptionNode pred = null;
            while (e != null) {
                ExceptionNode next = e.next;
                if (e.get() == this) {
                    if (pred == null) {
                        t[i] = next;
                        break;
                    }
                    pred.next = next;
                    break;
                }
                pred = e;
                e = next;
            }
            ForkJoinTask.expungeStaleExceptions();
            this.status = 0;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getThrowableException() {
        Throwable ex;
        ExceptionNode e;
        int h = System.identityHashCode(this);
        ReentrantLock lock = exceptionTableLock;
        lock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            ExceptionNode[] t = exceptionTable;
            e = t[h & t.length - 1];
            while (e != null && e.get() != this) {
                e = e.next;
            }
        }
        finally {
            lock.unlock();
        }
        if (e == null || (ex = e.ex) == null) {
            return null;
        }
        if (e.thrower != Thread.currentThread().getId()) {
            try {
                Constructor<?> noArgCtor = null;
                for (Constructor<?> c : ex.getClass().getConstructors()) {
                    Class<?>[] ps = c.getParameterTypes();
                    if (ps.length == 0) {
                        noArgCtor = c;
                        continue;
                    }
                    if (ps.length != 1 || ps[0] != Throwable.class) continue;
                    return (Throwable)c.newInstance(ex);
                }
                if (noArgCtor != null) {
                    Throwable wx = (Throwable)noArgCtor.newInstance(new Object[0]);
                    wx.initCause(ex);
                    return wx;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ex;
    }

    private static void expungeStaleExceptions() {
        Reference<ForkJoinTask<?>> x;
        block0: while ((x = exceptionTableRefQueue.poll()) != null) {
            if (!(x instanceof ExceptionNode)) continue;
            ExceptionNode[] t = exceptionTable;
            int i = ((ExceptionNode)x).hashCode & t.length - 1;
            ExceptionNode e = t[i];
            ExceptionNode pred = null;
            while (e != null) {
                ExceptionNode next = e.next;
                if (e == x) {
                    if (pred == null) {
                        t[i] = next;
                        continue block0;
                    }
                    pred.next = next;
                    continue block0;
                }
                pred = e;
                e = next;
            }
        }
    }

    static final void helpExpungeStaleExceptions() {
        ReentrantLock lock = exceptionTableLock;
        if (lock.tryLock()) {
            try {
                ForkJoinTask.expungeStaleExceptions();
            }
            finally {
                lock.unlock();
            }
        }
    }

    static void rethrow(Throwable ex) {
        ForkJoinTask.uncheckedThrow(ex);
    }

    static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        if (t != null) {
            throw t;
        }
        throw new Error("Unknown Exception");
    }

    private void reportException(int s) {
        ForkJoinTask.rethrow((s & 0x20000) != 0 ? this.getThrowableException() : new CancellationException());
    }

    public final ForkJoinTask<V> fork() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ((ForkJoinWorkerThread)t).workQueue.push(this);
        } else {
            ForkJoinPool.common.externalPush(this);
        }
        return this;
    }

    public final V join() {
        int s = this.doJoin();
        if ((s & 0x40000) != 0) {
            this.reportException(s);
        }
        return this.getRawResult();
    }

    public final V invoke() {
        int s = this.doInvoke();
        if ((s & 0x40000) != 0) {
            this.reportException(s);
        }
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> t1, ForkJoinTask<?> t2) {
        int s2;
        t2.fork();
        int s1 = t1.doInvoke();
        if ((s1 & 0x40000) != 0) {
            t1.reportException(s1);
        }
        if (((s2 = t2.doJoin()) & 0x40000) != 0) {
            t2.reportException(s2);
        }
    }

    public static void invokeAll(ForkJoinTask<?> ... tasks) {
        ForkJoinTask<?> t;
        int last;
        int i;
        Throwable ex = null;
        for (i = last = tasks.length - 1; i >= 0; --i) {
            t = tasks[i];
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            if ((t.doInvoke() & 0x40000) == 0 || ex != null) continue;
            ex = t.getException();
        }
        for (i = 1; i <= last; ++i) {
            t = tasks[i];
            if (t == null) continue;
            if (ex != null) {
                t.cancel(false);
                continue;
            }
            if ((t.doJoin() & 0x40000) == 0) continue;
            ex = t.getException();
        }
        if (ex != null) {
            ForkJoinTask.rethrow(ex);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> tasks) {
        ForkJoinTask t;
        int last;
        int i;
        if (!(tasks instanceof RandomAccess) || !(tasks instanceof List)) {
            ForkJoinTask.invokeAll(tasks.toArray(new ForkJoinTask[0]));
            return tasks;
        }
        List ts = (List)tasks;
        Throwable ex = null;
        for (i = last = ts.size() - 1; i >= 0; --i) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            if ((t.doInvoke() & 0x40000) == 0 || ex != null) continue;
            ex = t.getException();
        }
        for (i = 1; i <= last; ++i) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) continue;
            if (ex != null) {
                t.cancel(false);
                continue;
            }
            if ((t.doJoin() & 0x40000) == 0) continue;
            ex = t.getException();
        }
        if (ex != null) {
            ForkJoinTask.rethrow(ex);
        }
        return tasks;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        int s = this.abnormalCompletion(-2147221504);
        return (s & 0x60000) == 262144;
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0x60000) == 262144;
    }

    public final boolean isCompletedAbnormally() {
        return (this.status & 0x40000) != 0;
    }

    public final boolean isCompletedNormally() {
        return (this.status & 0x80040000) == Integer.MIN_VALUE;
    }

    public final Throwable getException() {
        int s = this.status;
        return (s & 0x40000) == 0 ? null : ((s & 0x20000) == 0 ? new CancellationException() : this.getThrowableException());
    }

    public void completeExceptionally(Throwable ex) {
        this.setExceptionalCompletion(ex instanceof RuntimeException || ex instanceof Error ? ex : new RuntimeException(ex));
    }

    public void complete(V value) {
        try {
            this.setRawResult(value);
        }
        catch (Throwable rex) {
            this.setExceptionalCompletion(rex);
            return;
        }
        this.setDone();
    }

    public final void quietlyComplete() {
        this.setDone();
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        int s;
        int n = s = Thread.currentThread() instanceof ForkJoinWorkerThread ? this.doJoin() : this.externalInterruptibleAwaitDone();
        if ((s & 0x20000) != 0) {
            throw new ExecutionException(this.getThrowableException());
        }
        if ((s & 0x40000) != 0) {
            throw new CancellationException();
        }
        return this.getRawResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int s = this.status;
        if (s >= 0 && nanos > 0L) {
            long d = System.nanoTime() + nanos;
            long deadline = d == 0L ? 1L : d;
            Thread t = Thread.currentThread();
            if (t instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
                s = wt.pool.awaitJoin(wt.workQueue, this, deadline);
            } else if ((this instanceof CountedCompleter ? ForkJoinPool.common.externalHelpComplete((CountedCompleter)this, 0) : (s = ForkJoinPool.common.tryExternalUnpush(this) ? this.doExec() : 0)) >= 0) {
                long ns;
                while ((s = this.status) >= 0 && (ns = deadline - System.nanoTime()) > 0L) {
                    long ms = TimeUnit.NANOSECONDS.toMillis(ns);
                    if (ms <= 0L || (s = STATUS.getAndBitwiseOr(this, 65536)) < 0) continue;
                    ForkJoinTask forkJoinTask = this;
                    synchronized (forkJoinTask) {
                        if (this.status >= 0) {
                            this.wait(ms);
                        } else {
                            this.notifyAll();
                        }
                    }
                }
            }
        }
        if (s >= 0) {
            throw new TimeoutException();
        }
        if ((s & 0x20000) != 0) {
            throw new ExecutionException(this.getThrowableException());
        }
        if ((s & 0x40000) != 0) {
            throw new CancellationException();
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        this.doJoin();
    }

    public final void quietlyInvoke() {
        this.doInvoke();
    }

    public static void helpQuiesce() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            wt.pool.helpQuiescePool(wt.workQueue);
        } else {
            ForkJoinPool.quiesceCommonPool();
        }
    }

    public void reinitialize() {
        if ((this.status & 0x20000) != 0) {
            this.clearExceptionalCompletion();
        } else {
            this.status = 0;
        }
    }

    public static ForkJoinPool getPool() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).workQueue.tryUnpush(this) : ForkJoinPool.common.tryExternalUnpush(this);
    }

    public static int getQueuedTaskCount() {
        Thread t = Thread.currentThread();
        ForkJoinPool.WorkQueue q = t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).workQueue : ForkJoinPool.commonSubmitterQueue();
        return q == null ? 0 : q.queueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ForkJoinPool.getSurplusQueuedTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        Thread t = Thread.currentThread();
        ForkJoinPool.WorkQueue q = t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).workQueue : ForkJoinPool.commonSubmitterQueue();
        return q == null ? null : q.peek();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).workQueue.nextLocalTask() : null;
    }

    protected static ForkJoinTask<?> pollTask() {
        ForkJoinTask<?> forkJoinTask;
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            forkJoinTask = wt.pool.nextTaskFor(wt.workQueue);
        } else {
            forkJoinTask = null;
        }
        return forkJoinTask;
    }

    protected static ForkJoinTask<?> pollSubmission() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool.pollSubmission() : null;
    }

    public final short getForkJoinTaskTag() {
        return (short)this.status;
    }

    public final short setForkJoinTaskTag(short newValue) {
        int s;
        while (!STATUS.weakCompareAndSet(this, s = this.status, s & 0xFFFF0000 | newValue & 0xFFFF)) {
        }
        return (short)s;
    }

    public final boolean compareAndSetForkJoinTaskTag(short expect, short update) {
        int s;
        do {
            if ((short)(s = this.status) == expect) continue;
            return false;
        } while (!STATUS.weakCompareAndSet(this, s, s & 0xFFFF0000 | update & 0xFFFF));
        return true;
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new AdaptedRunnableAction(runnable);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T result) {
        return new AdaptedRunnable<T>(runnable, result);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object ex = s.readObject();
        if (ex != null) {
            this.setExceptionalCompletion((Throwable)ex);
        }
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            STATUS = l.findVarHandle(ForkJoinTask.class, "status", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public final boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.callable + "]";
        }
    }

    static final class RunnableExecuteAction
    extends ForkJoinTask<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        RunnableExecuteAction(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        void internalPropagateException(Throwable ex) {
            RunnableExecuteAction.rethrow(ex);
        }
    }

    static final class AdaptedRunnableAction
    extends ForkJoinTask<Void>
    implements RunnableFuture<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnableAction(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.runnable + "]";
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T result) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.result = result;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.runnable + "]";
        }
    }

    static final class ExceptionNode
    extends WeakReference<ForkJoinTask<?>> {
        final Throwable ex;
        ExceptionNode next;
        final long thrower;
        final int hashCode;

        ExceptionNode(ForkJoinTask<?> task, Throwable ex, ExceptionNode next, ReferenceQueue<ForkJoinTask<?>> exceptionTableRefQueue) {
            super(task, exceptionTableRefQueue);
            this.ex = ex;
            this.next = next;
            this.thrower = Thread.currentThread().getId();
            this.hashCode = System.identityHashCode(task);
        }
    }
}

