/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public class SubmissionPublisher<T>
implements Flow.Publisher<T>,
AutoCloseable {
    static final int BUFFER_CAPACITY_LIMIT = 0x40000000;
    static final int INITIAL_CAPACITY = 32;
    private static final Executor ASYNC_POOL = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();
    BufferedSubscription<T> clients;
    volatile boolean closed;
    boolean subscribed;
    Thread owner;
    volatile Throwable closedException;
    final Executor executor;
    final BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler;
    final int maxBufferCapacity;

    static final int roundCapacity(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) <= 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public SubmissionPublisher(Executor executor, int maxBufferCapacity, BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> handler) {
        if (executor == null) {
            throw new NullPointerException();
        }
        if (maxBufferCapacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.executor = executor;
        this.onNextHandler = handler;
        this.maxBufferCapacity = SubmissionPublisher.roundCapacity(maxBufferCapacity);
    }

    public SubmissionPublisher(Executor executor, int maxBufferCapacity) {
        this(executor, maxBufferCapacity, null);
    }

    public SubmissionPublisher() {
        this(ASYNC_POOL, Flow.defaultBufferSize(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        int max = this.maxBufferCapacity;
        Object[] array = new Object[max < 32 ? max : 32];
        BufferedSubscription<T> subscription = new BufferedSubscription<T>(subscriber, this.executor, this.onNextHandler, array, max);
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            if (!this.subscribed) {
                this.subscribed = true;
                this.owner = Thread.currentThread();
            }
            BufferedSubscription<T> b = this.clients;
            BufferedSubscription<T> pred = null;
            while (true) {
                if (b == null) {
                    subscription.onSubscribe();
                    Throwable ex = this.closedException;
                    if (ex != null) {
                        subscription.onError(ex);
                        break;
                    }
                    if (this.closed) {
                        subscription.onComplete();
                        break;
                    }
                    if (pred == null) {
                        this.clients = subscription;
                        break;
                    }
                    pred.next = subscription;
                    break;
                }
                BufferedSubscription next = b.next;
                if (b.isClosed()) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (subscriber.equals(b.subscriber)) {
                        b.onError(new IllegalStateException("Duplicate subscribe"));
                        break;
                    }
                    pred = b;
                }
                b = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doOffer(T item, long nanos, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        boolean complete;
        if (item == null) {
            throw new NullPointerException();
        }
        int lag = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            Thread t = Thread.currentThread();
            BufferedSubscription<T> b = this.clients;
            Thread o = this.owner;
            boolean unowned = o != t;
            if (unowned && o != null) {
                this.owner = null;
            }
            if (b == null) {
                complete = this.closed;
            } else {
                BufferedSubscription next;
                complete = false;
                boolean cleanMe = false;
                BufferedSubscription<T> retries = null;
                BufferedSubscription<T> rtail = null;
                do {
                    next = b.next;
                    int stat = b.offer(item, unowned);
                    if (stat == 0) {
                        b.nextRetry = null;
                        if (rtail == null) {
                            retries = b;
                        } else {
                            rtail.nextRetry = b;
                        }
                        rtail = b;
                        continue;
                    }
                    if (stat < 0) {
                        cleanMe = true;
                        continue;
                    }
                    if (stat <= lag) continue;
                    lag = stat;
                } while ((b = next) != null);
                if (retries != null || cleanMe) {
                    lag = this.retryOffer(item, nanos, onDrop, retries, lag, cleanMe);
                }
            }
        }
        if (complete) {
            throw new IllegalStateException("Closed");
        }
        return lag;
    }

    private int retryOffer(T item, long nanos, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop, BufferedSubscription<T> retries, int lag, boolean cleanMe) {
        BufferedSubscription<T> r = retries;
        while (r != null) {
            int stat;
            BufferedSubscription nextRetry = r.nextRetry;
            r.nextRetry = null;
            if (nanos > 0L) {
                r.awaitSpace(nanos);
            }
            if ((stat = r.retryOffer(item)) == 0 && onDrop != null && onDrop.test(r.subscriber, item)) {
                stat = r.retryOffer(item);
            }
            if (stat == 0) {
                lag = lag >= 0 ? -1 : lag - 1;
            } else if (stat < 0) {
                cleanMe = true;
            } else if (lag >= 0 && stat > lag) {
                lag = stat;
            }
            r = nextRetry;
        }
        if (cleanMe) {
            this.cleanAndCount();
        }
        return lag;
    }

    private int cleanAndCount() {
        int count = 0;
        BufferedSubscription<T> pred = null;
        BufferedSubscription<T> b = this.clients;
        while (b != null) {
            BufferedSubscription next = b.next;
            if (b.isClosed()) {
                b.next = null;
                if (pred == null) {
                    this.clients = next;
                } else {
                    pred.next = next;
                }
            } else {
                pred = b;
                ++count;
            }
            b = next;
        }
        return count;
    }

    public int submit(T item) {
        return this.doOffer(item, Long.MAX_VALUE, null);
    }

    public int offer(T item, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        return this.doOffer(item, 0L, onDrop);
    }

    public int offer(T item, long timeout, TimeUnit unit, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        long nanos = unit.toNanos(timeout);
        if (nanos == Long.MAX_VALUE) {
            --nanos;
        }
        return this.doOffer(item, nanos, onDrop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            BufferedSubscription<T> b;
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                b = this.clients;
                this.clients = null;
                this.owner = null;
                this.closed = true;
            }
            while (b != null) {
                BufferedSubscription next = b.next;
                b.next = null;
                b.onComplete();
                b = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeExceptionally(Throwable error) {
        if (error == null) {
            throw new NullPointerException();
        }
        if (!this.closed) {
            BufferedSubscription<T> b;
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                b = this.clients;
                if (!this.closed) {
                    this.closedException = error;
                    this.clients = null;
                    this.owner = null;
                    this.closed = true;
                }
            }
            while (b != null) {
                BufferedSubscription next = b.next;
                b.next = null;
                b.onError(error);
                b = next;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Throwable getClosedException() {
        return this.closedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscribers() {
        boolean nonEmpty = false;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                if (b.isClosed()) {
                    b.next = null;
                    this.clients = next;
                    b = this.clients;
                    continue;
                }
                nonEmpty = true;
                break;
            }
        }
        return nonEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSubscribers() {
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            return this.cleanAndCount();
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getMaxBufferCapacity() {
        return this.maxBufferCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Flow.Subscriber<? super T>> getSubscribers() {
        ArrayList<Flow.Subscriber<T>> subs = new ArrayList<Flow.Subscriber<T>>();
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                if (b.isClosed()) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    subs.add(b.subscriber);
                    pred = b;
                }
                b = next;
            }
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        if (!this.closed) {
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> b = this.clients;
                while (b != null) {
                    BufferedSubscription next = b.next;
                    if (b.isClosed()) {
                        b.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        if (subscriber.equals(b.subscriber)) {
                            return true;
                        }
                        pred = b;
                    }
                    b = next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long estimateMinimumDemand() {
        long min = Long.MAX_VALUE;
        boolean nonEmpty = false;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                int n = b.estimateLag();
                if (n < 0) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    long d = b.demand - (long)n;
                    if (d < min) {
                        min = d;
                    }
                    nonEmpty = true;
                    pred = b;
                }
                b = next;
            }
        }
        return nonEmpty ? min : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int estimateMaximumLag() {
        int max = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                int n = b.estimateLag();
                if (n < 0) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (n > max) {
                        max = n;
                    }
                    pred = b;
                }
                b = next;
            }
        }
        return max;
    }

    public CompletableFuture<Void> consume(Consumer<? super T> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> status = new CompletableFuture<Void>();
        this.subscribe(new ConsumerSubscriber<T>(status, consumer));
        return status;
    }

    static final class BufferedSubscription<T>
    implements Flow.Subscription,
    ForkJoinPool.ManagedBlocker {
        long timeout;
        int head;
        int tail;
        final int maxCapacity;
        volatile int ctl;
        Object[] array;
        final Flow.Subscriber<? super T> subscriber;
        final BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler;
        Executor executor;
        Thread waiter;
        Throwable pendingError;
        BufferedSubscription<T> next;
        BufferedSubscription<T> nextRetry;
        volatile long demand;
        volatile int waiting;
        static final int CLOSED = 1;
        static final int ACTIVE = 2;
        static final int REQS = 4;
        static final int ERROR = 8;
        static final int COMPLETE = 16;
        static final int RUN = 32;
        static final int OPEN = 64;
        static final long INTERRUPTED = -1L;
        static final VarHandle CTL;
        static final VarHandle DEMAND;
        static final VarHandle QA;

        BufferedSubscription(Flow.Subscriber<? super T> subscriber, Executor executor, BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler, Object[] array, int maxBufferCapacity) {
            this.subscriber = subscriber;
            this.executor = executor;
            this.onNextHandler = onNextHandler;
            this.array = array;
            this.maxCapacity = maxBufferCapacity;
        }

        final boolean weakCasCtl(int cmp, int val) {
            return CTL.weakCompareAndSet(this, cmp, val);
        }

        final int getAndBitwiseOrCtl(int bits) {
            return CTL.getAndBitwiseOr(this, bits);
        }

        final long subtractDemand(int k) {
            long n = -k;
            return n + DEMAND.getAndAdd(this, n);
        }

        final boolean casDemand(long cmp, long val) {
            return DEMAND.compareAndSet(this, cmp, val);
        }

        final boolean isClosed() {
            return (this.ctl & 1) != 0;
        }

        final int estimateLag() {
            int c = this.ctl;
            int n = this.tail - this.head;
            return (c & 1) != 0 ? -1 : (n < 0 ? 0 : n);
        }

        final int offer(T item, boolean unowned) {
            int stat = 0;
            Object[] a = this.array;
            int cap = this.array == null ? 0 : a.length;
            int t = this.tail;
            int i = t & cap - 1;
            int n = t + 1 - this.head;
            if (cap > 0) {
                boolean added;
                if (n >= cap && cap < this.maxCapacity) {
                    added = this.growAndOffer(item, a, t);
                } else if (n >= cap || unowned) {
                    added = QA.compareAndSet(a, i, null, item);
                } else {
                    QA.setRelease(a, i, item);
                    added = true;
                }
                if (added) {
                    this.tail = t + 1;
                    stat = n;
                }
            }
            return this.startOnOffer(stat);
        }

        final boolean growAndOffer(T item, Object[] a, int t) {
            int mask;
            Object x;
            int cap = 0;
            int newCap = 0;
            Object[] newArray = null;
            if (a != null && (cap = a.length) > 0 && (newCap = cap << 1) > 0) {
                try {
                    newArray = new Object[newCap];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
            }
            if (newArray == null) {
                return false;
            }
            int newMask = newCap - 1;
            newArray[t-- & newMask] = item;
            for (int k = mask = cap - 1; k >= 0 && (x = QA.getAndSet(a, t & mask, null)) != null; --k) {
                newArray[t-- & newMask] = x;
            }
            this.array = newArray;
            VarHandle.releaseFence();
            return true;
        }

        final int retryOffer(T item) {
            int cap;
            int stat = 0;
            int t = this.tail;
            int h = this.head;
            Object[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && QA.compareAndSet(a, cap - 1 & t, null, item)) {
                this.tail = t + 1;
                stat = this.tail - h;
            }
            return this.startOnOffer(stat);
        }

        final int startOnOffer(int stat) {
            int c = this.ctl;
            if ((c & 6) == 4 && ((c = this.getAndBitwiseOrCtl(34)) & 0x21) == 0) {
                this.tryStart();
            } else if ((c & 1) != 0) {
                stat = -1;
            }
            return stat;
        }

        final void tryStart() {
            try {
                ConsumerTask task = new ConsumerTask(this);
                Executor e = this.executor;
                if (e != null) {
                    e.execute(task);
                }
            }
            catch (Error | RuntimeException ex) {
                this.getAndBitwiseOrCtl(9);
                throw ex;
            }
        }

        final void startOnSignal(int bits) {
            if ((this.ctl & bits) != bits && (this.getAndBitwiseOrCtl(bits) & 0x21) == 0) {
                this.tryStart();
            }
        }

        final void onSubscribe() {
            this.startOnSignal(34);
        }

        final void onComplete() {
            this.startOnSignal(50);
        }

        final void onError(Throwable ex) {
            int c;
            if (ex != null) {
                this.pendingError = ex;
            }
            if (((c = this.getAndBitwiseOrCtl(42)) & 1) == 0) {
                if ((c & 0x20) == 0) {
                    this.tryStart();
                } else {
                    Object[] a = this.array;
                    if (this.array != null) {
                        Arrays.fill(a, null);
                    }
                }
            }
        }

        @Override
        public final void cancel() {
            this.onError(null);
        }

        @Override
        public final void request(long n) {
            if (n > 0L) {
                long d;
                long p;
                while (!this.casDemand(p, (d = (p = this.demand) + n) < p ? Long.MAX_VALUE : d)) {
                }
                this.startOnSignal(38);
            } else {
                this.onError(new IllegalArgumentException("non-positive subscription request"));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void consume() {
            Flow.Subscriber<? super T> s = this.subscriber;
            if (s == null) return;
            this.subscribeOnOpen(s);
            long d = this.demand;
            int h = this.head;
            int t = this.tail;
            while (true) {
                int bit;
                int c;
                if (((c = this.ctl) & 8) != 0) {
                    this.closeOnError(s, null);
                    return;
                }
                int taken = this.takeItems(s, d, h);
                if (taken > 0) {
                    this.head = h += taken;
                    d = this.subtractDemand(taken);
                    continue;
                }
                d = this.demand;
                if (d == 0L && (c & 4) != 0) {
                    this.weakCasCtl(c, c & 0xFFFFFFFB);
                    continue;
                }
                if (d != 0L && (c & 4) == 0) {
                    this.weakCasCtl(c, c | 4);
                    continue;
                }
                if (t != (t = this.tail)) continue;
                boolean empty = t == h;
                if (empty && (c & 0x10) != 0) {
                    this.closeOnComplete(s);
                    return;
                }
                if ((empty || d == 0L) && this.weakCasCtl(c, c & ~(bit = (c & 2) != 0 ? 2 : 32)) && bit == 32) return;
            }
        }

        final int takeItems(Flow.Subscriber<? super T> s, long d, int h) {
            int k;
            int cap;
            Object[] a = this.array;
            if (this.array != null && (cap = a.length) > 0) {
                int n;
                int m = cap - 1;
                int b = (m >>> 3) + 1;
                int n2 = n = d < (long)b ? (int)d : b;
                for (k = 0; k < n; ++k) {
                    Object x = QA.getAndSet(a, h & m, null);
                    if (this.waiting != 0) {
                        this.signalWaiter();
                    }
                    if (x == null || !this.consumeNext(s, x)) break;
                    ++h;
                }
            }
            return k;
        }

        final boolean consumeNext(Flow.Subscriber<? super T> s, Object x) {
            try {
                Object y = x;
                if (s != null) {
                    s.onNext(y);
                }
                return true;
            }
            catch (Throwable ex) {
                this.handleOnNext(s, ex);
                return false;
            }
        }

        final void handleOnNext(Flow.Subscriber<? super T> s, Throwable ex) {
            try {
                BiConsumer<Flow.Subscriber<Flow.Subscriber<? super T>>, Throwable> h = this.onNextHandler;
                if (h != null) {
                    h.accept(s, ex);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.closeOnError(s, ex);
        }

        final void subscribeOnOpen(Flow.Subscriber<? super T> s) {
            if ((this.ctl & 0x40) == 0 && (this.getAndBitwiseOrCtl(64) & 0x40) == 0) {
                this.consumeSubscribe(s);
            }
        }

        final void consumeSubscribe(Flow.Subscriber<? super T> s) {
            try {
                if (s != null) {
                    s.onSubscribe(this);
                }
            }
            catch (Throwable ex) {
                this.closeOnError(s, ex);
            }
        }

        final void closeOnComplete(Flow.Subscriber<? super T> s) {
            if ((this.getAndBitwiseOrCtl(1) & 1) == 0) {
                this.consumeComplete(s);
            }
        }

        final void consumeComplete(Flow.Subscriber<? super T> s) {
            try {
                if (s != null) {
                    s.onComplete();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        final void closeOnError(Flow.Subscriber<? super T> s, Throwable ex) {
            if ((this.getAndBitwiseOrCtl(9) & 1) == 0) {
                if (ex == null) {
                    ex = this.pendingError;
                }
                this.pendingError = null;
                this.executor = null;
                this.signalWaiter();
                this.consumeError(s, ex);
            }
        }

        final void consumeError(Flow.Subscriber<? super T> s, Throwable ex) {
            try {
                if (ex != null && s != null) {
                    s.onError(ex);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        final void signalWaiter() {
            this.waiting = 0;
            Thread w = this.waiter;
            if (w != null) {
                LockSupport.unpark(w);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean isReleasable() {
            if ((this.ctl & 1) != 0) return true;
            Object[] a = this.array;
            if (this.array == null) return false;
            int cap = a.length;
            if (cap <= 0) return false;
            if (QA.getAcquire(a, cap - 1 & this.tail) != null) return false;
            return true;
        }

        final void awaitSpace(long nanos) {
            if (!this.isReleasable()) {
                ForkJoinPool.helpAsyncBlocker(this.executor, this);
                if (!this.isReleasable()) {
                    this.timeout = nanos;
                    try {
                        ForkJoinPool.managedBlock(this);
                    }
                    catch (InterruptedException ie) {
                        this.timeout = -1L;
                    }
                    if (this.timeout == -1L) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        @Override
        public final boolean block() {
            long deadline;
            long nanos = this.timeout;
            boolean timed = nanos < Long.MAX_VALUE;
            long l = deadline = timed ? System.nanoTime() + nanos : 0L;
            while (!this.isReleasable()) {
                if (Thread.interrupted()) {
                    this.timeout = -1L;
                    if (!timed) continue;
                    break;
                }
                if (timed && (nanos = deadline - System.nanoTime()) <= 0L) break;
                if (this.waiter == null) {
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (this.waiting == 0) {
                    this.waiting = 1;
                    continue;
                }
                if (timed) {
                    LockSupport.parkNanos(this, nanos);
                    continue;
                }
                LockSupport.park(this);
            }
            this.waiter = null;
            this.waiting = 0;
            return true;
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                CTL = l.findVarHandle(BufferedSubscription.class, "ctl", Integer.TYPE);
                DEMAND = l.findVarHandle(BufferedSubscription.class, "demand", Long.TYPE);
                QA = MethodHandles.arrayElementVarHandle(Object[].class);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
            Class<LockSupport> clazz = LockSupport.class;
        }
    }

    static final class ConsumerTask<T>
    extends ForkJoinTask<Void>
    implements Runnable,
    CompletableFuture.AsynchronousCompletionTask {
        final BufferedSubscription<T> consumer;

        ConsumerTask(BufferedSubscription<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.consumer.consume();
            return false;
        }

        @Override
        public final void run() {
            this.consumer.consume();
        }
    }

    static final class ConsumerSubscriber<T>
    implements Flow.Subscriber<T> {
        final CompletableFuture<Void> status;
        final Consumer<? super T> consumer;
        Flow.Subscription subscription;

        ConsumerSubscriber(CompletableFuture<Void> status, Consumer<? super T> consumer) {
            this.status = status;
            this.consumer = consumer;
        }

        @Override
        public final void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.status.whenComplete((v, e) -> subscription.cancel());
            if (!this.status.isDone()) {
                subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public final void onError(Throwable ex) {
            this.status.completeExceptionally(ex);
        }

        @Override
        public final void onComplete() {
            this.status.complete(null);
        }

        @Override
        public final void onNext(T item) {
            try {
                this.consumer.accept(item);
            }
            catch (Throwable ex) {
                this.subscription.cancel();
                this.status.completeExceptionally(ex);
            }
        }
    }

    private static final class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

