/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import sun.nio.ch.EPoll;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class EPollSelectorImpl
extends SelectorImpl {
    private static final int NUM_EPOLLEVENTS = Math.min(IOUtil.fdLimit(), 1024);
    private final int epfd;
    private final long pollArrayAddress;
    private final int fd0;
    private final int fd1;
    private final Map<Integer, SelectionKeyImpl> fdToKey = new HashMap<Integer, SelectionKeyImpl>();
    private final Object updateLock = new Object();
    private final Deque<SelectionKeyImpl> updateKeys = new ArrayDeque<SelectionKeyImpl>();
    private final Object interruptLock = new Object();
    private boolean interruptTriggered;

    EPollSelectorImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.epfd = EPoll.create();
        this.pollArrayAddress = EPoll.allocatePollArray(NUM_EPOLLEVENTS);
        try {
            long fds = IOUtil.makePipe(false);
            this.fd0 = (int)(fds >>> 32);
            this.fd1 = (int)fds;
        }
        catch (IOException ioe) {
            EPoll.freePollArray(this.pollArrayAddress);
            FileDispatcherImpl.closeIntFD(this.epfd);
            throw ioe;
        }
        EPoll.ctl(this.epfd, 1, this.fd0, 1);
    }

    private void ensureOpen() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(Consumer<SelectionKey> action, long timeout) throws IOException {
        int numEntries;
        assert (Thread.holdsLock(this));
        int to = (int)Math.min(timeout, Integer.MAX_VALUE);
        boolean blocking = to != 0;
        boolean timedPoll = to > 0;
        this.processUpdateQueue();
        this.processDeregisterQueue();
        try {
            this.begin(blocking);
            do {
                long adjust;
                long startTime = timedPoll ? System.nanoTime() : 0L;
                numEntries = EPoll.wait(this.epfd, this.pollArrayAddress, NUM_EPOLLEVENTS, to);
                if (numEntries != -3 || !timedPoll || (to = (int)((long)to - TimeUnit.MILLISECONDS.convert(adjust = System.nanoTime() - startTime, TimeUnit.NANOSECONDS))) > 0) continue;
                numEntries = 0;
            } while (numEntries == -3);
            assert (IOStatus.check(numEntries));
        }
        finally {
            this.end(blocking);
        }
        this.processDeregisterQueue();
        return this.processEvents(numEntries, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdateQueue() {
        assert (Thread.holdsLock(this));
        Object object = this.updateLock;
        synchronized (object) {
            SelectionKeyImpl ski;
            while ((ski = this.updateKeys.pollFirst()) != null) {
                int registeredEvents;
                if (!ski.isValid()) continue;
                int fd = ski.getFDVal();
                SelectionKeyImpl previous = this.fdToKey.putIfAbsent(fd, ski);
                assert (previous == null || previous == ski);
                int newEvents = ski.translateInterestOps();
                if (newEvents == (registeredEvents = ski.registeredEvents())) continue;
                if (newEvents == 0) {
                    EPoll.ctl(this.epfd, 2, fd, 0);
                } else if (registeredEvents == 0) {
                    EPoll.ctl(this.epfd, 1, fd, newEvents);
                } else {
                    EPoll.ctl(this.epfd, 3, fd, newEvents);
                }
                ski.registeredEvents(newEvents);
            }
        }
    }

    private int processEvents(int numEntries, Consumer<SelectionKey> action) throws IOException {
        assert (Thread.holdsLock(this));
        boolean interrupted = false;
        int numKeysUpdated = 0;
        for (int i = 0; i < numEntries; ++i) {
            long event = EPoll.getEvent(this.pollArrayAddress, i);
            int fd = EPoll.getDescriptor(event);
            if (fd == this.fd0) {
                interrupted = true;
                continue;
            }
            SelectionKeyImpl ski = this.fdToKey.get(fd);
            if (ski == null) continue;
            int rOps = EPoll.getEvents(event);
            numKeysUpdated += this.processReadyEvents(rOps, ski, action);
        }
        if (interrupted) {
            this.clearInterrupt();
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        assert (Thread.holdsLock(this));
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = true;
        }
        FileDispatcherImpl.closeIntFD(this.epfd);
        EPoll.freePollArray(this.pollArrayAddress);
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
    }

    @Override
    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        assert (!ski.isValid());
        assert (Thread.holdsLock(this));
        int fd = ski.getFDVal();
        if (this.fdToKey.remove(fd) != null) {
            if (ski.registeredEvents() != 0) {
                EPoll.ctl(this.epfd, 2, fd, 0);
                ski.registeredEvents(0);
            }
        } else assert (ski.registeredEvents() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventOps(SelectionKeyImpl ski) {
        this.ensureOpen();
        Object object = this.updateLock;
        synchronized (object) {
            this.updateKeys.addLast(ski);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                try {
                    IOUtil.write1(this.fd1, (byte)0);
                }
                catch (IOException ioe) {
                    throw new InternalError(ioe);
                }
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInterrupt() throws IOException {
        Object object = this.interruptLock;
        synchronized (object) {
            IOUtil.drain(this.fd0);
            this.interruptTriggered = false;
        }
    }
}

