/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CoderResult {
    private static final int CR_UNDERFLOW = 0;
    private static final int CR_OVERFLOW = 1;
    private static final int CR_ERROR_MIN = 2;
    private static final int CR_MALFORMED = 2;
    private static final int CR_UNMAPPABLE = 3;
    private static final String[] names = new String[]{"UNDERFLOW", "OVERFLOW", "MALFORMED", "UNMAPPABLE"};
    private final int type;
    private final int length;
    public static final CoderResult UNDERFLOW = new CoderResult(0, 0);
    public static final CoderResult OVERFLOW = new CoderResult(1, 0);
    private static final CoderResult[] malformed4 = new CoderResult[]{new CoderResult(2, 1), new CoderResult(2, 2), new CoderResult(2, 3), new CoderResult(2, 4)};
    private static final CoderResult[] unmappable4 = new CoderResult[]{new CoderResult(3, 1), new CoderResult(3, 2), new CoderResult(3, 3), new CoderResult(3, 4)};

    private CoderResult(int type, int length) {
        this.type = type;
        this.length = length;
    }

    public String toString() {
        String nm = names[this.type];
        return this.isError() ? nm + "[" + this.length + "]" : nm;
    }

    public boolean isUnderflow() {
        return this.type == 0;
    }

    public boolean isOverflow() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type >= 2;
    }

    public boolean isMalformed() {
        return this.type == 2;
    }

    public boolean isUnmappable() {
        return this.type == 3;
    }

    public int length() {
        if (!this.isError()) {
            throw new UnsupportedOperationException();
        }
        return this.length;
    }

    public static CoderResult malformedForLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Non-positive length");
        }
        if (length <= 4) {
            return malformed4[length - 1];
        }
        return Cache.INSTANCE.malformed.computeIfAbsent(length, n -> new CoderResult(2, (int)n));
    }

    public static CoderResult unmappableForLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Non-positive length");
        }
        if (length <= 4) {
            return unmappable4[length - 1];
        }
        return Cache.INSTANCE.unmappable.computeIfAbsent(length, n -> new CoderResult(3, (int)n));
    }

    public void throwException() throws CharacterCodingException {
        switch (this.type) {
            case 0: {
                throw new BufferUnderflowException();
            }
            case 1: {
                throw new BufferOverflowException();
            }
            case 2: {
                throw new MalformedInputException(this.length);
            }
            case 3: {
                throw new UnmappableCharacterException(this.length);
            }
        }
        assert (false);
    }

    private static final class Cache {
        static final Cache INSTANCE = new Cache();
        final Map<Integer, CoderResult> unmappable = new ConcurrentHashMap<Integer, CoderResult>();
        final Map<Integer, CoderResult> malformed = new ConcurrentHashMap<Integer, CoderResult>();

        private Cache() {
        }
    }
}

