/*
 * Decompiled with CFR 0.152.
 */
package libcore.content.type;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public final class MimeMap {
    private final Map<String, String> mimeToExt;
    private final Map<String, String> extToMime;
    private static volatile MemoizingSupplier<MimeMap> instanceSupplier = new MemoizingSupplier<MimeMap>(() -> MimeMap.builder().addMimeMapping("application/pdf", "pdf").addMimeMapping("image/jpeg", "jpg").addMimeMapping("image/x-ms-bmp", "bmp").addMimeMapping("text/html", Arrays.asList("htm", "html")).addMimeMapping("text/plain", Arrays.asList("text", "txt")).addMimeMapping("text/x-java", "java").build());
    private volatile int hashCode = 0;

    public static Builder builder() {
        return new Builder();
    }

    public Builder buildUpon() {
        return new Builder(this.mimeToExt, this.extToMime);
    }

    private MimeMap(Map<String, String> mimeToExt, Map<String, String> extToMime) {
        this.mimeToExt = Objects.requireNonNull(mimeToExt);
        this.extToMime = Objects.requireNonNull(extToMime);
        for (Map.Entry<String, String> entry : this.mimeToExt.entrySet()) {
            MimeMap.checkValidMimeType(entry.getKey());
            MimeMap.checkValidExtension(entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.extToMime.entrySet()) {
            MimeMap.checkValidExtension(entry.getKey());
            MimeMap.checkValidMimeType(entry.getValue());
        }
    }

    public static MimeMap getDefault() {
        return Objects.requireNonNull(instanceSupplier.get());
    }

    public static void setDefaultSupplier(Supplier<MimeMap> mimeMapSupplier) {
        instanceSupplier = new MemoizingSupplier<MimeMap>(Objects.requireNonNull(mimeMapSupplier));
    }

    public final boolean hasExtension(String extension) {
        return this.guessMimeTypeFromExtension(extension) != null;
    }

    public final String guessMimeTypeFromExtension(String extension) {
        if (extension == null) {
            return null;
        }
        extension = MimeMap.toLowerCase(extension);
        return this.extToMime.get(extension);
    }

    public final boolean hasMimeType(String mimeType) {
        return this.guessExtensionFromMimeType(mimeType) != null;
    }

    public final String guessExtensionFromMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        mimeType = MimeMap.toLowerCase(mimeType);
        return this.mimeToExt.get(mimeType);
    }

    public Set<String> mimeTypes() {
        return Collections.unmodifiableSet(this.mimeToExt.keySet());
    }

    public Set<String> extensions() {
        return Collections.unmodifiableSet(this.extToMime.keySet());
    }

    private static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.mimeToExt.hashCode() + 31 * this.extToMime.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MimeMap)) {
            return false;
        }
        MimeMap that = (MimeMap)obj;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        return this.mimeToExt.equals(that.mimeToExt) && this.extToMime.equals(that.extToMime);
    }

    public String toString() {
        return "MimeMap[" + this.mimeToExt + ", " + this.extToMime + "]";
    }

    private static boolean isValidMimeTypeOrExtension(String s) {
        return s != null && !s.isEmpty() && s.indexOf(63) < 0 && s.indexOf(32) < 0 && s.indexOf(9) < 0 && s.equals(MimeMap.toLowerCase(s));
    }

    static void checkValidMimeType(String s) {
        if (!MimeMap.isValidMimeTypeOrExtension(s) || s.indexOf(47) < 0) {
            throw new IllegalArgumentException("Invalid MIME type: " + s);
        }
    }

    static void checkValidExtension(String s) {
        if (!MimeMap.isValidMimeTypeOrExtension(s) || s.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Invalid extension: " + s);
        }
    }

    private static final class MemoizingSupplier<T>
    implements Supplier<T> {
        private volatile Supplier<T> mDelegate;
        private volatile T mInstance;
        private volatile boolean mInitialized = false;

        public MemoizingSupplier(Supplier<T> delegate) {
            this.mDelegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.mInitialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.mInitialized) {
                        this.mInstance = this.mDelegate.get();
                        this.mDelegate = null;
                        this.mInitialized = true;
                    }
                }
            }
            return this.mInstance;
        }
    }

    public static final class Builder {
        private final Map<String, String> mimeToExt;
        private final Map<String, String> extToMime;

        Builder() {
            this.mimeToExt = new HashMap<String, String>();
            this.extToMime = new HashMap<String, String>();
        }

        Builder(Map<String, String> mimeToExt, Map<String, String> extToMime) {
            this.mimeToExt = new HashMap<String, String>(mimeToExt);
            this.extToMime = new HashMap<String, String>(extToMime);
        }

        private static String maybePut(Map<String, String> map, Element keyElement, String value) {
            if (keyElement.keepExisting) {
                return map.putIfAbsent(keyElement.mimeOrExt, value);
            }
            return map.put(keyElement.mimeOrExt, value);
        }

        public Builder addMimeMapping(String mimeSpec, List<String> extensionSpecs) {
            Element mimeElement = Element.ofMimeSpec(mimeSpec);
            if (extensionSpecs.isEmpty()) {
                return this;
            }
            Element firstExtensionElement = Element.ofExtensionSpec(extensionSpecs.get(0));
            Builder.maybePut(this.mimeToExt, mimeElement, firstExtensionElement.mimeOrExt);
            Builder.maybePut(this.extToMime, firstExtensionElement, mimeElement.mimeOrExt);
            for (String spec : extensionSpecs.subList(1, extensionSpecs.size())) {
                Element element = Element.ofExtensionSpec(spec);
                Builder.maybePut(this.extToMime, element, mimeElement.mimeOrExt);
            }
            return this;
        }

        public Builder addMimeMapping(String mimeSpec, String extensionSpec) {
            return this.addMimeMapping(mimeSpec, Collections.singletonList(extensionSpec));
        }

        public MimeMap build() {
            return new MimeMap(this.mimeToExt, this.extToMime);
        }

        public String toString() {
            return "MimeMap.Builder[" + this.mimeToExt + ", " + this.extToMime + "]";
        }

        static class Element {
            final String mimeOrExt;
            final boolean keepExisting;

            private Element(String spec, boolean isMimeSpec) {
                if (spec.startsWith("?")) {
                    this.keepExisting = true;
                    this.mimeOrExt = MimeMap.toLowerCase(spec.substring(1));
                } else {
                    this.keepExisting = false;
                    this.mimeOrExt = MimeMap.toLowerCase(spec);
                }
                if (isMimeSpec) {
                    MimeMap.checkValidMimeType(this.mimeOrExt);
                } else {
                    MimeMap.checkValidExtension(this.mimeOrExt);
                }
            }

            public static Element ofMimeSpec(String s) {
                return new Element(s, true);
            }

            public static Element ofExtensionSpec(String s) {
                return new Element(s, false);
            }
        }
    }
}

