/*
 * Decompiled with CFR 0.152.
 */
package desugar.sun.nio.fs;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.util.HashSet;
import java.util.Set;

class DesugarUtil {
    private static final Charset jnuEncoding = StandardCharsets.UTF_8;

    private DesugarUtil() {
    }

    static Charset jnuEncoding() {
        return jnuEncoding;
    }

    static byte[] toBytes(String s) {
        return s.getBytes(jnuEncoding);
    }

    static String toString(byte[] bytes) {
        return new String(bytes, jnuEncoding);
    }

    static String[] split(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        String[] result = new String[count + 1];
        int n = 0;
        int last = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            result[n++] = s.substring(last, i);
            last = i + 1;
        }
        result[n] = s.substring(last, s.length());
        return result;
    }

    @SafeVarargs
    static <E> Set<E> newSet(E ... elements) {
        HashSet<E> set = new HashSet<E>();
        for (E e : elements) {
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    static <E> Set<E> newSet(Set<E> other, E ... elements) {
        HashSet<E> set = new HashSet<E>(other);
        for (E e : elements) {
            set.add(e);
        }
        return set;
    }

    static boolean followLinks(LinkOption ... options) {
        boolean followLinks = true;
        for (LinkOption option : options) {
            if (option != LinkOption.NOFOLLOW_LINKS) {
                if (option == null) {
                    throw new NullPointerException();
                }
                throw new AssertionError((Object)"Should not get here");
            }
            followLinks = false;
        }
        return followLinks;
    }
}

