/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DesugarDateTimeTextProviderHelper {
    public static void populateMonthStyleMap(Map<TextStyle, Map<Long, String>> styleMapMap, DateFormatSymbols dateFormatSymbols, Locale loc) {
        int numMonth = dateFormatSymbols.getMonths().length;
        LinkedHashMap<Long, String> longStandAloneMap = new LinkedHashMap<Long, String>();
        LinkedHashMap<Long, String> narrowStandAloneMap = new LinkedHashMap<Long, String>();
        LinkedHashMap<Long, String> shortStandAloneMap = new LinkedHashMap<Long, String>();
        String longMonth = "LLLL";
        String shortMonth = "LLL";
        for (long i = 1L; i <= (long)numMonth; ++i) {
            String longName = DesugarDateTimeTextProviderHelper.computeStandaloneMonthName(i, longMonth, loc);
            longStandAloneMap.put(i, longName);
            narrowStandAloneMap.put(i, DesugarDateTimeTextProviderHelper.firstCodePoint(longName));
            String shortName = DesugarDateTimeTextProviderHelper.computeStandaloneMonthName(i, shortMonth, loc);
            shortStandAloneMap.put(i, shortName);
        }
        if (numMonth > 0) {
            styleMapMap.put(TextStyle.FULL_STANDALONE, longStandAloneMap);
            styleMapMap.put(TextStyle.NARROW_STANDALONE, narrowStandAloneMap);
            styleMapMap.put(TextStyle.SHORT_STANDALONE, shortStandAloneMap);
            styleMapMap.put(TextStyle.FULL, longStandAloneMap);
            styleMapMap.put(TextStyle.NARROW, narrowStandAloneMap);
            styleMapMap.put(TextStyle.SHORT, shortStandAloneMap);
        }
    }

    private static String computeStandaloneMonthName(long id, String standalonePattern, Locale loc) {
        TimeZone legacyUtc = TimeZone.getTimeZone("UTC");
        SimpleDateFormat writer = new SimpleDateFormat(standalonePattern, loc);
        writer.setTimeZone(legacyUtc);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(legacyUtc);
        calendar.set(0, (int)id, 0, 0, 0, 0);
        Date legacy = calendar.getTime();
        return writer.format(legacy);
    }

    private static String firstCodePoint(String string) {
        return string.substring(0, Character.charCount(string.codePointAt(0)));
    }

    private static String lastCodePoint(String rawText) {
        int n = rawText.length();
        int codePoint = rawText.codePointBefore(n);
        return new StringBuilder().appendCodePoint(codePoint).toString();
    }

    public static void populateDayOfWeekStyleMap(Map<TextStyle, Map<Long, String>> styleMapMap, DateFormatSymbols dateFormatSymbols, Locale loc) {
        int numDaysOfWeek = dateFormatSymbols.getWeekdays().length;
        LinkedHashMap<Long, String> longStandAloneMap = new LinkedHashMap<Long, String>();
        LinkedHashMap<Long, String> narrowStandAloneMap = new LinkedHashMap<Long, String>();
        LinkedHashMap<Long, String> shortStandAloneMap = new LinkedHashMap<Long, String>();
        String longDay = "cccc";
        String shortDay = "ccc";
        boolean useLastCodePointAsNarrowName = loc == Locale.SIMPLIFIED_CHINESE || loc == Locale.TRADITIONAL_CHINESE;
        for (long i = 1L; i <= (long)numDaysOfWeek; ++i) {
            String longName = DesugarDateTimeTextProviderHelper.computeStandaloneDayOfWeekName(i, longDay, loc);
            longStandAloneMap.put(i, longName);
            narrowStandAloneMap.put(i, useLastCodePointAsNarrowName ? DesugarDateTimeTextProviderHelper.lastCodePoint(longName) : DesugarDateTimeTextProviderHelper.firstCodePoint(longName));
            String shortName = DesugarDateTimeTextProviderHelper.computeStandaloneDayOfWeekName(i, shortDay, loc);
            shortStandAloneMap.put(i, shortName);
        }
        if (numDaysOfWeek > 0) {
            styleMapMap.put(TextStyle.FULL_STANDALONE, longStandAloneMap);
            styleMapMap.put(TextStyle.NARROW_STANDALONE, narrowStandAloneMap);
            styleMapMap.put(TextStyle.SHORT_STANDALONE, shortStandAloneMap);
            styleMapMap.put(TextStyle.FULL, longStandAloneMap);
            styleMapMap.put(TextStyle.NARROW, narrowStandAloneMap);
            styleMapMap.put(TextStyle.SHORT, shortStandAloneMap);
        }
    }

    private static String computeStandaloneDayOfWeekName(long id, String standalonePattern, Locale loc) {
        TimeZone legacyUtc = TimeZone.getTimeZone("UTC");
        SimpleDateFormat writer = new SimpleDateFormat(standalonePattern, loc);
        writer.setTimeZone(legacyUtc);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(legacyUtc);
        calendar.set(2016, 1, (int)id, 0, 0, 0);
        Date legacy = calendar.getTime();
        return writer.format(legacy);
    }

    private DesugarDateTimeTextProviderHelper() {
    }
}

