/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.PsiConditionParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "dispatcher", "Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "getDispatcher", "()Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "data", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "frontend"})
public final class PsiConditionParser
extends KtVisitor<BooleanExpression, Unit> {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final PsiContractParserDispatcher dispatcher;

    @Override
    @Nullable
    public BooleanExpression visitIsExpression(@NotNull KtIsExpression expression2, @NotNull Unit data) {
        KotlinType type2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        VariableReference variableReference = this.dispatcher.parseVariable(expression2.getLeftHandSide());
        if (variableReference == null) {
            return null;
        }
        VariableReference variable2 = variableReference;
        KtTypeReference ktTypeReference = expression2.getTypeReference();
        if (ktTypeReference == null) {
            return null;
        }
        KtTypeReference typeReference = ktTypeReference;
        KotlinType kotlinType = (KotlinType)this.trace.get(BindingContext.TYPE, typeReference);
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = type2 = kotlinType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
        return new IsInstancePredicate(variable2, kotlinType2, expression2.isNegated());
    }

    @Override
    @Nullable
    public BooleanExpression visitKtElement(@NotNull KtElement element, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element, bindingContext);
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null || (resolvedCall3 = resolvedCall3.getResultingDescriptor()) == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall3;
        if (descriptor2 instanceof ValueDescriptor) {
            KtElement ktElement = element;
            if (!(ktElement instanceof KtExpression)) {
                ktElement = null;
            }
            VariableReference variableReference = this.dispatcher.parseVariable((KtExpression)ktElement);
            if (variableReference == null) {
                return null;
            }
            VariableReference booleanVariable = variableReference;
            VariableReference variableReference2 = booleanVariable;
            if (!(variableReference2 instanceof BooleanVariableReference)) {
                variableReference2 = null;
            }
            return (BooleanVariableReference)variableReference2;
        }
        if (PsiContractsUtilsKt.isEqualsDescriptor((DeclarationDescriptor)((Object)descriptor2))) {
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            if (!(receiverValue instanceof ExpressionReceiver)) {
                receiverValue = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
            ContractDescriptionValue contractDescriptionValue = this.dispatcher.parseValue(expressionReceiver != null ? expressionReceiver.getExpression() : null);
            if (contractDescriptionValue == null) {
                return null;
            }
            ContractDescriptionValue left = contractDescriptionValue;
            ContractDescriptionValue contractDescriptionValue2 = this.dispatcher.parseValue(PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall2));
            if (contractDescriptionValue2 == null) {
                return null;
            }
            ContractDescriptionValue right = contractDescriptionValue2;
            KtElement ktElement = element;
            if (!(ktElement instanceof KtBinaryExpression)) {
                ktElement = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
            Object object = ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null;
            Object object2 = KtTokens.EXCLEQ;
            if (object2 == null) {
                object2 = false;
            }
            boolean isNegated = Intrinsics.areEqual((Object)object, (Object)object2);
            if (left instanceof ConstantReference && Intrinsics.areEqual((Object)left, (Object)ConstantReference.Companion.getNULL()) && right instanceof VariableReference) {
                return new IsNullPredicate((VariableReference)right, isNegated);
            }
            if (right instanceof ConstantReference && Intrinsics.areEqual((Object)right, (Object)ConstantReference.Companion.getNULL()) && left instanceof VariableReference) {
                return new IsNullPredicate((VariableReference)left, isNegated);
            }
            this.trace.report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)element), "only equality comparisons with 'null' allowed"));
            return null;
        }
        this.trace.report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)element), "unsupported construction"));
        return null;
    }

    @Override
    @Nullable
    public BooleanExpression visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        ConstantReference constantReference = this.dispatcher.parseConstant(expression2);
        if (!(constantReference instanceof BooleanConstantReference)) {
            constantReference = null;
        }
        return (BooleanConstantReference)constantReference;
    }

    @Override
    @Nullable
    public BooleanExpression visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.trace.report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)expression2), "call-expressions are not supported yet"));
        return null;
    }

    @Override
    @Nullable
    public BooleanExpression visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull Unit data) {
        Object object;
        Function2 operationConstructor;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        IElementType iElementType = expression2.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            operationConstructor = visitBinaryExpression.1.INSTANCE;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            operationConstructor = visitBinaryExpression.2.INSTANCE;
        } else {
            return (BooleanExpression)super.visitBinaryExpression(expression2, data);
        }
        if ((object = expression2.getLeft()) == null || (object = (BooleanExpression)object.accept(this, data)) == null) {
            return null;
        }
        Object left = object;
        Object object2 = expression2.getRight();
        if (object2 == null || (object2 = (BooleanExpression)object2.accept(this, data)) == null) {
            return null;
        }
        Object right = object2;
        Object object3 = left;
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"left");
        Object object4 = right;
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"right");
        return (BooleanExpression)operationConstructor.invoke(object3, object4);
    }

    @Override
    @Nullable
    public BooleanExpression visitUnaryExpression(@NotNull KtUnaryExpression expression2, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.EXCL)) ^ true) {
            return (BooleanExpression)super.visitUnaryExpression(expression2, data);
        }
        Object object = expression2.getBaseExpression();
        if (object == null || (object = (BooleanExpression)object.accept(this, data)) == null) {
            return null;
        }
        Object arg = object;
        if (!(arg instanceof ContractDescriptionValue)) {
            KtExpression ktExpression = expression2.getBaseExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            this.trace.report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)ktExpression), "negations in contract description can be applied only to variables/values"));
        }
        Object object2 = arg;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"arg");
        return new LogicalNot((BooleanExpression)object2);
    }

    @Override
    @Nullable
    public BooleanExpression visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        KtExpression ktExpression = KtPsiUtil.deparenthesize(expression2);
        return ktExpression != null ? (BooleanExpression)ktExpression.accept(this, data) : null;
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public final PsiContractParserDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public PsiConditionParser(@NotNull BindingTrace trace, @NotNull PsiContractParserDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        this.trace = trace;
        this.dispatcher = dispatcher;
    }
}

