/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.inline.clean.DoWhileGuardElimination;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/DoWhileGuardElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "guardLabels", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "guardToLoopLabel", "", "hasChanges", "", "loopGuardMap", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "analyze", "", "apply", "findBreakInNestedLoop", "statement", "name", "perform", "js.translator"})
public final class DoWhileGuardElimination {
    private final Set<JsName> guardLabels;
    private boolean hasChanges;
    private final Map<JsDoWhile, JsLabel> loopGuardMap;
    private final Map<JsName, JsName> guardToLoopLabel;
    private final JsStatement root;

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            final /* synthetic */ DoWhileGuardElimination this$0;

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsStatement statement2 = x.getStatement();
                if (statement2 instanceof JsDoWhile) {
                    this.processDoWhile((JsDoWhile)statement2, x.getName());
                } else {
                    super.visitLabel(x);
                }
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.processDoWhile(x, null);
            }

            private final void processDoWhile(JsDoWhile x, JsName label) {
                JsStatement body;
                block5: {
                    JsLabel guard;
                    Object object;
                    block6: {
                        JsLabel jsLabel;
                        body = x.getBody();
                        object = body;
                        if (object instanceof JsBlock) {
                            List<JsStatement> list2 = ((JsBlock)body).getStatements();
                            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"body.statements");
                            JsStatement firstStatement = (JsStatement)CollectionsKt.firstOrNull(list2);
                            jsLabel = firstStatement instanceof JsLabel && ((JsBlock)body).getStatements().size() == 1 ? (JsLabel)firstStatement : null;
                        } else {
                            jsLabel = guard = object instanceof JsLabel ? (JsLabel)body : null;
                        }
                        if (guard == null) break block5;
                        if (label != null) break block6;
                        JsStatement jsStatement = guard;
                        JsName jsName = guard.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"guard.name");
                        if (DoWhileGuardElimination.access$findBreakInNestedLoop(this.this$0, jsStatement, jsName)) break block5;
                    }
                    object = DoWhileGuardElimination.access$getGuardLabels$p(this.this$0);
                    HasMetadata hasMetadata = guard.getName();
                    object.add(hasMetadata);
                    object = DoWhileGuardElimination.access$getLoopGuardMap$p(this.this$0);
                    hasMetadata = guard;
                    object.put(x, hasMetadata);
                    object = DoWhileGuardElimination.access$getGuardToLoopLabel$p(this.this$0);
                    JsName jsName = guard.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"guard.name");
                    hasMetadata = jsName;
                    JsName jsName2 = label;
                    object.put(hasMetadata, jsName2);
                }
                body.accept(this);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findBreakInNestedLoop(JsStatement statement2, JsName name) {
        void result2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        statement2.accept(new RecursiveJsVisitor(name, (Ref.BooleanRef)result2){
            private int loopLevel;
            final /* synthetic */ JsName $name;
            final /* synthetic */ Ref.BooleanRef $result;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                HasMetadata hasMetadata = x.getLabel();
                if (hasMetadata == null || (hasMetadata = hasMetadata.getName()) == null) {
                    return;
                }
                HasMetadata guardLabel = hasMetadata;
                if (Intrinsics.areEqual((Object)guardLabel, (Object)this.$name) && this.isInLoop()) {
                    this.$result.element = true;
                }
            }

            private final boolean isInLoop() {
                return this.loopLevel > 0;
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                findBreakInNestedLoop.1 this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                findBreakInNestedLoop.1 v0 = this_$iv = this;
                int n = findBreakInNestedLoop.1.access$getLoopLevel$p(v0);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v0, n + 1);
                super.visitDoWhile(x);
                findBreakInNestedLoop.1 v1 = this_$iv;
                n = findBreakInNestedLoop.1.access$getLoopLevel$p(v1);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v1, n + -1);
            }

            public void visitWhile(@NotNull JsWhile x) {
                findBreakInNestedLoop.1 this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                findBreakInNestedLoop.1 v0 = this_$iv = this;
                int n = findBreakInNestedLoop.1.access$getLoopLevel$p(v0);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v0, n + 1);
                super.visitWhile(x);
                findBreakInNestedLoop.1 v1 = this_$iv;
                n = findBreakInNestedLoop.1.access$getLoopLevel$p(v1);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v1, n + -1);
            }

            public void visitFor(@NotNull JsFor x) {
                findBreakInNestedLoop.1 this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                findBreakInNestedLoop.1 v0 = this_$iv = this;
                int n = findBreakInNestedLoop.1.access$getLoopLevel$p(v0);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v0, n + 1);
                super.visitFor(x);
                findBreakInNestedLoop.1 v1 = this_$iv;
                n = findBreakInNestedLoop.1.access$getLoopLevel$p(v1);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v1, n + -1);
            }

            public void visitForIn(@NotNull JsForIn x) {
                findBreakInNestedLoop.1 this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                findBreakInNestedLoop.1 v0 = this_$iv = this;
                int n = findBreakInNestedLoop.1.access$getLoopLevel$p(v0);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v0, n + 1);
                super.visitForIn(x);
                findBreakInNestedLoop.1 v1 = this_$iv;
                n = findBreakInNestedLoop.1.access$getLoopLevel$p(v1);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v1, n + -1);
            }

            private final void enterLoop(Function0<Unit> action) {
                findBreakInNestedLoop.1 v0 = this;
                int n = findBreakInNestedLoop.1.access$getLoopLevel$p(v0);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v0, n + 1);
                action.invoke();
                findBreakInNestedLoop.1 v1 = this;
                n = findBreakInNestedLoop.1.access$getLoopLevel$p(v1);
                findBreakInNestedLoop.1.access$setLoopLevel$p(v1, n + -1);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (!this.$result.element) {
                    super.visitElement(node);
                }
            }
            {
                this.$name = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public static final /* synthetic */ int access$getLoopLevel$p(findBreakInNestedLoop.1 $this) {
                return $this.loopLevel;
            }

            public static final /* synthetic */ void access$setLoopLevel$p(findBreakInNestedLoop.1 $this, int n) {
                $this.loopLevel = n;
            }
        });
        return result2.element;
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ DoWhileGuardElimination this$0;

            public boolean visit(@NotNull JsDoWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                JsLabel jsLabel = (JsLabel)DoWhileGuardElimination.access$getLoopGuardMap$p(this.this$0).get(x);
                if (jsLabel != null) {
                    JsLabel jsLabel2;
                    JsLabel guard = jsLabel2 = jsLabel;
                    if (DoWhileGuardElimination.access$getGuardLabels$p(this.this$0).contains(guard.getName())) {
                        x.setBody((JsStatement)this.accept((JsNode)guard.getStatement()));
                        DoWhileGuardElimination.access$setHasChanges$p(this.this$0, true);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsBreak x, @NotNull JsContext<JsNode> ctx) {
                JsName name;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = name = jsNameRef != null ? jsNameRef.getName() : null;
                if (CollectionsKt.contains((Iterable)DoWhileGuardElimination.access$getGuardLabels$p(this.this$0), (Object)name)) {
                    JsName target;
                    Map map2 = DoWhileGuardElimination.access$getGuardToLoopLabel$p(this.this$0);
                    JsName jsName2 = target = (JsName)map2.get(name);
                    ctx.replaceMe((JsNode)new JsContinue(jsName2 != null ? jsName2.makeRef() : null));
                    DoWhileGuardElimination.access$setHasChanges$p(this.this$0, true);
                }
                return false;
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    public DoWhileGuardElimination(@NotNull JsStatement root2) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        this.root = root2;
        DoWhileGuardElimination doWhileGuardElimination = this;
        Object object = new LinkedHashSet();
        doWhileGuardElimination.guardLabels = object;
        doWhileGuardElimination = this;
        doWhileGuardElimination.loopGuardMap = object = (Map)new LinkedHashMap();
        doWhileGuardElimination = this;
        doWhileGuardElimination.guardToLoopLabel = object = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ boolean access$findBreakInNestedLoop(DoWhileGuardElimination $this, @NotNull JsStatement statement2, @NotNull JsName name) {
        return $this.findBreakInNestedLoop(statement2, name);
    }

    @NotNull
    public static final /* synthetic */ Set access$getGuardLabels$p(DoWhileGuardElimination $this) {
        return $this.guardLabels;
    }

    @NotNull
    public static final /* synthetic */ Map access$getLoopGuardMap$p(DoWhileGuardElimination $this) {
        return $this.loopGuardMap;
    }

    @NotNull
    public static final /* synthetic */ Map access$getGuardToLoopLabel$p(DoWhileGuardElimination $this) {
        return $this.guardToLoopLabel;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(DoWhileGuardElimination $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(DoWhileGuardElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

