/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsMacroExpander {
    private ExpandMacroToPathMap myExpandMacroMap = new ExpandMacroToPathMap();

    public JpsMacroExpander(Map<String, String> pathVariables) {
        for (Map.Entry<String, String> entry : pathVariables.entrySet()) {
            this.addMacro(entry.getKey(), entry.getValue());
        }
    }

    public void addFileHierarchyReplacements(String macroName, File file2) {
        this.doAddFileHierarchyReplacements("$" + macroName + "$", file2);
    }

    protected void addMacro(String macroName, String path2) {
        this.myExpandMacroMap.addMacroExpand(macroName, path2);
    }

    private void doAddFileHierarchyReplacements(String macro, @Nullable File file2) {
        if (file2 == null) {
            return;
        }
        this.doAddFileHierarchyReplacements(macro + "/..", file2.getParentFile());
        String path2 = FileUtil.toSystemIndependentName((String)file2.getPath());
        if (StringUtil.endsWithChar((CharSequence)path2, (char)'/')) {
            this.myExpandMacroMap.put(macro + "/", path2);
            this.myExpandMacroMap.put(macro, path2.substring(0, path2.length() - 1));
        } else {
            this.myExpandMacroMap.put(macro, path2);
        }
    }

    public void substitute(@NotNull Element element, boolean caseSensitive) {
        if (element == null) {
            JpsMacroExpander.$$$reportNull$$$0(0);
        }
        this.myExpandMacroMap.substitute(element, caseSensitive);
    }

    public ExpandMacroToPathMap getExpandMacroMap() {
        return this.myExpandMacroMap;
    }

    public String substitute(String element, boolean caseSensitive) {
        return this.myExpandMacroMap.substitute(element, caseSensitive);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/model/serialization/JpsMacroExpander", "substitute"));
    }
}

