/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;

public class ResourcePatterns {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.model.java.impl.compiler.ResourcePatterns");
    private final List<CompiledPattern> myCompiledPatterns = new ArrayList<CompiledPattern>();
    private final List<CompiledPattern> myNegatedCompiledPatterns = new ArrayList<CompiledPattern>();

    public ResourcePatterns(JpsJavaCompilerConfiguration configuration) {
        List<String> patterns = configuration.getResourcePatterns();
        for (String pattern : patterns) {
            CompiledPattern regexp = ResourcePatterns.convertToRegexp(pattern);
            if (ResourcePatterns.isPatternNegated(pattern)) {
                this.myNegatedCompiledPatterns.add(regexp);
                continue;
            }
            this.myCompiledPatterns.add(regexp);
        }
    }

    public boolean isResourceFile(File file2, @NotNull File srcRoot) {
        if (srcRoot == null) {
            ResourcePatterns.$$$reportNull$$$0(0);
        }
        String name = file2.getName();
        String parentPath = file2.getParent();
        String relativePathToParent = parentPath != null ? "/" + FileUtilRt.getRelativePath((String)FileUtilRt.toSystemIndependentName((String)srcRoot.getAbsolutePath()), (String)FileUtilRt.toSystemIndependentName((String)parentPath), (char)'/', (boolean)SystemInfo.isFileSystemCaseSensitive) : null;
        for (CompiledPattern pair : this.myCompiledPatterns) {
            if (!ResourcePatterns.matches(name, relativePathToParent, srcRoot, pair)) continue;
            return true;
        }
        if (this.myNegatedCompiledPatterns.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.myNegatedCompiledPatterns.size(); ++i) {
            if (!ResourcePatterns.matches(name, relativePathToParent, srcRoot, this.myNegatedCompiledPatterns.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(String name, String parentRelativePath, @NotNull File srcRoot, CompiledPattern pattern) {
        if (srcRoot == null) {
            ResourcePatterns.$$$reportNull$$$0(1);
        }
        if (!ResourcePatterns.matches(name, pattern.fileName)) {
            return false;
        }
        if (parentRelativePath != null) {
            if (pattern.dir != null && !ResourcePatterns.matches(parentRelativePath, pattern.dir)) {
                return false;
            }
            if (pattern.srcRoot != null && !ResourcePatterns.matches(srcRoot.getName(), pattern.srcRoot)) {
                return false;
            }
        }
        return true;
    }

    private static boolean matches(String s, Pattern p) {
        try {
            return p.matcher(s).matches();
        }
        catch (Exception e) {
            LOG.error("Exception matching file name \"" + s + "\" against the pattern \"" + p + "\"", (Throwable)e);
            return false;
        }
    }

    private static CompiledPattern convertToRegexp(String wildcardPattern) {
        if (ResourcePatterns.isPatternNegated(wildcardPattern)) {
            wildcardPattern = wildcardPattern.substring(1);
        }
        wildcardPattern = FileUtilRt.toSystemIndependentName((String)wildcardPattern);
        String srcRoot = null;
        int colon = wildcardPattern.indexOf(":");
        if (colon > 0) {
            srcRoot = wildcardPattern.substring(0, colon);
            wildcardPattern = wildcardPattern.substring(colon + 1);
        }
        String dirPattern = null;
        int slash = wildcardPattern.lastIndexOf(47);
        if (slash >= 0) {
            dirPattern = wildcardPattern.substring(0, slash + 1);
            wildcardPattern = wildcardPattern.substring(slash + 1);
            dirPattern = ResourcePatterns.optimizeDirPattern(dirPattern);
        }
        wildcardPattern = ResourcePatterns.normalizeWildcards(wildcardPattern);
        wildcardPattern = ResourcePatterns.optimize(wildcardPattern);
        Pattern dirCompiled = dirPattern == null ? null : ResourcePatterns.compilePattern(dirPattern);
        Pattern srcCompiled = srcRoot == null ? null : ResourcePatterns.compilePattern(ResourcePatterns.optimize(ResourcePatterns.normalizeWildcards(srcRoot)));
        return new CompiledPattern(ResourcePatterns.compilePattern(wildcardPattern), dirCompiled, srcCompiled);
    }

    public static String optimizeDirPattern(String dirPattern) {
        if (!dirPattern.startsWith("/")) {
            dirPattern = "/" + dirPattern;
        }
        dirPattern = ResourcePatterns.normalizeWildcards(dirPattern);
        dirPattern = StringUtil.replace((String)dirPattern, (String)"/.*.*/", (String)"(/.*)?/");
        dirPattern = StringUtil.trimEnd((String)dirPattern, (String)"/");
        dirPattern = ResourcePatterns.optimize(dirPattern);
        return dirPattern;
    }

    private static String optimize(String wildcardPattern) {
        return wildcardPattern.replaceAll("(?:\\.\\*)+", ".*");
    }

    public static String normalizeWildcards(String wildcardPattern) {
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"\\!", (String)"!");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)".", (String)"\\.");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*?", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?*", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*", (String)".*");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?", (String)".");
        return wildcardPattern;
    }

    private static boolean isPatternNegated(String wildcardPattern) {
        return wildcardPattern.length() > 1 && wildcardPattern.charAt(0) == '!';
    }

    private static Pattern compilePattern(@NonNls String s) {
        return Pattern.compile(s, SystemInfo.isFileSystemCaseSensitive ? 0 : 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "srcRoot";
        objectArray2[1] = "org/jetbrains/jps/model/java/impl/compiler/ResourcePatterns";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isResourceFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matches";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CompiledPattern {
        @NotNull
        final Pattern fileName;
        @Nullable
        final Pattern dir;
        @Nullable
        final Pattern srcRoot;

        CompiledPattern(@NotNull Pattern fileName, @Nullable Pattern dir, @Nullable Pattern srcRoot) {
            if (fileName == null) {
                CompiledPattern.$$$reportNull$$$0(0);
            }
            this.fileName = fileName;
            this.dir = dir;
            this.srcRoot = srcRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/jps/model/java/impl/compiler/ResourcePatterns$CompiledPattern", "<init>"));
        }
    }
}

