/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegenKt;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.FunctionCodegenKt;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmDescriptorWithExtraFlags;
import org.jetbrains.kotlin.backend.jvm.lower.InitializersLowering;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/FunctionCodegen;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;)V", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "calculateMethodFlags", "", "isStatic", "", "createMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "flags", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodGenericSignature;", "doGenerate", "", "generate", "generateAnnotationDefaultValueIfNeeded", "methodVisitor", "backend"})
public class FunctionCodegen {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final FunctionDescriptor descriptor;
    private final IrFunction irFunction;
    private final ClassCodegen classCodegen;

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    @NotNull
    public final FunctionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void generate() {
        try {
            this.doGenerate();
        }
        catch (Throwable e) {
            throw (Throwable)new RuntimeException("" + e.getMessage() + " while generating code for:\n" + DumpIrTreeKt.dump(this.irFunction), e);
        }
    }

    private final void doGenerate() {
        JvmMethodGenericSignature signature = this.classCodegen.getTypeMapper().mapSignatureWithGeneric(this.descriptor, OwnerKind.IMPLEMENTATION);
        boolean isStatic = DescriptorUtils.isStaticDeclaration(this.descriptor);
        GenerationState generationState = this.classCodegen.getState();
        JvmMethodGenericSignature jvmMethodGenericSignature = signature;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmMethodGenericSignature, (String)"signature");
        FrameMap frameMap = FunctionCodegenKt.createFrameMapWithReceivers(generationState, this.descriptor, jvmMethodGenericSignature, isStatic);
        int flags = this.calculateMethodFlags(isStatic);
        MethodVisitor methodVisitor = this.createMethod(flags, signature);
        org.jetbrains.kotlin.codegen.FunctionCodegen.generateMethodAnnotations(this.descriptor, signature.getAsmMethod(), methodVisitor, this.classCodegen, this.state.getTypeMapper());
        org.jetbrains.kotlin.codegen.FunctionCodegen.generateParameterAnnotations(this.descriptor, methodVisitor, signature, this.classCodegen, this.state);
        if (!this.state.getClassBuilderMode().generateBodies || (flags & 0x400) != 0 || this.descriptor.isExternal()) {
            this.generateAnnotationDefaultValueIfNeeded(methodVisitor);
            methodVisitor.visitEnd();
            return;
        }
        new ExpressionCodegen(this.irFunction, frameMap, new InstructionAdapter(methodVisitor), this.classCodegen).generate();
    }

    private final int calculateMethodFlags(boolean isStatic) {
        boolean interfaceClInit;
        int flags = (AsmUtil.getMethodAsmFlags(this.descriptor, OwnerKind.IMPLEMENTATION, this.state) | (isStatic ? 8 : 0)) ^ (DescriptorUtils.isAnnotationClass(this.descriptor.getContainingDeclaration()) ? 16 : 0) | (this.descriptor instanceof JvmDescriptorWithExtraFlags ? ((JvmDescriptorWithExtraFlags)((Object)this.descriptor)).getExtraFlags() : 0);
        if (Intrinsics.areEqual((Object)this.irFunction.getOrigin(), (Object)DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE)) {
            flags = flags ^ AsmUtil.getVisibilityAccessFlag(this.descriptor) | 1;
        }
        boolean bl = interfaceClInit = JvmCodegenUtil.isJvmInterface(this.classCodegen.getDescriptor()) && Intrinsics.areEqual((Object)InitializersLowering.Companion.getClinitName(), (Object)this.descriptor.getName());
        if (interfaceClInit) {
            flags ^= 0x400;
        }
        return flags;
    }

    @NotNull
    protected MethodVisitor createMethod(int flags, @NotNull JvmMethodGenericSignature signature) {
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        ClassBuilder classBuilder2 = this.classCodegen.getVisitor();
        JvmDeclarationOrigin jvmDeclarationOrigin = ClassCodegenKt.getOtherOrigin(this.irFunction);
        Method method = signature.getAsmMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"signature.asmMethod");
        String string = method.getName();
        Method method2 = signature.getAsmMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"signature.asmMethod");
        MethodVisitor methodVisitor = classBuilder2.newMethod(jvmDeclarationOrigin, flags, string, method2.getDescriptor(), signature.getGenericsSignature(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"classCodegen.visitor.new\u2026TODO support exception*/)");
        return methodVisitor;
    }

    private final void generateAnnotationDefaultValueIfNeeded(MethodVisitor methodVisitor) {
        block5: {
            KtExpression ktExpression;
            SourceElement source;
            CallableMemberDescriptor directMember;
            CallableMemberDescriptor callableMemberDescriptor = directMember = JvmCodegenUtil.getDirectMember(this.descriptor);
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"directMember");
            if (!DescriptorUtils.isAnnotationClass(callableMemberDescriptor.getContainingDeclaration())) break block5;
            SourceElement sourceElement = source = directMember.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"source");
            PsiElement psiElement = KotlinSourceElementKt.getPsi(sourceElement);
            if (!(psiElement instanceof KtParameter)) {
                psiElement = null;
            }
            if ((ktExpression = (KtParameter)psiElement) != null && (ktExpression = ktExpression.getDefaultValue()) != null) {
                boolean bl;
                KtExpression ktExpression2;
                KtExpression $receiver;
                KtExpression defaultValue = $receiver = (ktExpression2 = ktExpression);
                ConstantValue<?> constant = org.jetbrains.kotlin.codegen.ExpressionCodegen.getCompileTimeConstant(defaultValue, this.state.getBindingContext(), true, this.state.getShouldInlineConstVals());
                boolean bl2 = bl = !this.state.getClassBuilderMode().generateBodies || constant != null;
                if (_Assertions.ENABLED && !bl) {
                    StringBuilder stringBuilder = new StringBuilder().append("Default value for annotation parameter should be compile time value: ");
                    KtExpression ktExpression3 = defaultValue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"defaultValue");
                    String string = stringBuilder.append(ktExpression3.getText()).toString();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (constant != null) {
                    AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(methodVisitor, this.classCodegen, this.state.getTypeMapper());
                    KotlinType kotlinType = this.descriptor.getReturnType();
                    if (kotlinType == null) {
                        Intrinsics.throwNpe();
                    }
                    annotationCodegen.generateAnnotationDefaultValue(constant, kotlinType);
                }
            }
        }
    }

    public FunctionCodegen(@NotNull IrFunction irFunction, @NotNull ClassCodegen classCodegen) {
        Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
        Intrinsics.checkParameterIsNotNull((Object)classCodegen, (String)"classCodegen");
        this.irFunction = irFunction;
        this.classCodegen = classCodegen;
        this.state = this.classCodegen.getState();
        this.descriptor = this.irFunction.getDescriptor();
    }
}

