/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolsRemapper;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InitializersLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ClassInitializersBuilder", "Companion", "backend"})
public final class InitializersLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private static final Name clinitName;
    public static final Companion Companion;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        ClassInitializersBuilder classInitializersBuilder = new ClassInitializersBuilder(irClass);
        IrElementVisitorVoidKt.acceptChildrenVoid(irClass, classInitializersBuilder);
        classInitializersBuilder.transformInstanceInitializerCallsInConstructors(irClass);
        classInitializersBuilder.createStaticInitializationMethod(irClass);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InitializersLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    static {
        Companion = new Companion(null);
        clinitName = Name.special("<clinit>");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0018H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InitializersLowering$ClassInitializersBuilder;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/InitializersLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "instanceInitializerStatements", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getInstanceInitializerStatements", "()Ljava/util/ArrayList;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "staticInitializerStatements", "getStaticInitializerStatements", "createStaticInitializationMethod", "", "transformInstanceInitializerCallsInConstructors", "visitAnonymousInitializer", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "backend"})
    private final class ClassInitializersBuilder
    implements IrElementVisitorVoid {
        @NotNull
        private final ArrayList<IrStatement> staticInitializerStatements;
        @NotNull
        private final ArrayList<IrStatement> instanceInitializerStatements;
        @NotNull
        private final IrClass irClass;

        @NotNull
        public final ArrayList<IrStatement> getStaticInitializerStatements() {
            return this.staticInitializerStatements;
        }

        @NotNull
        public final ArrayList<IrStatement> getInstanceInitializerStatements() {
            return this.instanceInitializerStatements;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        }

        @Override
        public void visitField(@NotNull IrField declaration) {
            IrGetValueImpl irGetValueImpl;
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElement irElement = declaration.getInitializer();
            if (irElement == null || (irElement = irElement.getExpression()) == null) {
                return;
            }
            IrElement irFieldInitializer = irElement;
            if (declaration.getDescriptor().getDispatchReceiverParameter() != null) {
                int n = irFieldInitializer.getStartOffset();
                int n2 = irFieldInitializer.getEndOffset();
                ReceiverParameterDescriptor receiverParameterDescriptor = this.irClass.getDescriptor().getThisAsReceiverParameter();
                Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"irClass.descriptor.thisAsReceiverParameter");
                irGetValueImpl = new IrGetValueImpl(n, n2, receiverParameterDescriptor, null, 8, null);
            } else {
                irGetValueImpl = null;
            }
            IrGetValueImpl receiver = irGetValueImpl;
            IrSetFieldImpl irSetField = new IrSetFieldImpl(irFieldInitializer.getStartOffset(), irFieldInitializer.getEndOffset(), declaration.getDescriptor(), (IrExpression)receiver, (IrExpression)irFieldInitializer, null, null);
            if (DescriptorUtils.isStaticDeclaration(declaration.getDescriptor())) {
                this.staticInitializerStatements.add(irSetField);
            } else {
                this.instanceInitializerStatements.add(irSetField);
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            this.instanceInitializerStatements.addAll((Collection<IrStatement>)declaration.getBody().getStatements());
        }

        public final void transformInstanceInitializerCallsInConstructors(@NotNull IrClass irClass) {
            Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
            IrElementTransformerVoidKt.transformChildrenVoid(irClass, new IrElementTransformerVoid(this, irClass){
                final /* synthetic */ ClassInitializersBuilder this$0;
                final /* synthetic */ IrClass $irClass;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                    Collection<IrStatement> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    int n = this.$irClass.getStartOffset();
                    int n2 = this.$irClass.getEndOffset();
                    SimpleType simpleType2 = this.this$0.InitializersLowering.this.getContext().getBuiltIns().getUnitType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.unitType");
                    Iterable iterable = this.this$0.getInstanceInitializerStatements();
                    IrStatementOrigin irStatementOrigin = null;
                    KotlinType kotlinType = simpleType2;
                    int n3 = n2;
                    int n4 = n;
                    void var3_7 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        IrStatement irStatement = (IrStatement)item$iv$iv;
                        collection = destination$iv$iv;
                        IrStatement irStatement2 = InitializersLowering.Companion.copy((IrStatement)it);
                        collection.add(irStatement2);
                    }
                    Collection<IrStatement> collection2 = collection = (List)destination$iv$iv;
                    IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
                    KotlinType kotlinType2 = kotlinType;
                    int n5 = n3;
                    int n6 = n4;
                    return new IrBlockImpl(n6, n5, kotlinType2, irStatementOrigin2, (List<? extends IrStatement>)collection2);
                }
                {
                    this.this$0 = $outer;
                    this.$irClass = $captured_local_variable$1;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void createStaticInitializationMethod(@NotNull IrClass irClass) {
            Collection<IrStatement> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
            SimpleFunctionDescriptorImpl staticInitializerDescriptor = SimpleFunctionDescriptorImpl.create(irClass.getDescriptor(), Annotations.Companion.getEMPTY(), Companion.getClinitName(), CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE);
            staticInitializerDescriptor.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), (KotlinType)DescriptorUtilsKt.getBuiltIns(irClass.getDescriptor()).getUnitType(), Modality.FINAL, Visibilities.PUBLIC);
            List<IrDeclaration> list2 = irClass.getDeclarations();
            int n = irClass.getStartOffset();
            int n2 = irClass.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = JvmLoweredDeclarationOrigin.CLASS_STATIC_INITIALIZER.INSTANCE;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = staticInitializerDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"staticInitializerDescriptor");
            Iterable iterable = this.staticInitializerStatements;
            int n3 = irClass.getEndOffset();
            int n4 = irClass.getStartOffset();
            FunctionDescriptor functionDescriptor = simpleFunctionDescriptorImpl;
            IrDeclarationOrigin irDeclarationOrigin2 = irDeclarationOrigin;
            int n5 = n2;
            int n6 = n;
            List<IrDeclaration> list3 = list2;
            void var4_11 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                IrStatement irStatement = (IrStatement)item$iv$iv;
                collection = destination$iv$iv;
                IrStatement irStatement2 = Companion.copy((IrStatement)it);
                collection.add(irStatement2);
            }
            Collection<IrStatement> collection2 = collection = (List)destination$iv$iv;
            int n7 = n3;
            int n8 = n4;
            IrBody irBody = new IrBlockBodyImpl(n8, n7, (List<? extends IrStatement>)collection2);
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            IrDeclarationOrigin irDeclarationOrigin3 = irDeclarationOrigin2;
            int n9 = n5;
            int n10 = n6;
            list3.add(new IrFunctionImpl(n10, n9, irDeclarationOrigin3, functionDescriptor2, irBody));
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        public ClassInitializersBuilder(IrClass irClass) {
            Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
            this.irClass = irClass;
            this.staticInitializerStatements = new ArrayList();
            this.instanceInitializerStatements = new ArrayList();
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
        }

        @Override
        public void visitBody(@NotNull IrBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
            Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop) {
            Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop) {
            Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0007\u001a\u00020\b*\u00020\bJ\n\u0010\u0007\u001a\u00020\t*\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InitializersLowering$Companion;", "", "()V", "clinitName", "Lorg/jetbrains/kotlin/name/Name;", "getClinitName", "()Lorg/jetbrains/kotlin/name/Name;", "copy", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend"})
    public static final class Companion {
        @NotNull
        public final Name getClinitName() {
            return clinitName;
        }

        @NotNull
        public final IrStatement copy(@NotNull IrStatement $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            IrElement $receiver$iv = $receiver;
            DeepCopySymbolsRemapper remapper$iv = new DeepCopySymbolsRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid($receiver$iv, remapper$iv);
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($receiver$iv.transform(new DeepCopyIrTreeWithSymbols(remapper$iv), null));
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
            }
            return (IrStatement)irElement;
        }

        @NotNull
        public final IrExpression copy(@NotNull IrExpression $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            IrElement $receiver$iv = $receiver;
            DeepCopySymbolsRemapper remapper$iv = new DeepCopySymbolsRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid($receiver$iv, remapper$iv);
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($receiver$iv.transform(new DeepCopyIrTreeWithSymbols(remapper$iv), null));
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            }
            return (IrExpression)irElement;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

