/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Trinity;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.org.objectweb.asm.Type;

public class FrameMap {
    private final TObjectIntHashMap<DeclarationDescriptor> myVarIndex = new TObjectIntHashMap();
    private final TObjectIntHashMap<DeclarationDescriptor> myVarSizes = new TObjectIntHashMap();
    private int myMaxIndex = 0;

    public int enter(DeclarationDescriptor descriptor2, Type type2) {
        int index2 = this.myMaxIndex;
        this.myVarIndex.put((Object)descriptor2, index2);
        this.myMaxIndex += type2.getSize();
        this.myVarSizes.put((Object)descriptor2, type2.getSize());
        return index2;
    }

    public int leave(DeclarationDescriptor descriptor2) {
        int size = this.myVarSizes.get((Object)descriptor2);
        this.myMaxIndex -= size;
        this.myVarSizes.remove((Object)descriptor2);
        int oldIndex = this.myVarIndex.remove((Object)descriptor2);
        if (oldIndex != this.myMaxIndex) {
            throw new IllegalStateException("Descriptor can be left only if it is last: " + descriptor2);
        }
        return oldIndex;
    }

    public int enterTemp(Type type2) {
        int result2 = this.myMaxIndex;
        this.myMaxIndex += type2.getSize();
        return result2;
    }

    public void leaveTemp(Type type2) {
        this.myMaxIndex -= type2.getSize();
    }

    public int getIndex(DeclarationDescriptor descriptor2) {
        return this.myVarIndex.contains((Object)descriptor2) ? this.myVarIndex.get((Object)descriptor2) : -1;
    }

    public Mark mark() {
        return new Mark(this.myMaxIndex);
    }

    public int getCurrentSize() {
        return this.myMaxIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.myVarIndex.size() != this.myVarSizes.size()) {
            return "inconsistent";
        }
        ArrayList descriptors = Lists.newArrayList();
        for (Object descriptor0 : this.myVarIndex.keys()) {
            DeclarationDescriptor descriptor2 = (DeclarationDescriptor)descriptor0;
            int varIndex = this.myVarIndex.get((Object)descriptor2);
            int varSize = this.myVarSizes.get((Object)descriptor2);
            descriptors.add(Trinity.create((Object)descriptor2, (Object)varIndex, (Object)varSize));
        }
        descriptors.sort(Comparator.comparingInt(left -> (Integer)left.second));
        sb.append("size=").append(this.myMaxIndex);
        boolean first2 = true;
        for (Trinity t : descriptors) {
            if (!first2) {
                sb.append(", ");
            }
            first2 = false;
            sb.append(t.first).append(",i=").append(t.second).append(",s=").append(t.third);
        }
        return sb.toString();
    }

    public class Mark {
        private final int myIndex;

        public Mark(int index2) {
            this.myIndex = index2;
        }

        public void dropTo() {
            ArrayList<Object> descriptorsToDrop = new ArrayList<Object>();
            TObjectIntIterator iterator2 = FrameMap.this.myVarIndex.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                if (iterator2.value() < this.myIndex) continue;
                descriptorsToDrop.add(iterator2.key());
            }
            for (DeclarationDescriptor declarationDescriptor : descriptorsToDrop) {
                FrameMap.this.myVarIndex.remove((Object)declarationDescriptor);
                FrameMap.this.myVarSizes.remove((Object)declarationDescriptor);
            }
            FrameMap.this.myMaxIndex = this.myIndex;
        }
    }
}

