/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.RangeToIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public enum PrimitiveBinaryOperationFIF implements FunctionIntrinsicFactory
{
    INSTANCE;

    private static final BinaryOperationIntrinsicBase INT_MULTIPLICATION_INTRINSIC;
    @NotNull
    private static final BinaryOperationIntrinsicBase BUILTINS_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final BinaryOperationIntrinsicBase PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final NamePredicate BINARY_OPERATIONS;
    private static final DescriptorPredicate INT_BINARY_OPERATIONS;
    private static final DescriptorPredicate SIMPLE_INT_MULTIPLICATION;
    private static final DescriptorPredicate INT_DIVISION;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_BINARY_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_INTEGRAL_NUMBERS_COMPARE_TO_INTEGRAL_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS;
    private static final Predicate<FunctionDescriptor> INT_WITH_BIT_OPERATIONS;
    private static final DescriptorPredicate BOOLEAN_OPERATIONS;
    private static final DescriptorPredicate STRING_PLUS;
    private static final DescriptorPredicate INT_MULTIPLICATION;
    private static final DescriptorPredicate CHAR_RANGE_TO;
    private static final DescriptorPredicate NUMBER_RANGE_TO;
    private static final ImmutableMap<String, JsBinaryOperator> BINARY_BITWISE_OPERATIONS;
    private static final Predicate<FunctionDescriptor> PREDICATE;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        JsBinaryOperator op;
        if (CHAR_RANGE_TO.test(descriptor2)) {
            return new RangeToIntrinsic(descriptor2);
        }
        if (PRIMITIVE_INTEGRAL_NUMBERS_COMPARE_TO_INTEGRAL_OPERATIONS.test(descriptor2)) {
            return PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
        }
        if (PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS.test(descriptor2)) {
            return BUILTINS_COMPARE_TO_INTRINSIC;
        }
        if (KotlinBuiltIns.isBuiltIn(descriptor2) && descriptor2.getName().equals(OperatorNameConventions.COMPARE_TO)) {
            return BUILTINS_COMPARE_TO_INTRINSIC;
        }
        if (!PREDICATE.test(descriptor2)) {
            return null;
        }
        if (INT_MULTIPLICATION.test(descriptor2)) {
            return INT_MULTIPLICATION_INTRINSIC;
        }
        if (NUMBER_RANGE_TO.test(descriptor2)) {
            return new RangeToIntrinsic(descriptor2);
        }
        if (INT_WITH_BIT_OPERATIONS.test(descriptor2) && (op = (JsBinaryOperator)BINARY_BITWISE_OPERATIONS.get((Object)descriptor2.getName().asString())) != null) {
            return new OptimizedIntBinaryOperationInstrinsic(op);
        }
        JsBinaryOperator operator = PrimitiveBinaryOperationFIF.getOperator(descriptor2);
        if (INT_BINARY_OPERATIONS.test(descriptor2)) {
            return new AdditiveIntBinaryOperationInstrinsic(operator);
        }
        if (SIMPLE_INT_MULTIPLICATION.test(descriptor2) || INT_DIVISION.test(descriptor2)) {
            return new IntBinaryOperationFunctionIntrinsic(operator);
        }
        PrimitiveBinaryOperationFunctionIntrinsic result2 = new PrimitiveBinaryOperationFunctionIntrinsic(operator);
        if (PatternBuilder.pattern("Char.plus|minus(Int)").test(descriptor2)) {
            return new CharAndIntBinaryOperationFunctionIntrinsic(result2);
        }
        if (PatternBuilder.pattern("Char.minus(Char)").test(descriptor2)) {
            return new CharAndCharBinaryOperationFunctionIntrinsic(result2);
        }
        if (PatternBuilder.pattern("String.plus(Any)").test(descriptor2)) {
            return new StringAndCharBinaryOperationFunctionIntrinsic(result2);
        }
        return result2;
    }

    @NotNull
    private static JsBinaryOperator getOperator(@NotNull FunctionDescriptor descriptor2) {
        Name descriptorName = descriptor2.getName().equals(OperatorNameConventions.MOD) ? OperatorNameConventions.REM : descriptor2.getName();
        switch (descriptorName.asString()) {
            case "or": {
                return JsBinaryOperator.BIT_OR;
            }
            case "and": {
                return JsBinaryOperator.BIT_AND;
            }
            case "xor": {
                return JsBinaryOperator.BIT_XOR;
            }
        }
        KtToken token = (KtToken)((Object)OperatorConventions.BINARY_OPERATION_NAMES.inverse().get((Object)descriptorName));
        return OperatorTable.getBinaryOperator(token);
    }

    static {
        INT_MULTIPLICATION_INTRINSIC = new BinaryOperationIntrinsicBase(){
            private static final int SAFE_THRESHOLD = 0x100000;

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
                if (this.isSafeConstant(left) || this.isSafeConstant(right)) {
                    return JsAstUtils.toInt32(JsAstUtils.mul(left, right));
                }
                return new JsInvocation((JsExpression)Namer.imul(), left, right);
            }

            private boolean isSafeConstant(@NotNull JsExpression expression2) {
                if (!(expression2 instanceof JsIntLiteral)) {
                    return false;
                }
                int value = ((JsIntLiteral)expression2).value;
                return Math.abs(value) < 0x100000;
            }
        };
        BUILTINS_COMPARE_TO_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
                return JsAstUtils.compareTo(left, right);
            }
        };
        PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
                return JsAstUtils.primitiveCompareTo(left, right);
            }
        };
        BINARY_OPERATIONS = new NamePredicate(OperatorNameConventions.BINARY_OPERATION_NAMES);
        INT_BINARY_OPERATIONS = PatternBuilder.pattern("Int.plus|minus(Int)");
        SIMPLE_INT_MULTIPLICATION = PatternBuilder.pattern("Byte|Short.times(Byte|Short)");
        INT_DIVISION = PatternBuilder.pattern("Byte|Short|Int.div(Byte|Short|Int)");
        PRIMITIVE_NUMBERS_BINARY_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, BINARY_OPERATIONS);
        PRIMITIVE_INTEGRAL_NUMBERS_COMPARE_TO_INTEGRAL_OPERATIONS = PatternBuilder.pattern("Byte|Short|Int.compareTo(Byte|Short|Int)");
        PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, "compareTo");
        INT_WITH_BIT_OPERATIONS = PatternBuilder.pattern("Int.or|and|xor|shl|shr|ushr").or(PatternBuilder.pattern("Short|Byte.or|and|xor"));
        BOOLEAN_OPERATIONS = PatternBuilder.pattern("Boolean.or|and|xor");
        STRING_PLUS = PatternBuilder.pattern("String.plus");
        INT_MULTIPLICATION = PatternBuilder.pattern("Int.times(Int)");
        CHAR_RANGE_TO = PatternBuilder.pattern("Char.rangeTo(Char)");
        NUMBER_RANGE_TO = PatternBuilder.pattern("Byte|Short|Int.rangeTo(Byte|Short|Int)");
        BINARY_BITWISE_OPERATIONS = ImmutableMap.builder().put((Object)"or", (Object)JsBinaryOperator.BIT_OR).put((Object)"and", (Object)JsBinaryOperator.BIT_AND).put((Object)"xor", (Object)JsBinaryOperator.BIT_XOR).put((Object)"shl", (Object)JsBinaryOperator.SHL).put((Object)"shr", (Object)JsBinaryOperator.SHR).put((Object)"ushr", (Object)JsBinaryOperator.SHRU).build();
        PREDICATE = PRIMITIVE_NUMBERS_BINARY_OPERATIONS.or(BOOLEAN_OPERATIONS).or(STRING_PLUS).or(INT_WITH_BIT_OPERATIONS).or(PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS);
    }

    private static class StringAndCharBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private StringAndCharBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            return this.functionIntrinsic.doApply(left, TopLevelFIF.TO_STRING.apply(right, Collections.emptyList(), context), context);
        }
    }

    private static class CharAndCharBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private CharAndCharBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            return this.functionIntrinsic.doApply(left, right, context);
        }
    }

    private static class CharAndIntBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private CharAndIntBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            return AstUtilsKt.toChar(context, this.functionIntrinsic.doApply(left, right, context));
        }
    }

    private static class AdditiveIntBinaryOperationInstrinsic
    extends OptimizedIntBinaryOperationInstrinsic {
        public AdditiveIntBinaryOperationInstrinsic(@NotNull JsBinaryOperator operator) {
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            return JsAstUtils.toInt32(super.doApply(left, right, context));
        }
    }

    private static class OptimizedIntBinaryOperationInstrinsic
    extends PrimitiveBinaryOperationFunctionIntrinsic {
        public OptimizedIntBinaryOperationInstrinsic(@NotNull JsBinaryOperator operator) {
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            left = OptimizedIntBinaryOperationInstrinsic.unwrapAdditive(left);
            right = OptimizedIntBinaryOperationInstrinsic.unwrapAdditive(right);
            return super.doApply(left, right, context);
        }

        @NotNull
        private static JsExpression unwrapAdditive(@NotNull JsExpression expression2) {
            JsExpression toIntArgument = JsAstUtils.extractToInt32Argument(expression2);
            if (toIntArgument == null) {
                return expression2;
            }
            if (!(toIntArgument instanceof JsBinaryOperation)) {
                return expression2;
            }
            JsBinaryOperator operator = ((JsBinaryOperation)toIntArgument).getOperator();
            switch (operator) {
                case ADD: 
                case SUB: {
                    return toIntArgument;
                }
            }
            return expression2;
        }
    }

    private static class IntBinaryOperationFunctionIntrinsic
    extends PrimitiveBinaryOperationFunctionIntrinsic {
        private IntBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            return JsAstUtils.toInt32(super.doApply(left, right, context));
        }
    }

    private static class PrimitiveBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final JsBinaryOperator operator;

        private PrimitiveBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            this.operator = operator;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            return new JsBinaryOperation(this.operator, left, right);
        }
    }

    private static abstract class BinaryOperationIntrinsicBase
    extends FunctionIntrinsicWithReceiverComputed {
        private BinaryOperationIntrinsicBase() {
        }

        @NotNull
        public abstract JsExpression doApply(@NotNull JsExpression var1, @NotNull JsExpression var2, @NotNull TranslationContext var3);

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            assert (receiver != null);
            assert (arguments2.size() == 1);
            return this.doApply(receiver, arguments2.get(0), context);
        }
    }
}

