/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AssignmentBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicsKt;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.CompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.EqualsBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.IntrinsicKey;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.LongCompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.NO_INTRINSIC;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsics;", "", "()V", "factories", "", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "intrinsicCache", "", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/IntrinsicKey;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "computeIntrinsic", "token", "Lorg/jetbrains/kotlin/lexer/KtToken;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightType", "getIntrinsic", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
public final class BinaryOperationIntrinsics {
    private final Map<IntrinsicKey, BinaryOperationIntrinsic> intrinsicCache;
    private final List<BinaryOperationIntrinsicFactory> factories;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BinaryOperationIntrinsic getIntrinsic(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        BinaryOperationIntrinsic binaryOperationIntrinsic;
        void leftType;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtToken token = PsiUtils.getOperationToken(expression2);
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2);
        if (descriptor2 == null || !(descriptor2 instanceof FunctionDescriptor)) {
            return NO_INTRINSIC.INSTANCE;
        }
        Pair<KotlinType, KotlinType> pair = BinaryOperationIntrinsicsKt.binaryOperationTypes(expression2, context);
        KotlinType kotlinType = (KotlinType)pair.component1();
        KotlinType rightType = (KotlinType)pair.component2();
        KtToken ktToken = token;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken), (String)"token");
        IntrinsicKey key = new IntrinsicKey(ktToken, (FunctionDescriptor)descriptor2, (KotlinType)leftType, rightType);
        Map<IntrinsicKey, BinaryOperationIntrinsic> $receiver$iv = this.intrinsicCache;
        BinaryOperationIntrinsic value$iv = $receiver$iv.get(key);
        if (value$iv == null) {
            BinaryOperationIntrinsic answer$iv = this.computeIntrinsic(token, (FunctionDescriptor)descriptor2, (KotlinType)leftType, rightType);
            $receiver$iv.put(key, answer$iv);
            binaryOperationIntrinsic = answer$iv;
        } else {
            binaryOperationIntrinsic = value$iv;
        }
        return binaryOperationIntrinsic;
    }

    private final BinaryOperationIntrinsic computeIntrinsic(KtToken token, FunctionDescriptor descriptor2, KotlinType leftType, KotlinType rightType) {
        for (BinaryOperationIntrinsicFactory factory2 : this.factories) {
            BinaryOperationIntrinsic intrinsic;
            if (!factory2.getSupportTokens().contains((Object)token) || (intrinsic = factory2.getIntrinsic(descriptor2, leftType, rightType)) == null) continue;
            return intrinsic;
        }
        return NO_INTRINSIC.INSTANCE;
    }

    public BinaryOperationIntrinsics() {
        Map map2;
        BinaryOperationIntrinsics binaryOperationIntrinsics = this;
        binaryOperationIntrinsics.intrinsicCache = map2 = (Map)new LinkedHashMap();
        this.factories = CollectionsKt.listOf((Object[])new BinaryOperationIntrinsicFactory[]{LongCompareToBOIF.INSTANCE, EqualsBOIF.INSTANCE, CompareToBOIF.INSTANCE, AssignmentBOIF.INSTANCE});
    }
}

