/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.JsPlatformEvaluator;
import org.jetbrains.kotlin.preprocessor.JvmPlatformEvaluator;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import org.jetbrains.kotlin.preprocessor.Profile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u0010\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u001a\u0010\u0014\u001a\u00020\n*\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\n\"#\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"profileEvaluators", "", "", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/preprocessor/Evaluator;", "getProfileEvaluators", "()Ljava/util/Map;", "createJsProfile", "Lorg/jetbrains/kotlin/preprocessor/Profile;", "targetRoot", "Ljava/io/File;", "createJvmProfile", "version", "", "createProfile", "name", "convertLineSeparators", "isTextEqualTo", "", "content", "makeRelativeTo", "from", "to", "mkdirsOrFail", "", "conditional-preprocessor"})
public final class PreprocessorKt {
    @NotNull
    private static final Map<String, Function0<Evaluator>> profileEvaluators;

    @NotNull
    public static final Profile createJvmProfile(@NotNull File targetRoot, int version) {
        Intrinsics.checkParameterIsNotNull((Object)targetRoot, (String)"targetRoot");
        return new Profile("JVM" + version, new JvmPlatformEvaluator(version), new File(targetRoot, "jvm" + version));
    }

    @NotNull
    public static final Profile createJsProfile(@NotNull File targetRoot) {
        Intrinsics.checkParameterIsNotNull((Object)targetRoot, (String)"targetRoot");
        return new Profile("JS", new JsPlatformEvaluator(0, 1, null), new File(targetRoot, "js"));
    }

    @NotNull
    public static final Map<String, Function0<Evaluator>> getProfileEvaluators() {
        return profileEvaluators;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Profile createProfile(@NotNull String name, @NotNull File targetRoot) {
        void profileName;
        Map.Entry entry;
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)targetRoot, (String)"targetRoot");
            Iterable $receiver$iv = profileEvaluators.entrySet();
            for (Object element$iv : $receiver$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                if (!StringsKt.equals((String)((String)it.getKey()), (String)name, (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry2 = v0;
        if (entry2 == null) {
            throw (Throwable)new IllegalArgumentException("Profile with name '" + name + "' is not supported");
        }
        Map.Entry entry3 = entry = entry2;
        String string = (String)entry3.getKey();
        entry3 = entry;
        Function0 evaluator = (Function0)entry3.getValue();
        return new Profile((String)profileName, (Evaluator)evaluator.invoke(), targetRoot);
    }

    @NotNull
    public static final String convertLineSeparators(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = StringUtil.convertLineSeparators((String)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.convertLineSeparators(this)");
        return string;
    }

    public static final boolean isTextEqualTo(@NotNull File $receiver, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        return Intrinsics.areEqual((Object)StringsKt.lines((CharSequence)FilesKt.readText$default((File)$receiver, null, (int)1, null)), (Object)StringsKt.lines((CharSequence)content));
    }

    @NotNull
    public static final File makeRelativeTo(@NotNull File $receiver, @NotNull File from, @NotNull File to) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        return new File(to, FilesKt.toRelativeString((File)$receiver, (File)from));
    }

    public static final void mkdirsOrFail(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.mkdirs() && !$receiver.exists()) {
            throw (Throwable)new IOException("Failed to create directory " + $receiver + '.');
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new Integer[]{6, 7, 8});
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            int version;
            int n = ((Number)element$iv$iv).intValue();
            Map map2 = destination$iv$iv;
            String string = "JVM" + version;
            version = ((Number)element$iv$iv).intValue();
            Function0 function0 = (Function0)new Function0<JvmPlatformEvaluator>(version){
                final /* synthetic */ int $version;

                @NotNull
                public final JvmPlatformEvaluator invoke() {
                    return new JvmPlatformEvaluator(this.$version);
                }
                {
                    this.$version = n;
                    super(0);
                }
            };
            map2.put(string, function0);
        }
        profileEvaluators = MapsKt.plus((Map)var3_3, (Pair)TuplesKt.to((Object)"JS", (Object)((Object)profileEvaluators.3.INSTANCE)));
    }
}

