/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.AnonymousTypeSubstitutor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001AB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJN\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J8\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ>\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J.\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0002J(\u0010)\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020.H\u0002J@\u0010/\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00100\u001a\u00020-2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u00102\u001a\u00020\u000eH\u0002J6\u00103\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eJ@\u00106\u001a\u0002072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J8\u00108\u001a\u0002072\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J6\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aJ8\u0010<\u001a\u0002072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J8\u0010>\u001a\u0002072\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010?\u001a\u00020\u0016*\u00020@H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "isOperatorProvideDelegateSupported", "", "()Z", "getGetSetValueMethod", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "delegateType", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "isGet", "isComplete", "getGetValueMethodReturnType", "variableDescriptor", "byExpressionType", "initializerScope", "getProvideDelegateMethod", "delegateExpressionType", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getResolvedDelegateType", "renderCall", "", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reportDelegateOperatorResolutionError", "delegateOperatorCall", "delegateOperatorResults", "operatorRequired", "resolveDelegateExpression", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "resolveGetSetValueMethod", "", "resolveGetValueMethod", "resolvePropertyDelegate", "outerDataFlowInfo", "propertyHeaderScope", "resolveProvideDelegateMethod", "byExpression", "resolveSetValueMethod", "createExpressionForProperty", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "ConstraintSystemCompleterImpl", "frontend"})
public final class DelegatedPropertyResolver {
    private final KotlinBuiltIns builtIns;
    private final FakeCallResolver fakeCallResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;

    public final void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull LexicalScope propertyHeaderScope, @NotNull BindingTrace trace) {
        LexicalScope lexicalScope;
        KtPropertyAccessor setter2;
        KtPropertyAccessor ktPropertyAccessor;
        KtPropertyAccessor getter2;
        Intrinsics.checkParameterIsNotNull((Object)outerDataFlowInfo, (String)"outerDataFlowInfo");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
        Intrinsics.checkParameterIsNotNull((Object)propertyHeaderScope, (String)"propertyHeaderScope");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        KtPropertyAccessor ktPropertyAccessor2 = property.getGetter();
        if (ktPropertyAccessor2 != null && (getter2 = (ktPropertyAccessor = ktPropertyAccessor2)).hasBody()) {
            trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)getter2)));
        }
        KtPropertyAccessor ktPropertyAccessor3 = property.getSetter();
        if (ktPropertyAccessor3 != null && (setter2 = (ktPropertyAccessor = ktPropertyAccessor3)).hasBody()) {
            trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)setter2)));
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            LexicalScope lexicalScope2 = ScopeUtils.makeScopeForPropertyInitializer(propertyHeaderScope, (PropertyDescriptor)variableDescriptor);
            lexicalScope = lexicalScope2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope2, (String)"ScopeUtils.makeScopeForP\u2026cope, variableDescriptor)");
        } else {
            lexicalScope = propertyHeaderScope;
        }
        LexicalScope initializerScope = lexicalScope;
        KotlinType byExpressionType = this.resolveDelegateExpression(delegateExpression, property, variableDescriptor, initializerScope, trace, outerDataFlowInfo);
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression, byExpressionType, trace, initializerScope, outerDataFlowInfo);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression, byExpressionType, trace);
        this.resolveGetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, outerDataFlowInfo);
        if (property.isVar()) {
            this.resolveSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, outerDataFlowInfo);
        }
    }

    private final KotlinType getResolvedDelegateType(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType byExpressionType, BindingTrace trace) {
        ResolvedCall provideDelegateResolvedCall = (ResolvedCall)trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
        if (provideDelegateResolvedCall != null) {
            Object d = provideDelegateResolvedCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"provideDelegateResolvedCall.resultingDescriptor");
            KotlinType kotlinType = ((FunctionDescriptor)d).getReturnType();
            if (kotlinType == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No return type fore 'provideDelegate' of " + delegateExpression.getText())));
            }
            return kotlinType;
        }
        return byExpressionType;
    }

    @Nullable
    public final KotlinType getGetValueMethodReturnType(@NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull KotlinType byExpressionType, @NotNull BindingTrace trace, @NotNull LexicalScope initializerScope, @NotNull DataFlowInfo dataFlowInfo) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
        Intrinsics.checkParameterIsNotNull((Object)byExpressionType, (String)"byExpressionType");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)initializerScope, (String)"initializerScope");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression, byExpressionType, trace, initializerScope, dataFlowInfo);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression, byExpressionType, trace);
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, true);
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, variableDescriptor.getGetter());
        if (resolvedCall2 != null) {
            Object d = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"resolvedCall.resultingDescriptor");
            kotlinType = ((FunctionDescriptor)d).getReturnType();
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    private final boolean isOperatorProvideDelegateSupported() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate);
    }

    private final void resolveGetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        KotlinType returnType = this.getGetValueMethodReturnType(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo);
        KotlinType propertyType = variableDescriptor.getType();
        if (!(propertyType instanceof DeferredType) && returnType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType, propertyType)) {
            Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, variableDescriptor.getGetter());
            if (call2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Call should exists for " + variableDescriptor.getGetter())));
            }
            Call call3 = call2;
            PsiElement psiElement = (PsiElement)delegateExpression;
            Call call4 = call3;
            Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"call");
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)psiElement, this.renderCall(call4, bindingContext), variableDescriptor.getType(), returnType));
        }
    }

    private final void resolveSetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, false);
    }

    private final KtExpression createExpressionForProperty(@NotNull KtPsiFactory $receiver) {
        return $receiver.createExpression("null as " + KotlinBuiltIns.FQ_NAMES.kProperty.asSingleFqName().asString() + "<*>");
    }

    private final void resolveGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, boolean isGet) {
        KtPropertyDelegate delegate;
        PsiElement declaration;
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression.getText())));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.getGetSetValueMethod(propertyDescriptor, delegateExpression, delegateType, trace, initializerScope, dataFlowInfo, isGet, true);
        if (!functionResults.isSuccess()) {
            Call call2;
            Call call3 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
            if (call3 == null) {
                throw (Throwable)((Object)new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call"));
            }
            Call call4 = call2 = call3;
            Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"call");
            DelegatedPropertyResolver.reportDelegateOperatorResolutionError$default(this, trace, call4, functionResults, delegateExpression, delegateType, false, 32, null);
            return;
        }
        FunctionDescriptor resultingDescriptor = functionResults.getResultingDescriptor();
        ResolvedCall<FunctionDescriptor> resultingCall = functionResults.getResultingCall();
        FunctionDescriptor functionDescriptor = resultingDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"resultingDescriptor");
        if (!functionDescriptor.isOperator() && (declaration = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor)) instanceof KtProperty && (delegate = ((KtProperty)declaration).getDelegate()) != null) {
            PsiElement byKeyword;
            ASTNode aSTNode = delegate.getByKeywordNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"delegate.byKeywordNode");
            PsiElement psiElement = byKeyword = aSTNode.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"byKeyword");
            OperatorCallChecker.Companion.report(psiElement, resultingDescriptor, trace);
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, resultingCall);
    }

    private final boolean reportDelegateOperatorResolutionError(BindingTrace trace, Call delegateOperatorCall, OverloadResolutionResults<FunctionDescriptor> delegateOperatorResults, KtExpression delegateExpression, KotlinType delegateType, boolean operatorRequired) {
        DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> resolutionErrorFactory;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext);
        DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<Object>>> diagnosticFactory2 = delegateOperatorResults.isSingleResult() || delegateOperatorResults.isIncomplete() || delegateOperatorResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES ? Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE : (resolutionErrorFactory = delegateOperatorResults.isAmbiguity() ? Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY : null);
        if (resolutionErrorFactory != null) {
            trace.report(resolutionErrorFactory.on((KtExpression)((PsiElement)delegateExpression), expectedFunction, delegateOperatorResults.getResultingCalls()));
            return true;
        }
        if (operatorRequired) {
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on((KtExpression)((PsiElement)delegateExpression), expectedFunction, delegateType));
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean reportDelegateOperatorResolutionError$default(DelegatedPropertyResolver delegatedPropertyResolver, BindingTrace bindingTrace, Call call2, OverloadResolutionResults overloadResolutionResults, KtExpression ktExpression, KotlinType kotlinType, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return delegatedPropertyResolver.reportDelegateOperatorResolutionError(bindingTrace, call2, overloadResolutionResults, ktExpression, kotlinType, bl);
    }

    private final void resolveProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression byExpression, KotlinType byExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        FunctionDescriptor resultingDescriptor;
        TemporaryBindingTrace traceForProvideDelegate;
        if (!this.isOperatorProvideDelegateSupported()) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor) != null) {
            return;
        }
        TemporaryBindingTrace temporaryBindingTrace = traceForProvideDelegate = TemporaryBindingTrace.create(trace, "trace to resolve provideDelegate method");
        Intrinsics.checkExpressionValueIsNotNull((Object)temporaryBindingTrace, (String)"traceForProvideDelegate");
        OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(propertyDescriptor, byExpression, byExpressionType, temporaryBindingTrace, initializerScope, dataFlowInfo);
        if (!provideDelegateResults.isSuccess()) {
            Call call2 = (Call)traceForProvideDelegate.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor);
            if (call2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call"));
            }
            Call call3 = call2;
            BindingTrace bindingTrace = traceForProvideDelegate;
            Call call4 = call3;
            Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"call");
            boolean shouldCommitTrace = this.reportDelegateOperatorResolutionError(bindingTrace, call4, provideDelegateResults, byExpression, byExpressionType, false);
            if (shouldCommitTrace) {
                traceForProvideDelegate.commit();
            }
            return;
        }
        traceForProvideDelegate.commit();
        FunctionDescriptor functionDescriptor = resultingDescriptor = provideDelegateResults.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"resultingDescriptor");
        if (!functionDescriptor.isOperator()) {
            return;
        }
        ResolvedCall<FunctionDescriptor> resultingCall = provideDelegateResults.getResultingCall();
        trace.record(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor, resultingCall);
    }

    private final OverloadResolutionResults<FunctionDescriptor> getGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateType, BindingTrace trace, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, boolean isGet, boolean isComplete) {
        KotlinType kotlinType;
        LexicalScope delegateFunctionsScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression.getText())));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (isComplete && isGet && !(propertyDescriptor.getType() instanceof DeferredType)) {
            KotlinType kotlinType2 = propertyDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"propertyDescriptor.type");
        } else {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        }
        KotlinType expectedType2 = kotlinType;
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, expectedType2, this.languageVersionSettings, this.dataFlowValueFactory);
        boolean hasThis = propertyDescriptor.getExtensionReceiverParameter() != null || propertyDescriptor.getDispatchReceiverParameter() != null;
        ArrayList arguments2 = Lists.newArrayList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression, false);
        arguments2.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments2.add(this.createExpressionForProperty(psiFactory));
        if (!isGet) {
            KtExpression ktExpression = ExpressionTypingUtils.createFakeExpressionOfType(delegateExpression.getProject(), trace, "fakeArgument" + arguments2.size(), propertyDescriptor.getType());
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            }
            KtReferenceExpression fakeArgument = (KtReferenceExpression)ktExpression;
            arguments2.add(fakeArgument);
            List<ValueParameterDescriptor> valueParameters = accessor.getValueParameters();
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters.get(0));
        }
        Name functionName = isGet ? OperatorNameConventions.GET_VALUE : OperatorNameConventions.SET_VALUE;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression, delegateType, bindingContext);
        ReceiverValue receiverValue = receiver;
        ExpressionTypingContext expressionTypingContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context");
        ResolutionContext resolutionContext = expressionTypingContext;
        ArrayList arrayList = arguments2;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"arguments");
        Pair resolutionResult = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiverValue, resolutionContext, arrayList, functionName, delegateExpression, null, null, 96, null);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, resolutionResult.getFirst());
        return (OverloadResolutionResults)resolutionResult.getSecond();
    }

    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        ExpressionTypingContext context;
        ExpressionTypingContext expressionTypingContext = context = ExpressionTypingContext.newContext(trace, initializerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory);
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context");
        return this.getProvideDelegateMethod(propertyDescriptor, delegateExpression, delegateExpressionType, expressionTypingContext);
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression, KotlinType delegateExpressionType, ExpressionTypingContext context) {
        void provideDelegateCall;
        KtPsiFactory ktPsiFactory;
        boolean propertyHasReceiver = propertyDescriptor.getDispatchReceiverParameter() != null;
        KtPsiFactory $receiver = ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression, false);
        List arguments2 = CollectionsKt.listOf((Object[])new KtExpression[]{$receiver.createExpression(propertyHasReceiver ? "this" : "null"), this.createExpressionForProperty($receiver)});
        Name functionName = OperatorNameConventions.PROVIDE_DELEGATE;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression, delegateExpressionType, bindingContext);
        Pair pair = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiver, context, arguments2, functionName, delegateExpression, null, null, 96, null);
        Call $i$a$1$run = (Call)pair.component1();
        OverloadResolutionResults provideDelegateResults = (OverloadResolutionResults)pair.component2();
        if (provideDelegateResults.isSingleResult()) {
            context.trace.record(BindingContext.DELEGATE_EXPRESSION_TO_PROVIDE_DELEGATE_CALL, delegateExpression, provideDelegateCall);
        }
        context.trace.record(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor, provideDelegateCall);
        return provideDelegateResults;
    }

    private final String renderCall(Call call2, BindingContext context) {
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"CalleeExpression should exists for fake call of convention method"));
        }
        KtExpression calleeExpression = ktExpression;
        List<? extends ValueArgument> list2 = call2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"call.valueArguments");
        Iterable iterable = list2;
        StringBuilder stringBuilder = new StringBuilder().append("");
        KtExpression ktExpression2 = calleeExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"calleeExpression");
        Function1 function1 = (Function1)new Function1<ValueArgument, String>(context){
            final /* synthetic */ BindingContext $context;

            @NotNull
            public final String invoke(ValueArgument argument) {
                KotlinType type2;
                KtExpression ktExpression = argument.getArgumentExpression();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType kotlinType = this.$context.getType(ktExpression);
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType kotlinType2 = type2 = kotlinType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                return DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(kotlinType2);
            }
            {
                this.$context = bindingContext;
                super(1);
            }
        };
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = ", ";
        CharSequence charSequence3 = ")";
        CharSequence charSequence4 = stringBuilder.append(ktExpression2.getText()).append('(').toString();
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence2, (CharSequence)charSequence4, (CharSequence)charSequence3, (int)n, charSequence, (Function1)function1, (int)24, null);
    }

    @NotNull
    public final KotlinType resolveDelegateExpression(@NotNull KtExpression delegateExpression, @NotNull KtProperty property, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        KotlinType expectedTypeByNewInference;
        KotlinType kotlinType;
        KotlinType kotlinType2;
        Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)scopeForDelegate, (String)"scopeForDelegate");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        TemporaryBindingTrace traceToResolveDelegatedProperty = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        if (property.getTypeReference() != null) {
            KotlinType kotlinType3 = variableDescriptor.getType();
            kotlinType2 = kotlinType3;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"variableDescriptor.type");
        } else {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
            kotlinType2 = simpleType2;
        }
        KotlinType propertyExpectedType = kotlinType2;
        ConstraintSystemCompleterImpl completer = new ConstraintSystemCompleterImpl(property, propertyExpectedType, variableDescriptor, delegateExpression, scopeForDelegate, trace, dataFlowInfo);
        KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny(delegateExpression);
        if (ktExpression != null) {
            KtExpression ktExpression2;
            KtExpression it = ktExpression2 = ktExpression;
            WritableSlice<KtElement, ConstraintSystemCompleter> writableSlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"CONSTRAINT_SYSTEM_COMPLETER");
            traceToResolveDelegatedProperty.record(writableSlice, it, completer);
        }
        if ((kotlinType = (expectedTypeByNewInference = completer.resolveViaNewInference(delegateExpression, variableDescriptor, scopeForDelegate, trace, dataFlowInfo))) == null) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        KotlinType delegateType = this.expressionTypingServices.safeGetType(scopeForDelegate, delegateExpression, kotlinType, dataFlowInfo, traceToResolveDelegatedProperty);
        traceToResolveDelegatedProperty.commit(resolveDelegateExpression.2.INSTANCE, true);
        KotlinType kotlinType4 = delegateType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"delegateType");
        return kotlinType4;
    }

    public DelegatedPropertyResolver(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J*\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\u0016\u0010,\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020&0.H\u0002J(\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0002J0\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver$ConstraintSystemCompleterImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemCompleter;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "(Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDelegateExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpectedType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getProperty", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getScopeForDelegate", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getVariableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "addConstraintForThisValue", "", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "typeVariableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "resultingDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "dispatchReceiverOnly", "", "completeConstraintSystem", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "conventionMethodFound", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "getDelegateType", "byExpressionType", "traceToResolveConventionMethods", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "resolveViaNewInference", "frontend"})
    public final class ConstraintSystemCompleterImpl
    implements ConstraintSystemCompleter {
        @NotNull
        private final KtProperty property;
        @NotNull
        private final KotlinType expectedType;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final KtExpression delegateExpression;
        @NotNull
        private final LexicalScope scopeForDelegate;
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final DataFlowInfo dataFlowInfo;

        @Override
        public void completeConstraintSystem(@NotNull ConstraintSystem.Builder constraintSystem, @NotNull ResolvedCall<?> resolvedCall2) {
            Intrinsics.checkParameterIsNotNull((Object)constraintSystem, (String)"constraintSystem");
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.candidateDescriptor");
            KotlinType kotlinType = obj.getReturnType();
            if (kotlinType == null) {
                return;
            }
            KotlinType returnType = kotlinType;
            Map<CallHandle, TypeSubstitutor> map2 = constraintSystem.getTypeVariableSubstitutors();
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
            TypeSubstitutor typeSubstitutor2 = map2.get(TypeVariableKt.toHandle(call2));
            if (typeSubstitutor2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No substitutor in the system for call: " + resolvedCall2.getCall())));
            }
            TypeSubstitutor typeVariableSubstitutor = typeSubstitutor2;
            TemporaryBindingTrace traceToResolveConventionMethods = TemporaryBindingTrace.create(this.trace, "Trace to resolve delegated property convention methods");
            KotlinType kotlinType2 = returnType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"returnType");
            TemporaryBindingTrace temporaryBindingTrace = traceToResolveConventionMethods;
            Intrinsics.checkExpressionValueIsNotNull((Object)temporaryBindingTrace, (String)"traceToResolveConventionMethods");
            KotlinType delegateType = this.getDelegateType(kotlinType2, constraintSystem, typeVariableSubstitutor, temporaryBindingTrace);
            OverloadResolutionResults getValueResults = DelegatedPropertyResolver.this.getGetSetValueMethod(this.variableDescriptor, this.delegateExpression, delegateType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, true, false);
            if (this.conventionMethodFound(getValueResults)) {
                KotlinType returnTypeInSystem;
                FunctionDescriptor getValueDescriptor;
                FunctionDescriptor functionDescriptor = getValueDescriptor = (FunctionDescriptor)getValueResults.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"getValueDescriptor");
                KotlinType getValueReturnType = functionDescriptor.getReturnType();
                if (getValueReturnType != null && !TypeUtils.noExpectedType(this.expectedType) && (returnTypeInSystem = typeVariableSubstitutor.substitute(getValueReturnType, Variance.INVARIANT)) != null) {
                    constraintSystem.addSubtypeConstraint(returnTypeInSystem, this.expectedType, ConstraintPositionKind.FROM_COMPLETER.position());
                }
                ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, getValueDescriptor, false, 8, null);
            }
            if (!this.variableDescriptor.isVar()) {
                return;
            }
            if (this.variableDescriptor.getReturnType() instanceof DeferredType) {
                return;
            }
            OverloadResolutionResults setValueResults = DelegatedPropertyResolver.this.getGetSetValueMethod(this.variableDescriptor, this.delegateExpression, delegateType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, false, false);
            if (this.conventionMethodFound(setValueResults)) {
                FunctionDescriptor setValueDescriptor;
                FunctionDescriptor functionDescriptor = setValueDescriptor = (FunctionDescriptor)setValueResults.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"setValueDescriptor");
                List<ValueParameterDescriptor> setValueParameters = functionDescriptor.getValueParameters();
                if (setValueParameters.size() == 3) {
                    if (!TypeUtils.noExpectedType(this.expectedType)) {
                        ValueParameterDescriptor valueParameterDescriptor = setValueParameters.get(2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"setValueParameters[2]");
                        KotlinType thisParameterType = valueParameterDescriptor.getType();
                        KotlinType substitutedThisParameterType = typeVariableSubstitutor.substitute(thisParameterType, Variance.INVARIANT);
                        constraintSystem.addSubtypeConstraint(this.expectedType, substitutedThisParameterType, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, setValueDescriptor, false, 8, null);
                }
            }
        }

        private final KotlinType getDelegateType(KotlinType byExpressionType, ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, TemporaryBindingTrace traceToResolveConventionMethods) {
            OverloadResolutionResults provideDelegateResults;
            if (DelegatedPropertyResolver.this.isOperatorProvideDelegateSupported() && this.conventionMethodFound(provideDelegateResults = DelegatedPropertyResolver.this.getProvideDelegateMethod(this.variableDescriptor, this.delegateExpression, byExpressionType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo))) {
                FunctionDescriptor provideDelegateDescriptor;
                FunctionDescriptor functionDescriptor = provideDelegateDescriptor = (FunctionDescriptor)provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"provideDelegateDescriptor");
                KotlinType provideDelegateReturnType = functionDescriptor.getReturnType();
                if (provideDelegateDescriptor.isOperator()) {
                    this.addConstraintForThisValue(constraintSystem, typeVariableSubstitutor, provideDelegateDescriptor, true);
                    KotlinType kotlinType = provideDelegateReturnType;
                    if (kotlinType == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("No return type fore 'provideDelegate' of " + this.delegateExpression.getText())));
                    }
                    return kotlinType;
                }
            }
            return byExpressionType;
        }

        private final boolean conventionMethodFound(OverloadResolutionResults<FunctionDescriptor> results) {
            return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
        }

        private final void addConstraintForThisValue(ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, FunctionDescriptor resultingDescriptor, boolean dispatchReceiverOnly) {
            ValueParameterDescriptor valueParameterForThis;
            Annotated annotated;
            Annotated annotated2;
            ReceiverParameterDescriptor extensionReceiver = this.variableDescriptor.getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.variableDescriptor.getDispatchReceiverParameter();
            if (dispatchReceiverOnly) {
                ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                annotated2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
            } else {
                annotated2 = extensionReceiver;
                if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                    annotated2 = annotated = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
                }
            }
            if (annotated2 == null) {
                SimpleType simpleType2 = DelegatedPropertyResolver.this.builtIns.getNullableNothingType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.nullableNothingType");
                annotated = simpleType2;
            }
            Annotated typeOfThis = annotated;
            List<ValueParameterDescriptor> valueParameters = resultingDescriptor.getValueParameters();
            if (valueParameters.isEmpty()) {
                return;
            }
            ValueParameterDescriptor valueParameterDescriptor = valueParameterForThis = valueParameters.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"valueParameterForThis");
            constraintSystem.addSubtypeConstraint((KotlinType)typeOfThis, typeVariableSubstitutor.substitute(valueParameterDescriptor.getType(), Variance.INVARIANT), ConstraintPositionKind.FROM_COMPLETER.position());
        }

        static /* synthetic */ void addConstraintForThisValue$default(ConstraintSystemCompleterImpl constraintSystemCompleterImpl, ConstraintSystem.Builder builder, TypeSubstitutor typeSubstitutor2, FunctionDescriptor functionDescriptor, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            constraintSystemCompleterImpl.addConstraintForThisValue(builder, typeSubstitutor2, functionDescriptor, bl);
        }

        @Nullable
        public final KotlinType resolveViaNewInference(@NotNull KtExpression delegateExpression, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
            UnwrappedType unwrappedType;
            KotlinType expectedType2;
            KotlinType kotlinType;
            KotlinType kotlinType2;
            KotlinType it;
            Call call2;
            Object object;
            KotlinType pretendReturnType;
            KotlinType delegateType;
            Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
            Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)scopeForDelegate, (String)"scopeForDelegate");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
            if (!DelegatedPropertyResolver.this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
                return null;
            }
            TemporaryBindingTrace traceToResolveConventionMethods = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property convention methods");
            KotlinTypeInfo delegateTypeInfo = DelegatedPropertyResolver.this.expressionTypingServices.getTypeInfo(scopeForDelegate, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, traceToResolveConventionMethods, false, delegateExpression, ContextDependency.DEPENDENT);
            ExpressionTypingContext contextForProvideDelegate = ExpressionTypingContext.newContext(traceToResolveConventionMethods, scopeForDelegate, delegateTypeInfo.getDataFlowInfo(), TypeUtils.NO_EXPECTED_TYPE, ContextDependency.DEPENDENT, StatementFilter.NONE, DelegatedPropertyResolver.this.languageVersionSettings, DelegatedPropertyResolver.this.dataFlowValueFactory);
            KotlinType kotlinType3 = delegateTypeInfo.getType();
            TypeConstructor delegateTypeConstructor = kotlinType3 != null ? kotlinType3.getConstructor() : null;
            KotlinType kotlinType4 = delegateType = delegateTypeConstructor instanceof IntegerValueTypeConstructor ? TypeUtils.getDefaultPrimitiveNumberType((IntegerValueTypeConstructor)delegateTypeConstructor) : delegateTypeInfo.getType();
            if (kotlinType4 == null) {
                return null;
            }
            ExpressionTypingContext expressionTypingContext = contextForProvideDelegate;
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"contextForProvideDelegate");
            OverloadResolutionResults provideDelegateResults = DelegatedPropertyResolver.this.getProvideDelegateMethod(variableDescriptor, delegateExpression, kotlinType4, expressionTypingContext);
            KotlinTypeInfo typeInfoForGetValueReceiver = new KotlinTypeInfo(delegateType, delegateTypeInfo.getDataFlowInfo(), false, null, 12, null);
            if (this.conventionMethodFound(provideDelegateResults)) {
                FunctionDescriptor provideDelegateDescriptor;
                FunctionDescriptor functionDescriptor = provideDelegateDescriptor = (FunctionDescriptor)provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"provideDelegateDescriptor");
                if (functionDescriptor.isOperator()) {
                    KotlinType kotlinType5 = provideDelegateDescriptor.getReturnType();
                    ResolvedCall resolvedCall2 = provideDelegateResults.getResultingCall();
                    Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, (String)"provideDelegateResults.resultingCall");
                    DataFlowInfoForArguments dataFlowInfoForArguments = resolvedCall2.getDataFlowInfoForArguments();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfoForArguments, (String)"provideDelegateResults.r\u2026.dataFlowInfoForArguments");
                    DataFlowInfo dataFlowInfo2 = dataFlowInfoForArguments.getResultInfo();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo2, (String)"provideDelegateResults.r\u2026foForArguments.resultInfo");
                    typeInfoForGetValueReceiver = new KotlinTypeInfo(kotlinType5, dataFlowInfo2, false, null, 12, null);
                }
            }
            KotlinType kotlinType6 = typeInfoForGetValueReceiver.getType();
            if (kotlinType6 == null) {
                return null;
            }
            TemporaryBindingTrace temporaryBindingTrace = traceToResolveConventionMethods;
            Intrinsics.checkExpressionValueIsNotNull((Object)temporaryBindingTrace, (String)"traceToResolveConventionMethods");
            DelegatedPropertyResolver.this.getGetSetValueMethod(variableDescriptor, delegateExpression, kotlinType6, temporaryBindingTrace, scopeForDelegate, typeInfoForGetValueReceiver.getDataFlowInfo(), true, true);
            if (variableDescriptor.isVar() && !(variableDescriptor.getReturnType() instanceof DeferredType)) {
                KotlinType kotlinType7 = typeInfoForGetValueReceiver.getType();
                if (kotlinType7 == null) {
                    return null;
                }
                DelegatedPropertyResolver.this.getGetSetValueMethod(variableDescriptor, delegateExpression, kotlinType7, traceToResolveConventionMethods, scopeForDelegate, typeInfoForGetValueReceiver.getDataFlowInfo(), false, true);
            }
            KotlinType kotlinType8 = pretendReturnType = (object = CallUtilKt.getResolvedCall(call2 = CallUtilKt.getCall(delegateExpression, traceToResolveConventionMethods.getBindingContext()), traceToResolveConventionMethods.getBindingContext())) != null && (object = object.getResultingDescriptor()) != null ? object.getReturnType() : null;
            if (kotlinType8 != null) {
                KotlinType kotlinType9 = it = (kotlinType2 = kotlinType8);
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType9, (String)"it");
                kotlinType = !TypeUtilsKt.contains(kotlinType9, (Function1<? super UnwrappedType, Boolean>)((Function1)resolveViaNewInference.expectedType.1.1.INSTANCE)) ? kotlinType2 : null;
            } else {
                kotlinType = null;
            }
            KotlinType kotlinType10 = expectedType2 = kotlinType;
            if (kotlinType10 != null) {
                it = kotlinType2 = kotlinType10;
                unwrappedType = AnonymousTypeSubstitutor.INSTANCE.safeSubstitute(it.unwrap());
            } else {
                unwrappedType = null;
            }
            return unwrappedType;
        }

        @NotNull
        public final KtProperty getProperty() {
            return this.property;
        }

        @NotNull
        public final KotlinType getExpectedType() {
            return this.expectedType;
        }

        @NotNull
        public final VariableDescriptorWithAccessors getVariableDescriptor() {
            return this.variableDescriptor;
        }

        @NotNull
        public final KtExpression getDelegateExpression() {
            return this.delegateExpression;
        }

        @NotNull
        public final LexicalScope getScopeForDelegate() {
            return this.scopeForDelegate;
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @NotNull
        public final DataFlowInfo getDataFlowInfo() {
            return this.dataFlowInfo;
        }

        public ConstraintSystemCompleterImpl(@NotNull KtProperty property, @NotNull KotlinType expectedType2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, DataFlowInfo dataFlowInfo) {
            Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
            Intrinsics.checkParameterIsNotNull((Object)expectedType2, (String)"expectedType");
            Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)delegateExpression, (String)"delegateExpression");
            Intrinsics.checkParameterIsNotNull((Object)scopeForDelegate, (String)"scopeForDelegate");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
            this.property = property;
            this.expectedType = expectedType2;
            this.variableDescriptor = variableDescriptor;
            this.delegateExpression = delegateExpression;
            this.scopeForDelegate = scopeForDelegate;
            this.trace = trace;
            this.dataFlowInfo = dataFlowInfo;
        }
    }
}

