/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\f\u001a\u00020\r\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\"\u0019\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getName", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "setInlineCallMetadata", "", "expression", "psiElement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "aliasedName", "js.translator"})
@JvmName(name="InlineUtils")
public final class InlineUtils {
    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtExpression psiElement, @NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean bl = CallExpressionTranslator.shouldBeInlined(descriptor2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Expected descriptor of callable, that should be inlined, but got: " + descriptor2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object[] objectArray = new JsName[2];
        objectArray[0] = InlineUtils.aliasedName(context, descriptor2);
        JsName jsName = context.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"context.getInnerNameForDescriptor(descriptor)");
        objectArray[1] = jsName;
        Set candidateNames = SetsKt.setOf((Object[])objectArray);
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(descriptor2, candidateNames, psiElement){
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ Set $candidateNames;
            final /* synthetic */ KtExpression $psiElement;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
                super.visitInvocation(invocation);
                if (CollectionsKt.contains((Iterable)this.$candidateNames, (Object)InlineUtils.getName(invocation)) || Intrinsics.areEqual((Object)((object = InlineUtils.getName(invocation)) != null && (object = MetadataProperties.getDescriptor((JsName)object)) != null ? object.getOriginal() : null), (Object)this.$descriptor.getOriginal())) {
                    MetadataProperties.setDescriptor(invocation, this.$descriptor);
                    MetadataProperties.setInlineStrategy(invocation, InlineStrategy.IN_PLACE);
                    MetadataProperties.setPsiElement(invocation, (PsiElement)this.$psiElement);
                }
            }
            {
                this.$descriptor = $captured_local_variable$0;
                this.$candidateNames = $captured_local_variable$1;
                this.$psiElement = $captured_local_variable$2;
            }
        };
        visitor2.accept((JsNode)expression2);
        context.addInlineCall(descriptor2);
    }

    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtExpression psiElement, @NotNull ResolvedCall<?> resolvedCall2, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = PsiUtils.getFunctionDescriptor(resolvedCall2);
        Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"PsiUtils.getFunctionDescriptor(resolvedCall)");
        InlineUtils.setInlineCallMetadata(expression2, psiElement, callableDescriptor, context);
    }

    public static final void setInlineCallMetadata(@NotNull JsNameRef nameRef, @NotNull KtExpression psiElement, @NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (MetadataProperties.getInlineStrategy(nameRef) != null) {
            return;
        }
        MetadataProperties.setDescriptor(nameRef, descriptor2);
        MetadataProperties.setInlineStrategy(nameRef, InlineStrategy.IN_PLACE);
        MetadataProperties.setPsiElement(nameRef, (PsiElement)psiElement);
        context.addInlineCall(descriptor2);
    }

    @NotNull
    public static final JsName aliasedName(@NotNull TranslationContext $receiver, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        JsExpression alias = $receiver.getAliasForDescriptor(descriptor2);
        JsExpression jsExpression = alias;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        JsName aliasName = jsNameRef != null ? jsNameRef.getName() : null;
        JsName jsName = aliasName;
        if (jsName == null) {
            JsName jsName2 = $receiver.getNameForDescriptor(descriptor2);
            jsName = jsName2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"getNameForDescriptor(descriptor)");
        }
        return jsName;
    }

    @Nullable
    public static final JsName getName(@Nullable JsExpression $receiver) {
        JsName jsName;
        JsExpression jsExpression = $receiver;
        if (jsExpression instanceof JsInvocation) {
            JsExpression qualifier = ((JsInvocation)$receiver).getQualifier();
            if (InvocationUtilsKt.isCallInvocation((JsInvocation)$receiver)) {
                JsExpression jsExpression2 = qualifier;
                if (jsExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
                }
                jsName = InlineUtils.getName(((JsNameRef)jsExpression2).getQualifier());
            } else {
                jsName = InlineUtils.getName(qualifier);
            }
        } else {
            jsName = jsExpression instanceof JsNameRef ? ((JsNameRef)$receiver).getName() : null;
        }
        return jsName;
    }
}

