/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u001e2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver;", "", "()V", "getCallerName", "Lorg/jetbrains/kotlin/name/Name;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getContainingCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getElementsByLabelName", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "labelName", "labelExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getExpressionUnderLabel", "labeledExpression", "getLabelForFunctionalExpression", "element", "getLabelNameIfAny", "Lcom/intellij/psi/PsiElement;", "resolveControlLabel", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolveNamedLabel", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveThisOrSuperLabel", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "Lorg/jetbrains/kotlin/psi/KtInstanceExpressionWithLabel;", "LabeledReceiverResolutionResult", "frontend"})
public final class LabelResolver {
    public static final LabelResolver INSTANCE;

    private final Set<KtElement> getElementsByLabelName(Name labelName, KtSimpleNameExpression labelExpression) {
        LinkedHashSet<KtExpression> elements = new LinkedHashSet<KtExpression>();
        for (PsiElement parent2 = labelExpression.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            Name name = this.getLabelNameIfAny(parent2);
            if (name == null || !Intrinsics.areEqual((Object)name, (Object)labelName)) continue;
            elements.add(this.getExpressionUnderLabel((KtExpression)parent2));
        }
        return elements;
    }

    @Nullable
    public final Name getLabelNameIfAny(@NotNull PsiElement element) {
        Name name;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof KtLabeledExpression) {
            name = ((KtLabeledExpression)element).getLabelNameAsName();
        } else if (psiElement instanceof KtFunctionLiteral) {
            PsiElement psiElement2 = ((KtFunctionLiteral)element).getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.parent");
            name = this.getLabelNameIfAny(psiElement2);
        } else if (psiElement instanceof KtLambdaExpression) {
            name = this.getLabelForFunctionalExpression((KtExpression)element);
        } else if (psiElement instanceof KtNamedFunction) {
            name = ((KtNamedFunction)element).getNameAsName();
            if (name == null) {
                name = this.getLabelForFunctionalExpression((KtExpression)element);
            }
        } else {
            name = null;
        }
        return name;
    }

    private final Name getLabelForFunctionalExpression(KtExpression element) {
        PsiElement parent2 = element.getParent();
        PsiElement psiElement = parent2;
        return psiElement instanceof KtLabeledExpression ? this.getLabelNameIfAny(parent2) : (psiElement instanceof KtBinaryExpression ? ((KtBinaryExpression)parent2).getOperationReference().getReferencedNameAsName() : this.getCallerName(element));
    }

    private final KtExpression getExpressionUnderLabel(KtExpression labeledExpression) {
        KtExpression ktExpression;
        KtExpression expression2 = KtPsiUtil.safeDeparenthesize(labeledExpression);
        if (expression2 instanceof KtLambdaExpression) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)expression2).getFunctionLiteral();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"expression.functionLiteral");
            ktExpression = ktFunctionLiteral;
        } else {
            KtExpression ktExpression2 = expression2;
            ktExpression = ktExpression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression");
        }
        return ktExpression;
    }

    private final Name getCallerName(KtExpression expression2) {
        KtSimpleNameExpression calleeExpression;
        KtCallExpression ktCallExpression = this.getContainingCallExpression(expression2);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = calleeExpression = (KtSimpleNameExpression)ktExpression;
        return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
    }

    private final KtCallExpression getContainingCallExpression(KtExpression expression2) {
        PsiElement call2;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtLambdaArgument && (call2 = ((KtLambdaArgument)parent2).getParent()) instanceof KtCallExpression) {
            return (KtCallExpression)call2;
        }
        if (parent2 instanceof KtValueArgument) {
            PsiElement psiElement = ((KtValueArgument)parent2).getParent();
            if (psiElement == null) {
                return null;
            }
            PsiElement argList = psiElement;
            PsiElement call3 = argList.getParent();
            if (call3 instanceof KtCallExpression) {
                return (KtCallExpression)call3;
            }
        }
        return null;
    }

    @Nullable
    public final KtElement resolveControlLabel(@NotNull KtExpressionWithLabel expression2, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        KtSimpleNameExpression labelElement = expression2.getTargetLabel();
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        ReservedCheckingKt.checkReservedYield(labelElement, bindingTrace);
        Name labelName = expression2.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
        KtElement ktElement = this.resolveNamedLabel(labelName, labelElement, bindingTrace2);
        if (ktElement == null) {
            LabelResolver labelResolver;
            LabelResolver $receiver = labelResolver = this;
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)labelElement), labelElement));
            ktElement = null;
        }
        return ktElement;
    }

    private final KtElement resolveNamedLabel(Name labelName, KtSimpleNameExpression labelExpression, BindingTrace trace) {
        Set<KtElement> list2 = this.getElementsByLabelName(labelName, labelExpression);
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on((KtSimpleNameExpression)((PsiElement)labelExpression)));
        }
        Object object = CollectionsKt.first((Iterable)list2);
        KtElement it = (KtElement)object;
        trace.record(BindingContext.LABEL_TARGET, labelExpression, it);
        return (KtElement)object;
    }

    @NotNull
    public final LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull KtInstanceExpressionWithLabel expression2, @NotNull ResolutionContext<?> context, @NotNull Name labelName) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)labelName, (String)"labelName");
        KtReferenceExpression referenceExpression = expression2.getInstanceReference();
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
        if (ktSimpleNameExpression == null) {
            throw (Throwable)new IllegalStateException(((Object)expression2).toString());
        }
        KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(lexicalScope, labelName);
        int size = declarationsByLabel.size();
        switch (size) {
            case 1: {
                ReceiverParameterDescriptor receiverParameterDescriptor;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)CollectionsKt.single((Iterable)declarationsByLabel);
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
                } else if (declarationDescriptor2 instanceof FunctionDescriptor) {
                    receiverParameterDescriptor = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
                    receiverParameterDescriptor = ((PropertyDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else {
                    throw (Throwable)new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
                }
                ReceiverParameterDescriptor thisReceiver = receiverParameterDescriptor;
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement == null) {
                    String string = "No PSI element for descriptor: " + declarationDescriptor;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                PsiElement element = psiElement;
                context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, (PsiElement)targetLabel, (ClassDescriptor)declarationDescriptor)) {
                    return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                }
                return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(thisReceiver);
            }
            case 0: {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
                KtElement element = this.resolveNamedLabel(labelName, targetLabel, bindingTrace);
                BindingTrace bindingTrace2 = context.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
                DeclarationDescriptor declarationDescriptor = bindingTrace2.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    ReceiverParameterDescriptor thisReceiver = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                    if (thisReceiver != null) {
                        context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                        context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                    }
                    return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(thisReceiver);
                }
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)targetLabel), targetLabel));
                break;
            }
            default: {
                BindingContextUtils.reportAmbiguousLabel(context.trace, targetLabel, declarationsByLabel);
            }
        }
        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
    }

    private LabelResolver() {
    }

    static {
        LabelResolver labelResolver;
        INSTANCE = labelResolver = new LabelResolver();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "", "code", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "(Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)V", "getCode", "()Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "getReceiverParameterDescriptor", "success", "", "Code", "Companion", "frontend"})
    public static final class LabeledReceiverResolutionResult {
        @NotNull
        private final Code code;
        private final ReceiverParameterDescriptor receiverParameterDescriptor;
        public static final Companion Companion = new Companion(null);

        public final boolean success() {
            return this.code == Code.SUCCESS;
        }

        @Nullable
        public final ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            boolean bl = this.success();
            if (_Assertions.ENABLED && !bl) {
                String string = "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return this.receiverParameterDescriptor;
        }

        @NotNull
        public final Code getCode() {
            return this.code;
        }

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        public /* synthetic */ LabeledReceiverResolutionResult(@NotNull Code code, @Nullable ReceiverParameterDescriptor receiverParameterDescriptor, DefaultConstructorMarker $constructor_marker) {
            this(code, receiverParameterDescriptor);
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "", "(Ljava/lang/String;I)V", "LABEL_RESOLUTION_ERROR", "NO_THIS", "SUCCESS", "frontend"})
        public static final class Code
        extends Enum<Code> {
            public static final /* enum */ Code LABEL_RESOLUTION_ERROR;
            public static final /* enum */ Code NO_THIS;
            public static final /* enum */ Code SUCCESS;
            private static final /* synthetic */ Code[] $VALUES;

            static {
                Code[] codeArray = new Code[3];
                Code[] codeArray2 = codeArray;
                codeArray[0] = LABEL_RESOLUTION_ERROR = new Code();
                codeArray[1] = NO_THIS = new Code();
                codeArray[2] = SUCCESS = new Code();
                $VALUES = codeArray;
            }

            public static Code[] values() {
                return (Code[])$VALUES.clone();
            }

            public static Code valueOf(String string) {
                return Enum.valueOf(Code.class, string);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Companion;", "", "()V", "labelResolutionFailed", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "labelResolutionSuccess", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "frontend"})
        public static final class Companion {
            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
                if (receiverParameterDescriptor == null) {
                    return new LabeledReceiverResolutionResult(Code.NO_THIS, null, null);
                }
                return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor, null);
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionFailed() {
                return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

