/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrClassKt;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSymbolBaseKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateNewValueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "oldDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "numDefaultParametersToExpect", "", "generateWrapper", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "target", "generateWrapperSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "oldSymbol", "generateWrappers", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "copyWithModifiedParameters", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "backend"})
public final class JvmOverloadsAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Iterable $receiver$iv = irClass.getDeclarations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            if (!(JvmAnnotationUtilKt.findJvmOverloadsAnnotation(it.getDescriptor()) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions2 = (List)destination$iv$iv;
        $receiver$iv = functions2;
        for (Object element$iv : $receiver$iv) {
            IrFunction it = (IrFunction)element$iv;
            this.generateWrappers(it, irClass);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateWrappers(IrFunction target, IrClass irClass) {
        int n;
        List<ValueParameterDescriptor> list2 = target.getSymbol().getDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"target.symbol.descriptor.valueParameters");
        Iterable $receiver$iv22 = list2;
        if ($receiver$iv22 instanceof Collection && ((Collection)$receiver$iv22).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv22) {
                int n2;
                ValueParameterDescriptor it;
                ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                if (!ArgumentsUtilsKt.hasDefaultValue(valueParameterDescriptor) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numDefaultParameters = n;
        int $receiver$iv22 = 0;
        int n3 = numDefaultParameters;
        while ($receiver$iv22 < n3) {
            void i;
            IrFunction wrapper = this.generateWrapper(target, (int)i);
            IrClassKt.addMember(irClass, wrapper);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapper(IrFunction target, int numDefaultParametersToExpect) {
        void $receiver$iv;
        IrGetValueImpl irGetValueImpl;
        IrGetValueImpl irGetValueImpl2;
        IrDeclarationReference irDeclarationReference;
        Object object;
        IrValueParameter irValueParameter;
        IrElement irElement;
        IrFunctionSymbol wrapperSymbol = this.generateWrapperSymbol(target.getSymbol(), numDefaultParametersToExpect);
        IrFunctionSymbol irFunctionSymbol = wrapperSymbol;
        if (irFunctionSymbol instanceof IrConstructorSymbol) {
            irElement = new IrConstructorImpl(-1, -1, (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.JVM_OVERLOADS_WRAPPER.INSTANCE, (IrConstructorSymbol)wrapperSymbol, null, 16, null);
        } else if (irFunctionSymbol instanceof IrSimpleFunctionSymbol) {
            irElement = new IrFunctionImpl(-1, -1, JvmLoweredDeclarationOrigin.JVM_OVERLOADS_WRAPPER.INSTANCE, (IrSimpleFunctionSymbol)wrapperSymbol, null, null, 48, null);
        } else {
            String string = "expected IrConstructorSymbol or IrSimpleFunctionSymbol";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        IrElement wrapperIrFunction = irElement;
        ((IrFunctionBase)wrapperIrFunction).setReturnType(target.getReturnType());
        IrUtilsKt.createParameterDeclarations$default((IrFunction)wrapperIrFunction, null, 1, null);
        IrMemberAccessExpression call2 = target instanceof IrConstructor ? (IrMemberAccessExpression)new IrDelegatingConstructorCallImpl(-1, -1, target.getReturnType(), (IrConstructorSymbol)((IrConstructor)target).getSymbol(), ((IrConstructor)target).getDescriptor()) : (IrMemberAccessExpression)new IrCallImpl(-1, -1, target.getReturnType(), target.getSymbol());
        IrCallWithIndexedArgumentsBase irCallWithIndexedArgumentsBase = (IrCallWithIndexedArgumentsBase)call2;
        IrValueParameter irValueParameter2 = ((IrFunctionBase)wrapperIrFunction).getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            irValueParameter = irValueParameter2;
            object = irCallWithIndexedArgumentsBase;
            IrValueParameter dispatchReceiver = irValueParameter;
            irDeclarationReference = new IrGetValueImpl(-1, -1, dispatchReceiver.getSymbol(), null, 8, null);
            irCallWithIndexedArgumentsBase = object;
            irGetValueImpl2 = irDeclarationReference;
        } else {
            irGetValueImpl2 = null;
        }
        irCallWithIndexedArgumentsBase.setDispatchReceiver(irGetValueImpl2);
        IrCallWithIndexedArgumentsBase irCallWithIndexedArgumentsBase2 = (IrCallWithIndexedArgumentsBase)call2;
        IrValueParameter irValueParameter3 = ((IrFunctionBase)wrapperIrFunction).getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            irValueParameter = irValueParameter3;
            object = irCallWithIndexedArgumentsBase2;
            IrValueParameter extensionReceiver2 = irValueParameter;
            irDeclarationReference = new IrGetValueImpl(-1, -1, extensionReceiver2.getSymbol(), null, 8, null);
            irCallWithIndexedArgumentsBase2 = object;
            irGetValueImpl = irDeclarationReference;
        } else {
            irGetValueImpl = null;
        }
        irCallWithIndexedArgumentsBase2.setExtensionReceiver(irGetValueImpl);
        int parametersCopied = 0;
        int defaultParametersCopied = 0;
        boolean $i$a$2$let = false;
        for (IrValueParameter valueParameter : (Iterable)target.getValueParameters()) {
            void i;
            ParameterDescriptor parameterDescriptor = valueParameter.getDescriptor();
            if (parameterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ValueParameterDescriptor");
            }
            if (ArgumentsUtilsKt.hasDefaultValue((ValueParameterDescriptor)parameterDescriptor)) {
                if (defaultParametersCopied < numDefaultParametersToExpect) {
                    ++defaultParametersCopied;
                    ((IrCallWithIndexedArgumentsBase)call2).putValueArgument((int)i, new IrGetValueImpl(-1, -1, ((IrFunctionBase)wrapperIrFunction).getValueParameters().get(parametersCopied++).getSymbol(), null, 8, null));
                } else {
                    ((IrCallWithIndexedArgumentsBase)call2).putValueArgument((int)i, null);
                }
            } else {
                ((IrCallWithIndexedArgumentsBase)call2).putValueArgument((int)i, new IrGetValueImpl(-1, -1, ((IrFunctionBase)wrapperIrFunction).getValueParameters().get(parametersCopied++).getSymbol(), null, 8, null));
            }
            ++i;
        }
        ((IrFunctionBase)wrapperIrFunction).setBody(new IrExpressionBodyImpl(-1, -1, call2));
        Iterable i = target.getAnnotations();
        Collection destination$iv = ((IrFunctionBase)wrapperIrFunction).getAnnotations();
        for (Object item$iv : $receiver$iv) {
            void it;
            IrCall irCall = (IrCall)item$iv;
            object = destination$iv;
            IrElement $receiver$iv2 = (IrElement)it;
            IrDeclarationParent initialParent$iv = null;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid($receiver$iv2, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents($receiver$iv2.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv, typeRemapper$iv), null), initialParent$iv);
            if (irElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
            }
            irDeclarationReference = (IrCall)irElement2;
            object.add(irDeclarationReference);
        }
        return (IrFunction)wrapperIrFunction;
    }

    private final IrFunctionSymbol generateWrapperSymbol(IrFunctionSymbol oldSymbol, int numDefaultParametersToExpect) {
        FunctionDescriptor functionDescriptor;
        FunctionDescriptor oldDescriptor = oldSymbol.getDescriptor();
        if (oldDescriptor instanceof ClassConstructorDescriptor) {
            functionDescriptor = this.copyWithModifiedParameters((ClassConstructorDescriptor)oldDescriptor, numDefaultParametersToExpect);
        } else {
            List<ValueParameterDescriptor> newParameters = this.generateNewValueParameters(oldDescriptor, numDefaultParametersToExpect);
            functionDescriptor = oldDescriptor.newCopyBuilder().setValueParameters(newParameters).setOriginal(null).setKind(CallableMemberDescriptor.Kind.SYNTHESIZED).build();
            if (functionDescriptor == null) {
                Intrinsics.throwNpe();
            }
        }
        FunctionDescriptor newDescriptor2 = functionDescriptor;
        return IrSymbolBaseKt.createFunctionSymbol(newDescriptor2);
    }

    private final ClassConstructorDescriptor copyWithModifiedParameters(@NotNull ClassConstructorDescriptor $receiver, int numDefaultParametersToExpect) {
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.createSynthesized($receiver.getContainingDeclaration(), $receiver.getAnnotations(), false, $receiver.getSource());
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptorImpl, (String)"ClassConstructorDescript\u2026         source\n        )");
        ClassConstructorDescriptorImpl result2 = classConstructorDescriptorImpl;
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getExtensionReceiverParameter();
        result2.initialize(receiverParameterDescriptor != null ? receiverParameterDescriptor.copy(result2) : null, $receiver.getDispatchReceiverParameter(), $receiver.getTypeParameters(), this.generateNewValueParameters($receiver, numDefaultParametersToExpect), $receiver.getReturnType(), $receiver.getModality(), $receiver.getVisibility());
        return result2;
    }

    private final List<ValueParameterDescriptor> generateNewValueParameters(FunctionDescriptor oldDescriptor, int numDefaultParametersToExpect) {
        int parametersCopied = 0;
        int defaultParametersCopied = 0;
        List result2 = new ArrayList();
        Iterator<ValueParameterDescriptor> iterator2 = oldDescriptor.getValueParameters().iterator();
        while (iterator2.hasNext()) {
            ValueParameterDescriptor oldValueParameter;
            ValueParameterDescriptor valueParameterDescriptor = oldValueParameter = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"oldValueParameter");
            if (ArgumentsUtilsKt.hasDefaultValue(valueParameterDescriptor) && defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                CallableDescriptor callableDescriptor = oldDescriptor;
                int n = parametersCopied++;
                Annotations annotations2 = oldValueParameter.getAnnotations();
                Name name = oldValueParameter.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"oldValueParameter.name");
                KotlinType kotlinType2 = oldValueParameter.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"oldValueParameter.type");
                KotlinType kotlinType3 = oldValueParameter.getVarargElementType();
                SourceElement sourceElement = oldValueParameter.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"oldValueParameter.source");
                result2.add(new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations2, name, kotlinType2, false, false, false, kotlinType3, sourceElement));
                continue;
            }
            if (ArgumentsUtilsKt.hasDefaultValue(oldValueParameter)) continue;
            CallableDescriptor callableDescriptor = oldDescriptor;
            Name name = oldValueParameter.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"oldValueParameter.name");
            result2.add(oldValueParameter.copy(callableDescriptor, name, parametersCopied++));
        }
        return result2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmOverloadsAnnotationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

