/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.TargetedAnnotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class AnnotationResolverImpl
extends AnnotationResolver {
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public AnnotationResolverImpl(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull StorageManager storageManager) {
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.storageManager = storageManager;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Override
    @NotNull
    public Annotations resolveAnnotationEntries(@NotNull LexicalScope scope, @NotNull List<KtAnnotationEntry> annotationEntryElements, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (annotationEntryElements.isEmpty()) {
            return Annotations.Companion.getEMPTY();
        }
        ArrayList<AnnotationDescriptor> standard = new ArrayList<AnnotationDescriptor>();
        ArrayList<AnnotationWithTarget> targeted = new ArrayList<AnnotationWithTarget>();
        for (KtAnnotationEntry entryElement : annotationEntryElements) {
            KtAnnotationUseSiteTarget target;
            AnnotationDescriptor descriptor2 = trace.get(BindingContext.ANNOTATION, entryElement);
            if (descriptor2 == null) {
                descriptor2 = new LazyAnnotationDescriptor(new LazyAnnotationsContextImpl(this, this.storageManager, trace, scope), entryElement);
            }
            if (shouldResolveArguments) {
                ForceResolveUtil.forceResolveAllContents(descriptor2);
            }
            if ((target = entryElement.getUseSiteTarget()) != null) {
                targeted.add(new AnnotationWithTarget(descriptor2, target.getAnnotationUseSiteTarget()));
                continue;
            }
            standard.add(descriptor2);
        }
        return new TargetedAnnotations(CollectionsKt.toList(standard), CollectionsKt.toList(targeted));
    }

    @Override
    @NotNull
    public KotlinType resolveAnnotationType(@NotNull LexicalScope scope, @NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace) {
        KtTypeReference typeReference = entryElement.getTypeReference();
        if (typeReference == null) {
            return ErrorUtils.createErrorType("No type reference: " + entryElement.getText());
        }
        KotlinType type2 = this.typeResolver.resolveType(scope, typeReference, trace, true);
        if (!(type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return ErrorUtils.createErrorType("Not an annotation: " + type2);
        }
        return type2;
    }

    public static void checkAnnotationType(@NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace, @NotNull OverloadResolutionResults<FunctionDescriptor> results) {
        if (!results.isSingleResult()) {
            return;
        }
        FunctionDescriptor descriptor2 = results.getResultingDescriptor();
        if (!ErrorUtils.isError(descriptor2)) {
            if (descriptor2 instanceof ConstructorDescriptor) {
                ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor2;
                ClassDescriptor classDescriptor2 = constructor.getConstructedClass();
                if (classDescriptor2.getKind() != ClassKind.ANNOTATION_CLASS) {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor2));
                }
            } else {
                trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor2));
            }
        }
    }

    @Override
    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(@NotNull KtAnnotationEntry annotationEntry, @NotNull LexicalScope scope, @NotNull BindingTrace trace) {
        if (PsiTreeUtil.getParentOfType((PsiElement)annotationEntry, KtAnnotationEntry.class) != null) {
            trace.report(Errors.ANNOTATION_USED_AS_ANNOTATION_ARGUMENT.on(annotationEntry));
        }
        return this.callResolver.resolveFunctionCall(trace, scope, CallMaker.makeCall(null, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfoFactory.EMPTY, true);
    }

    public static void reportUnsupportedAnnotationForTypeParameter(@NotNull KtTypeParameter jetTypeParameter, @NotNull BindingTrace trace) {
        KtModifierList modifierList = jetTypeParameter.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            trace.report(Errors.UNSUPPORTED.on((PsiElement)annotationEntry, "Annotations for type parameters are not supported yet"));
        }
    }

    @Override
    @Nullable
    public ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument resolvedArgument) {
        return this.constantExpressionEvaluator.getAnnotationArgumentValue(trace, valueParameter, resolvedArgument);
    }
}

