/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a \u0010\u0015\u001a\u00020\u0016*\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011*\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u0003*\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\u0001*\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006!"}, d2={"ARGFILE_ARGUMENT", "", "BACKSLASH", "", "DOUBLE_QUOTE", "EXPERIMENTAL_ARGFILE_ARGUMENT", "SINGLE_QUOTE", "argfilePath", "getArgfilePath", "(Ljava/lang/String;)Ljava/lang/String;", "deprecatedArgfilePath", "getDeprecatedArgfilePath", "isArgfileArgument", "", "(Ljava/lang/String;)Z", "isDeprecatedArgfileArgument", "preprocessCommandLineArguments", "", "args", "errors", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "consumeRestOfEscapedSequence", "", "Ljava/io/Reader;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "quote", "expand", "Ljava/io/File;", "nextChar", "(Ljava/io/Reader;)Ljava/lang/Character;", "parseNextArgument", "cli-common"})
public final class PreprocessCommandLineArgumentsKt {
    @NotNull
    public static final String ARGFILE_ARGUMENT = "@";
    private static final String EXPERIMENTAL_ARGFILE_ARGUMENT = "-Xargfile=";
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char BACKSLASH = '\\';

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> preprocessCommandLineArguments(@NotNull List<String> args, @NotNull ArgumentParseErrors errors) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)errors, (String)"errors");
        Iterable iterable = $receiver$iv = (Iterable)args;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List<String> list2;
            String arg = (String)element$iv$iv;
            if (PreprocessCommandLineArgumentsKt.isArgfileArgument(arg)) {
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getArgfilePath(arg)), errors);
            } else if (PreprocessCommandLineArgumentsKt.isDeprecatedArgfileArgument(arg)) {
                Map<String, String> map2 = errors.getDeprecatedArguments();
                String string = EXPERIMENTAL_ARGFILE_ARGUMENT;
                String string2 = ARGFILE_ARGUMENT;
                map2.put(string, string2);
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getDeprecatedArgfilePath(arg)), errors);
            } else {
                list2 = CollectionsKt.listOf((Object)arg);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> expand(@NotNull File $receiver, ArgumentParseErrors errors) {
        Object object;
        try {
            List list2;
            Object object2;
            object = $receiver;
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            Object object4 = object2 = object;
            object4 = new FileInputStream((File)object4);
            object2 = new InputStreamReader((InputStream)object4, (Charset)object3);
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            object3 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                list2 = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(it){
                    final /* synthetic */ BufferedReader $it;

                    @Nullable
                    public final String invoke() {
                        return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$it);
                    }
                    {
                        this.$it = bufferedReader;
                        super(0);
                    }
                })));
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
            }
            object = list2;
        }
        catch (FileNotFoundException e) {
            Collection collection = errors.getArgfileErrors();
            String string = "Argfile not found: " + $receiver.getAbsolutePath();
            collection.add(string);
            object = CollectionsKt.emptyList();
        }
        catch (IOException e) {
            Collection collection = errors.getArgfileErrors();
            String string = "Error while reading argfile: " + e;
            collection.add(string);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final String parseNextArgument(@NotNull Reader $receiver) {
        String it;
        CharSequence charSequence;
        Object object;
        StringBuilder sb = new StringBuilder();
        Character r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        while (r != null && CharsKt.isWhitespace((char)r.charValue())) {
            r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
        while (r != null && !CharsKt.isWhitespace((char)r.charValue())) {
            char c;
            block10: {
                block9: {
                    object = r;
                    c = '\"';
                    if (((Character)object).charValue() == c) break block9;
                    c = '\'';
                    if (((Character)object).charValue() != c) break block10;
                }
                PreprocessCommandLineArgumentsKt.consumeRestOfEscapedSequence($receiver, sb, r.charValue());
                return sb.toString();
            }
            c = '\\';
            if (((Character)object).charValue() == c) {
                if (PreprocessCommandLineArgumentsKt.nextChar($receiver) != null) {
                    Character c2;
                    charSequence = sb;
                    char p1 = c2.charValue();
                    ((StringBuilder)charSequence).append(p1);
                }
            } else {
                sb.append(r.charValue());
            }
            r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
        object = sb.toString();
        String string = it = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
        charSequence = string;
        return charSequence.length() > 0 ? object : null;
    }

    private static final void consumeRestOfEscapedSequence(@NotNull Reader $receiver, StringBuilder sb, char quote) {
        Character ch = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        while (ch != null && ch.charValue() != quote) {
            char c = '\\';
            if (ch.charValue() == c) {
                if (PreprocessCommandLineArgumentsKt.nextChar($receiver) != null) {
                    Character c2;
                    StringBuilder stringBuilder = sb;
                    char p1 = c2.charValue();
                    stringBuilder.append(p1);
                }
            } else {
                sb.append(ch.charValue());
            }
            ch = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
    }

    private static final Character nextChar(@NotNull Reader $receiver) {
        Integer n = $receiver.read();
        int it = ((Number)n).intValue();
        Integer n2 = !(it == -1) ? n : null;
        return n2 != null ? Character.valueOf((char)n2.intValue()) : null;
    }

    private static final String getArgfilePath(@NotNull String $receiver) {
        return StringsKt.removePrefix((String)$receiver, (CharSequence)ARGFILE_ARGUMENT);
    }

    private static final boolean isArgfileArgument(@NotNull String $receiver) {
        return StringsKt.startsWith$default((String)$receiver, (String)ARGFILE_ARGUMENT, (boolean)false, (int)2, null);
    }

    private static final String getDeprecatedArgfilePath(@NotNull String $receiver) {
        return StringsKt.removePrefix((String)$receiver, (CharSequence)EXPERIMENTAL_ARGFILE_ARGUMENT);
    }

    private static final boolean isDeprecatedArgfileArgument(@NotNull String $receiver) {
        return StringsKt.startsWith$default((String)$receiver, (String)EXPERIMENTAL_ARGFILE_ARGUMENT, (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ String access$parseNextArgument(Reader $receiver) {
        return PreprocessCommandLineArgumentsKt.parseNextArgument($receiver);
    }
}

