/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ForLoopConventionsChecker {
    private final KotlinBuiltIns builtIns;
    private final FakeCallResolver fakeCallResolver;

    public ForLoopConventionsChecker(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver) {
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
    }

    @Nullable
    public KotlinType checkIterableConvention(@NotNull ExpressionReceiver loopRange, @NotNull ExpressionTypingContext context) {
        KtExpression loopRangeExpression = loopRange.getExpression();
        OverloadResolutionResults<FunctionDescriptor> iteratorResolutionResults = this.fakeCallResolver.resolveFakeCall(context, loopRange, OperatorNameConventions.ITERATOR, loopRangeExpression, loopRangeExpression, FakeCallKind.ITERATOR, Collections.emptyList());
        if (!iteratorResolutionResults.isSuccess()) {
            return null;
        }
        ResolvedCall<FunctionDescriptor> iteratorResolvedCall = iteratorResolutionResults.getResultingCall();
        context.trace.record(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRangeExpression, iteratorResolvedCall);
        FunctionDescriptor iteratorFunction = iteratorResolvedCall.getResultingDescriptor();
        ForLoopConventionsChecker.checkIfOperatorModifierPresent(loopRangeExpression, iteratorFunction, context.trace);
        KotlinType iteratorType = iteratorFunction.getReturnType();
        KotlinType hasNextType = this.checkConventionForIterator(context, loopRangeExpression, iteratorType, OperatorNameConventions.HAS_NEXT, Errors.HAS_NEXT_FUNCTION_AMBIGUITY, Errors.HAS_NEXT_MISSING, Errors.HAS_NEXT_FUNCTION_NONE_APPLICABLE, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
        if (hasNextType != null && !this.builtIns.isBooleanOrSubtype(hasNextType)) {
            context.trace.report(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH.on(loopRangeExpression, hasNextType));
        }
        return this.checkConventionForIterator(context, loopRangeExpression, iteratorType, OperatorNameConventions.NEXT, Errors.NEXT_AMBIGUITY, Errors.NEXT_MISSING, Errors.NEXT_NONE_APPLICABLE, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
    }

    private static void checkIfOperatorModifierPresent(KtExpression expression2, FunctionDescriptor descriptor2, DiagnosticSink sink) {
        if (ErrorUtils.isError(descriptor2)) {
            return;
        }
        ReceiverParameterDescriptor extensionReceiverParameter2 = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiverParameter2 != null && DynamicTypesKt.isDynamic(extensionReceiverParameter2.getType())) {
            return;
        }
        if (!descriptor2.isOperator()) {
            OperatorCallChecker.Companion.report((PsiElement)expression2, descriptor2, sink);
        }
    }

    @Nullable
    private KotlinType checkConventionForIterator(@NotNull ExpressionTypingContext context, @NotNull KtExpression loopRangeExpression, @NotNull KotlinType iteratorType, @NotNull Name name, @NotNull DiagnosticFactory1<KtExpression, KotlinType> ambiguity, @NotNull DiagnosticFactory1<KtExpression, KotlinType> missing, @NotNull DiagnosticFactory1<KtExpression, KotlinType> noneApplicable, @NotNull WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> resolvedCallKey) {
        OverloadResolutionResults<FunctionDescriptor> nextResolutionResults = this.fakeCallResolver.resolveFakeCall(context, new TransientReceiver(iteratorType), name, loopRangeExpression, loopRangeExpression, FakeCallKind.OTHER, Collections.emptyList());
        if (nextResolutionResults.isAmbiguity()) {
            context.trace.report(ambiguity.on(loopRangeExpression, iteratorType));
        } else if (nextResolutionResults.isNothing()) {
            context.trace.report(missing.on(loopRangeExpression, iteratorType));
        } else if (!nextResolutionResults.isSuccess()) {
            context.trace.report(noneApplicable.on(loopRangeExpression, iteratorType));
        } else {
            assert (nextResolutionResults.isSuccess());
            ResolvedCall<FunctionDescriptor> resolvedCall2 = nextResolutionResults.getResultingCall();
            context.trace.record(resolvedCallKey, loopRangeExpression, resolvedCall2);
            FunctionDescriptor functionDescriptor = resolvedCall2.getResultingDescriptor();
            ForLoopConventionsChecker.checkIfOperatorModifierPresent(loopRangeExpression, functionDescriptor, context.trace);
            return functionDescriptor.getReturnType();
        }
        return null;
    }
}

