/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.InternalArgument;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.utils.StringsKt;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonToolArguments arguments2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> result2 = new ArrayList<String>();
        Class<?> argumentsClass = arguments2.getClass();
        ArgumentUtils.convertArgumentsToStringList(arguments2, (CommonToolArguments)argumentsClass.newInstance(), JvmClassMappingKt.getKotlinClass(argumentsClass), result2);
        result2.addAll(arguments2.getFreeArgs());
        result2.addAll(CollectionsKt.map(arguments2.getInternalArguments(), InternalArgument::getStringRepresentation));
        return result2;
    }

    private static void convertArgumentsToStringList(@NotNull CommonToolArguments arguments2, @NotNull CommonToolArguments defaultArguments, @NotNull KClass<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        for (KProperty1 property : KClasses.getMemberProperties(clazz)) {
            Argument argument = (Argument)ContainerUtil.findInstance((Iterable)property.getAnnotations(), Argument.class);
            if (argument == null || property.getVisibility() != KVisibility.PUBLIC) continue;
            Object value = property.get((Object)arguments2);
            Object defaultValue = property.get((Object)defaultArguments);
            if (value == null || Objects.equals(value, defaultValue)) continue;
            Type propertyJavaType = ReflectJvmMapping.getJavaType((KType)property.getReturnType());
            if (propertyJavaType instanceof Class && ((Class)propertyJavaType).isArray()) {
                Object[] values = (Object[])value;
                if (values.length == 0) continue;
                value = StringsKt.join(Arrays.asList(values), ",");
            }
            result2.add(argument.value());
            if (propertyJavaType == Boolean.TYPE || propertyJavaType == Boolean.class) continue;
            if (ParseCommandLineArgumentsKt.isAdvanced(argument)) {
                result2.set(result2.size() - 1, argument.value() + "=" + value.toString());
                continue;
            }
            result2.add(value.toString());
        }
    }
}

