/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParser;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.K2JSTranslator;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private static final Map<String, ModuleKind> moduleKindMap = new HashMap<String, ModuleKind>();
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap = new LinkedHashMap<String, SourceMapSourceEmbedding>();
    private final K2JSCompilerPerformanceManager performanceManager = new K2JSCompilerPerformanceManager();

    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    @NotNull
    private static TranslationResult translate(@NotNull JsConfig.Reporter reporter, @NotNull List<KtFile> allKotlinFiles2, @NotNull JsAnalysisResult jsAnalysisResult, @NotNull MainCallParameters mainCallParameters, @NotNull JsConfig config) throws TranslationException {
        if (reporter == null) {
            K2JSCompiler.$$$reportNull$$$2(0);
        }
        if (allKotlinFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$2(1);
        }
        if (jsAnalysisResult == null) {
            K2JSCompiler.$$$reportNull$$$2(2);
        }
        if (mainCallParameters == null) {
            K2JSCompiler.$$$reportNull$$$2(3);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$2(4);
        }
        if (reporter == null) {
            K2JSCompiler.$$$reportNull$$$1(0);
        }
        if (allKotlinFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$1(1);
        }
        if (jsAnalysisResult == null) {
            K2JSCompiler.$$$reportNull$$$1(2);
        }
        if (mainCallParameters == null) {
            K2JSCompiler.$$$reportNull$$$1(3);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$1(4);
        }
        if (reporter == null) {
            K2JSCompiler.$$$reportNull$$$0(0);
        }
        if (allKotlinFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(1);
        }
        if (jsAnalysisResult == null) {
            K2JSCompiler.$$$reportNull$$$0(2);
        }
        if (mainCallParameters == null) {
            K2JSCompiler.$$$reportNull$$$0(3);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$0(4);
        }
        K2JSTranslator translator = new K2JSTranslator(config);
        IncrementalDataProvider incrementalDataProvider = config.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider != null) {
            HashMap<File, KtFile> nonCompiledSources = new HashMap<File, KtFile>(allKotlinFiles2.size());
            for (KtFile ktFile2 : allKotlinFiles2) {
                nonCompiledSources.put(VfsUtilCore.virtualToIoFile((VirtualFile)ktFile2.getVirtualFile()), ktFile2);
            }
            Map<File, TranslationResultValue> compiledParts = incrementalDataProvider.getCompiledPackageParts();
            Object[] allSources = new File[compiledParts.size() + allKotlinFiles2.size()];
            int i = 0;
            for (File file2 : compiledParts.keySet()) {
                allSources[i++] = file2;
            }
            for (File file2 : nonCompiledSources.keySet()) {
                allSources[i++] = file2;
            }
            Arrays.sort(allSources);
            ArrayList<TranslationUnit> translationUnits = new ArrayList<TranslationUnit>();
            for (i = 0; i < allSources.length; ++i) {
                KtFile nonCompiled = (KtFile)nonCompiledSources.get(allSources[i]);
                if (nonCompiled != null) {
                    translationUnits.add(new TranslationUnit.SourceFile(nonCompiled));
                    continue;
                }
                TranslationResultValue translatedValue = compiledParts.get(allSources[i]);
                translationUnits.add(new TranslationUnit.BinaryAst(translatedValue.getBinaryAst(), translatedValue.getInlineData()));
            }
            TranslationResult translationResult = translator.translateUnits(reporter, translationUnits, mainCallParameters, jsAnalysisResult);
            if (translationResult == null) {
                K2JSCompiler.$$$reportNull$$$0(5);
            }
            if (translationResult == null) {
                K2JSCompiler.$$$reportNull$$$1(5);
            }
            if (translationResult == null) {
                K2JSCompiler.$$$reportNull$$$2(5);
            }
            return translationResult;
        }
        CollectionsKt.sortBy(allKotlinFiles2, ktFile -> VfsUtilCore.virtualToIoFile((VirtualFile)ktFile.getVirtualFile()));
        TranslationResult translationResult = translator.translate(reporter, allKotlinFiles2, mainCallParameters, jsAnalysisResult);
        if (translationResult == null) {
            K2JSCompiler.$$$reportNull$$$0(6);
        }
        if (translationResult == null) {
            K2JSCompiler.$$$reportNull$$$1(6);
        }
        if (translationResult == null) {
            K2JSCompiler.$$$reportNull$$$2(6);
        }
        return translationResult;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        TranslationResult translationResult;
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$2(7);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$2(8);
        }
        if (rootDisposable == null) {
            K2JSCompiler.$$$reportNull$$$2(9);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$1(7);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$1(8);
        }
        if (rootDisposable == null) {
            K2JSCompiler.$$$reportNull$$$1(9);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(8);
        }
        if (rootDisposable == null) {
            K2JSCompiler.$$$reportNull$$$0(9);
        }
        final MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                ExitCode exitCode2 = ExitCode.OK;
                if (exitCode2 == null) {
                    K2JSCompiler.$$$reportNull$$$0(10);
                }
                if (exitCode2 == null) {
                    K2JSCompiler.$$$reportNull$$$1(10);
                }
                if (exitCode2 == null) {
                    K2JSCompiler.$$$reportNull$$$2(10);
                }
                return exitCode2;
            }
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
            ExitCode exitCode3 = ExitCode.COMPILATION_ERROR;
            if (exitCode3 == null) {
                K2JSCompiler.$$$reportNull$$$0(11);
            }
            if (exitCode3 == null) {
                K2JSCompiler.$$$reportNull$$$1(11);
            }
            if (exitCode3 == null) {
                K2JSCompiler.$$$reportNull$$$2(11);
            }
            return exitCode3;
        }
        ExitCode pluginLoadResult = PluginCliParser.loadPluginsSafe(arguments2.getPluginClasspaths(), arguments2.getPluginOptions(), configuration);
        if (pluginLoadResult != ExitCode.OK) {
            ExitCode exitCode4 = pluginLoadResult;
            if (exitCode4 == null) {
                K2JSCompiler.$$$reportNull$$$0(12);
            }
            if (exitCode4 == null) {
                K2JSCompiler.$$$reportNull$$$1(12);
            }
            if (exitCode4 == null) {
                K2JSCompiler.$$$reportNull$$$2(12);
            }
            return exitCode4;
        }
        configuration.put(JSConfigurationKeys.LIBRARIES, K2JSCompiler.configureLibraries(arguments2, paths, messageCollector2));
        Object[] commonSourcesArray = arguments2.getCommonSources();
        Set commonSources = commonSourcesArray == null ? Collections.emptySet() : SetsKt.setOf((Object[])commonSourcesArray);
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        environmentForJS.getConfiguration().put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, sourcesFiles)) {
            ExitCode exitCode5 = ExitCode.COMPILATION_ERROR;
            if (exitCode5 == null) {
                K2JSCompiler.$$$reportNull$$$0(13);
            }
            if (exitCode5 == null) {
                K2JSCompiler.$$$reportNull$$$1(13);
            }
            if (exitCode5 == null) {
                K2JSCompiler.$$$reportNull$$$2(13);
            }
            return exitCode5;
        }
        if (arguments2.getOutputFile() == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", null);
            ExitCode exitCode6 = ExitCode.COMPILATION_ERROR;
            if (exitCode6 == null) {
                K2JSCompiler.$$$reportNull$$$0(14);
            }
            if (exitCode6 == null) {
                K2JSCompiler.$$$reportNull$$$1(14);
            }
            if (exitCode6 == null) {
                K2JSCompiler.$$$reportNull$$$2(14);
            }
            return exitCode6;
        }
        if (messageCollector2.hasErrors()) {
            ExitCode exitCode7 = ExitCode.COMPILATION_ERROR;
            if (exitCode7 == null) {
                K2JSCompiler.$$$reportNull$$$0(15);
            }
            if (exitCode7 == null) {
                K2JSCompiler.$$$reportNull$$$1(15);
            }
            if (exitCode7 == null) {
                K2JSCompiler.$$$reportNull$$$2(15);
            }
            return exitCode7;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
            ExitCode exitCode8 = ExitCode.COMPILATION_ERROR;
            if (exitCode8 == null) {
                K2JSCompiler.$$$reportNull$$$0(16);
            }
            if (exitCode8 == null) {
                K2JSCompiler.$$$reportNull$$$1(16);
            }
            if (exitCode8 == null) {
                K2JSCompiler.$$$reportNull$$$2(16);
            }
            return exitCode8;
        }
        if (arguments2.getVerbose()) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(arguments2.getOutputFile());
        configuration.put(CommonConfigurationKeys.MODULE_NAME, FileUtil.getNameWithoutExtension((File)outputFile));
        JsConfig config = new JsConfig(project, configuration);
        JsConfig.Reporter reporter = new JsConfig.Reporter(){

            @Override
            public void error(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$2(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$1(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            }

            @Override
            public void warning(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$2(1);
                }
                if (message == null) {
                    1.$$$reportNull$$$1(1);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, message, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warning";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warning";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$2(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warning";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (config.checkLibFilesAndReportErrors(reporter)) {
            ExitCode exitCode9 = ExitCode.COMPILATION_ERROR;
            if (exitCode9 == null) {
                K2JSCompiler.$$$reportNull$$$0(17);
            }
            if (exitCode9 == null) {
                K2JSCompiler.$$$reportNull$$$1(17);
            }
            if (exitCode9 == null) {
                K2JSCompiler.$$$reportNull$$$2(17);
            }
            return exitCode9;
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector2, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration));
        analyzerWithCompilerReport.analyzeAndReport(sourcesFiles, (Function0<? extends AnalysisResult>)((Function0)() -> TopDownAnalyzerFacadeForJS.analyzeFiles(sourcesFiles, config)));
        if (analyzerWithCompilerReport.hasErrors()) {
            ExitCode exitCode10 = ExitCode.COMPILATION_ERROR;
            if (exitCode10 == null) {
                K2JSCompiler.$$$reportNull$$$0(18);
            }
            if (exitCode10 == null) {
                K2JSCompiler.$$$reportNull$$$1(18);
            }
            if (exitCode10 == null) {
                K2JSCompiler.$$$reportNull$$$2(18);
            }
            return exitCode10;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalysisResult analysisResult2 = analyzerWithCompilerReport.getAnalysisResult();
        assert (analysisResult2 instanceof JsAnalysisResult) : "analysisResult should be instance of JsAnalysisResult, but " + analysisResult2;
        JsAnalysisResult jsAnalysisResult = (JsAnalysisResult)analysisResult2;
        File outputPrefixFile = null;
        if (arguments2.getOutputPrefix() != null && !(outputPrefixFile = new File(arguments2.getOutputPrefix())).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.getOutputPrefix() + "' not found", null);
            ExitCode exitCode11 = ExitCode.COMPILATION_ERROR;
            if (exitCode11 == null) {
                K2JSCompiler.$$$reportNull$$$0(19);
            }
            if (exitCode11 == null) {
                K2JSCompiler.$$$reportNull$$$1(19);
            }
            if (exitCode11 == null) {
                K2JSCompiler.$$$reportNull$$$2(19);
            }
            return exitCode11;
        }
        File outputPostfixFile = null;
        if (arguments2.getOutputPostfix() != null && !(outputPostfixFile = new File(arguments2.getOutputPostfix())).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.getOutputPostfix() + "' not found", null);
            ExitCode exitCode12 = ExitCode.COMPILATION_ERROR;
            if (exitCode12 == null) {
                K2JSCompiler.$$$reportNull$$$0(20);
            }
            if (exitCode12 == null) {
                K2JSCompiler.$$$reportNull$$$1(20);
            }
            if (exitCode12 == null) {
                K2JSCompiler.$$$reportNull$$$2(20);
            }
            return exitCode12;
        }
        File outputDir2 = outputFile.getParentFile();
        if (outputDir2 == null) {
            outputDir2 = outputFile.getAbsoluteFile().getParentFile();
        }
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            ExitCode exitCode13 = ExitCode.COMPILATION_ERROR;
            if (exitCode13 == null) {
                K2JSCompiler.$$$reportNull$$$0(21);
            }
            if (exitCode13 == null) {
                K2JSCompiler.$$$reportNull$$$1(21);
            }
            if (exitCode13 == null) {
                K2JSCompiler.$$$reportNull$$$2(21);
            }
            return exitCode13;
        }
        if (config.getConfiguration().getBoolean(JSConfigurationKeys.SOURCE_MAP)) {
            K2JSCompiler.checkDuplicateSourceFileNames(messageCollector2, sourcesFiles, config);
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.getMain());
        try {
            translationResult = K2JSCompiler.translate(reporter, sourcesFiles, jsAnalysisResult, mainCallParameters, config);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(translationResult.getDiagnostics(), messageCollector2);
        if (!(translationResult instanceof TranslationResult.Success)) {
            ExitCode exitCode14 = ExitCode.COMPILATION_ERROR;
            if (exitCode14 == null) {
                K2JSCompiler.$$$reportNull$$$0(22);
            }
            if (exitCode14 == null) {
                K2JSCompiler.$$$reportNull$$$1(22);
            }
            if (exitCode14 == null) {
                K2JSCompiler.$$$reportNull$$$2(22);
            }
            return exitCode14;
        }
        TranslationResult.Success successResult = (TranslationResult.Success)translationResult;
        OutputFileCollection outputFiles = successResult.getOutputFiles(outputFile, outputPrefixFile, outputPostfixFile);
        if (outputFile.isDirectory()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Cannot open output file '" + outputFile.getPath() + "': is a directory", null);
            ExitCode exitCode15 = ExitCode.COMPILATION_ERROR;
            if (exitCode15 == null) {
                K2JSCompiler.$$$reportNull$$$0(23);
            }
            if (exitCode15 == null) {
                K2JSCompiler.$$$reportNull$$$1(23);
            }
            if (exitCode15 == null) {
                K2JSCompiler.$$$reportNull$$$2(23);
            }
            return exitCode15;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        OutputUtilsKt.writeAll(outputFiles, outputDir2, messageCollector2, configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES));
        ExitCode exitCode16 = ExitCode.OK;
        if (exitCode16 == null) {
            K2JSCompiler.$$$reportNull$$$0(24);
        }
        if (exitCode16 == null) {
            K2JSCompiler.$$$reportNull$$$1(24);
        }
        if (exitCode16 == null) {
            K2JSCompiler.$$$reportNull$$$2(24);
        }
        return exitCode16;
    }

    private static void checkDuplicateSourceFileNames(@NotNull MessageCollector log2, @NotNull List<KtFile> sourceFiles2, @NotNull JsConfig config) {
        if (log2 == null) {
            K2JSCompiler.$$$reportNull$$$2(25);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$2(26);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$2(27);
        }
        if (log2 == null) {
            K2JSCompiler.$$$reportNull$$$1(25);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$1(26);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$1(27);
        }
        if (log2 == null) {
            K2JSCompiler.$$$reportNull$$$0(25);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(26);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$0(27);
        }
        if (config.getSourceMapRoots().isEmpty()) {
            return;
        }
        SourceFilePathResolver pathResolver = SourceFilePathResolver.create(config);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        HashSet<String> duplicatePaths = new HashSet<String>();
        try {
            for (KtFile sourceFile : sourceFiles2) {
                String path2 = sourceFile.getVirtualFile().getPath();
                String relativePath = pathResolver.getPathRelativeToSourceRoots(new File(sourceFile.getVirtualFile().getPath()));
                String existingPath = (String)pathMap.get(relativePath);
                if (existingPath != null) {
                    if (!duplicatePaths.add(relativePath)) continue;
                    log2.report(CompilerMessageSeverity.WARNING, "There are files with same path '" + relativePath + "', relative to source roots: '" + path2 + "' and '" + existingPath + "'. This will likely cause problems with debugger", null);
                    continue;
                }
                pathMap.put(relativePath, path2);
            }
        }
        catch (IOException e) {
            log2.report(CompilerMessageSeverity.ERROR, "IO error occurred validating source path:\n" + ExceptionUtil.getThrowableText((Throwable)e), null);
        }
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector2, @NotNull List<KtFile> sourceFiles2) {
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$2(28);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$2(29);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$1(28);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$1(29);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(28);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(29);
        }
        List fileNames = CollectionsKt.map(sourceFiles2, file2 -> {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            if (virtualFile2 != null) {
                return MessageUtil.virtualFileToPath(virtualFile2);
            }
            return file2.getName() + " (no virtual file)";
        });
        messageCollector2.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ExpectActualTracker expectActualTracker;
        LookupTracker lookupTracker;
        IncrementalResultsConsumer incrementalResultsConsumer;
        String moduleKindName;
        ModuleKind moduleKind;
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$2(30);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$2(31);
        }
        if (services == null) {
            K2JSCompiler.$$$reportNull$$$2(32);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$1(30);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$1(31);
        }
        if (services == null) {
            K2JSCompiler.$$$reportNull$$$1(32);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(30);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(31);
        }
        if (services == null) {
            K2JSCompiler.$$$reportNull$$$0(32);
        }
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getTarget() != null) assert ("v5".equals(arguments2.getTarget())) : "Unsupported ECMA version: " + arguments2.getTarget();
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                configuration.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, arguments2.getSourceMapPrefix());
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty((String)arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                List sourceMapSourceRootList = StringUtil.split((String)sourceMapSourceRoots, (String)File.pathSeparator);
                configuration.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        if (!arguments2.getFriendModulesDisabled() && arguments2.getFriendModules() != null) {
            List friendPaths = ArraysKt.filterNot((Object[])arguments2.getFriendModules().split(File.pathSeparator), String::isEmpty);
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        IncrementalDataProvider incrementalDataProvider = services.get(IncrementalDataProvider.class);
        if (incrementalDataProvider != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, incrementalDataProvider);
        }
        if ((incrementalResultsConsumer = services.get(IncrementalResultsConsumer.class)) != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, incrementalResultsConsumer);
        }
        if ((lookupTracker = services.get(LookupTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, lookupTracker);
        }
        if ((expectActualTracker = services.get(ExpectActualTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, expectActualTracker);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join(sourceMapContentEmbeddingMap.keySet(), (String)", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
    }

    @NotNull
    private static List<String> configureLibraries(@NotNull K2JSCompilerArguments arguments2, @Nullable KotlinPaths paths, @NotNull MessageCollector messageCollector2) {
        File stdlibJar;
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$2(33);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$2(34);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$1(33);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$1(34);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(33);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(34);
        }
        SmartList libraries = new SmartList();
        if (!arguments2.getNoStdlib() && (stdlibJar = UtilsKt.getLibraryFromHome(paths, (Function1<? super KotlinPaths, ? extends File>)((Function1)KotlinPaths::getJsStdLibJarPath), "kotlin-stdlib-js.jar", messageCollector2, "'-no-stdlib'")) != null) {
            libraries.add(stdlibJar.getAbsolutePath());
        }
        if (arguments2.getLibraries() != null) {
            libraries.addAll(ArraysKt.filterNot((Object[])arguments2.getLibraries().split(File.pathSeparator), String::isEmpty));
        }
        SmartList smartList = libraries;
        if (smartList == null) {
            K2JSCompiler.$$$reportNull$$$0(35);
        }
        if (smartList == null) {
            K2JSCompiler.$$$reportNull$$$1(35);
        }
        if (smartList == null) {
            K2JSCompiler.$$$reportNull$$$2(35);
        }
        return smartList;
    }

    @NotNull
    private static String calculateSourceMapSourceRoot(@NotNull MessageCollector messageCollector2, @NotNull K2JSCompilerArguments arguments2) {
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$2(36);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$2(37);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$1(36);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$1(37);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(36);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(37);
        }
        File commonPath = null;
        ArrayList<File> pathToRoot = new ArrayList<File>();
        HashMap pathToRootIndexes = new HashMap();
        try {
            for (String path2 : arguments2.getFreeArgs()) {
                File file2;
                if (commonPath == null) {
                    commonPath = file2;
                    for (file2 = new File(path2).getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                        pathToRoot.add(file2);
                    }
                    Collections.reverse(pathToRoot);
                    for (int i = 0; i < pathToRoot.size(); ++i) {
                        pathToRootIndexes.put(pathToRoot.get(i), i);
                    }
                    continue;
                }
                while (file2 != null) {
                    Integer existingIndex = (Integer)pathToRootIndexes.get(file2);
                    if (existingIndex != null) {
                        existingIndex = Math.min(existingIndex, pathToRoot.size() - 1);
                        pathToRoot.subList(existingIndex + 1, pathToRoot.size()).clear();
                        commonPath = (File)pathToRoot.get(pathToRoot.size() - 1);
                        break;
                    }
                    file2 = file2.getParentFile();
                }
                if (file2 != null) continue;
                break;
            }
        }
        catch (IOException e) {
            String text2 = ExceptionUtil.getThrowableText((Throwable)e);
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IO error occurred calculating source root:\n" + text2, null);
            return ".";
        }
        return commonPath != null ? commonPath.getPath() : ".";
    }

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        K2JSCompilerPerformanceManager k2JSCompilerPerformanceManager = this.performanceManager;
        if (k2JSCompilerPerformanceManager == null) {
            K2JSCompiler.$$$reportNull$$$0(38);
        }
        if (k2JSCompilerPerformanceManager == null) {
            K2JSCompiler.$$$reportNull$$$1(38);
        }
        if (k2JSCompilerPerformanceManager == null) {
            K2JSCompiler.$$$reportNull$$$2(38);
        }
        return k2JSCompilerPerformanceManager;
    }

    private static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-js";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        if (versionArray == null) {
            K2JSCompiler.$$$reportNull$$$2(39);
        }
        if (versionArray == null) {
            K2JSCompiler.$$$reportNull$$$1(39);
        }
        if (versionArray == null) {
            K2JSCompiler.$$$reportNull$$$0(39);
        }
        return new JsMetadataVersion(versionArray);
    }

    static {
        moduleKindMap.put("plain", ModuleKind.PLAIN);
        moduleKindMap.put("commonjs", ModuleKind.COMMON_JS);
        moduleKindMap.put("amd", ModuleKind.AMD);
        moduleKindMap.put("umd", ModuleKind.UMD);
        sourceMapContentEmbeddingMap.put("always", SourceMapSourceEmbedding.ALWAYS);
        sourceMapContentEmbeddingMap.put("never", SourceMapSourceEmbedding.NEVER);
        sourceMapContentEmbeddingMap.put("inlining", SourceMapSourceEmbedding.INLINING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allKotlinFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsAnalysisResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 7: 
            case 31: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 8: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDisposable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 28: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLibraries";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerformanceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateSourceFileNames";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reportCompiledSourcesList";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatformSpecificArgumentsAndServices";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "configureLibraries";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "calculateSourceMapSourceRoot";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createMetadataVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allKotlinFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsAnalysisResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 7: 
            case 31: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 8: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDisposable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 28: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLibraries";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerformanceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateSourceFileNames";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reportCompiledSourcesList";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatformSpecificArgumentsAndServices";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "configureLibraries";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "calculateSourceMapSourceRoot";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createMetadataVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allKotlinFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsAnalysisResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 7: 
            case 31: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 8: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDisposable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 28: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLibraries";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerformanceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateSourceFileNames";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reportCompiledSourcesList";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatformSpecificArgumentsAndServices";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "configureLibraries";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "calculateSourceMapSourceRoot";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createMetadataVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class K2JSCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2JSCompilerPerformanceManager() {
            super("Kotlin to JS Compiler");
        }
    }
}

