/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.BuildDiffsStorage;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.util.Either;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a8\u0006\r"}, d2={"getClasspathChanges", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "classpath", "", "Ljava/io/File;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "lastBuildInfo", "Lorg/jetbrains/kotlin/incremental/BuildInfo;", "modulesApiHistory", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "incremental-compilation-impl"})
public final class ChangesDetectionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ChangesEither getClasspathChanges(@NotNull List<? extends File> classpath2, @NotNull ChangedFiles.Known changedFiles, @NotNull BuildInfo lastBuildInfo2, @NotNull ModulesApiHistory modulesApiHistory2, @Nullable ICReporter reporter) {
        Collection $this$filterTo$iv;
        void $this$filterTo$iv2;
        boolean bl;
        File it;
        boolean $i$f$filterTo;
        Intrinsics.checkParameterIsNotNull(classpath2, (String)"classpath");
        Intrinsics.checkParameterIsNotNull((Object)changedFiles, (String)"changedFiles");
        Intrinsics.checkParameterIsNotNull((Object)lastBuildInfo2, (String)"lastBuildInfo");
        Intrinsics.checkParameterIsNotNull((Object)modulesApiHistory2, (String)"modulesApiHistory");
        HashSet<File> classpathSet = new HashSet<File>();
        for (File file2 : classpath2) {
            if (file2.isFile()) {
                classpathSet.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            Sequence $this$filterTo$iv22 = (Sequence)FilesKt.walk$default((File)file2, null, (int)1, null);
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv22) {
                it = (File)element$iv;
                bl = false;
                if (!it.isFile()) continue;
                ((Collection)classpathSet).add(element$iv);
            }
        }
        Iterable iterable = changedFiles.getModified();
        Iterable destination$iv = new HashSet();
        $i$f$filterTo = false;
        for (Object element$iv2 : $this$filterTo$iv2) {
            it = (File)element$iv2;
            bl = false;
            if (!classpathSet.contains(it)) continue;
            destination$iv.add(element$iv2);
        }
        HashSet hashSet = (HashSet)destination$iv;
        destination$iv = changedFiles.getRemoved();
        Collection destination$iv2 = new HashSet();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            File it2 = (File)element$iv3;
            boolean bl22 = false;
            if (!classpathSet.contains(it2)) continue;
            destination$iv2.add(element$iv3);
        }
        HashSet removedClasspath = (HashSet)destination$iv2;
        $this$filterTo$iv = removedClasspath;
        boolean bl2 = false;
        if (!$this$filterTo$iv.isEmpty()) {
            return new ChangesEither.Unknown("Some files are removed from classpath " + removedClasspath);
        }
        if (hashSet.isEmpty()) {
            return new ChangesEither.Known(null, null, 3, null);
        }
        long lastBuildTS = lastBuildInfo2.getStartTS();
        HashSet<LookupSymbol> symbols2 = new HashSet<LookupSymbol>();
        HashSet<FqName> fqNames = new HashSet<FqName>();
        Either<Set<File>> historyFilesEither = modulesApiHistory2.historyFilesForChangedFiles(hashSet);
        Either<Set<File>> bl22 = historyFilesEither;
        if (!(bl22 instanceof Either.Success)) {
            if (bl22 instanceof Either.Error) {
                return new ChangesEither.Unknown(((Either.Error)historyFilesEither).getReason());
            }
            throw new NoWhenBranchMatchedException();
        }
        Set historyFiles = (Set)((Either.Success)historyFilesEither).getValue();
        for (File historyFile : historyFiles) {
            void knownBuilds;
            List<BuildDifference> allBuilds;
            if (BuildDiffsStorage.Companion.readDiffsFromFile(historyFile, reporter) == null) {
                return new ChangesEither.Unknown("Could not read diffs from " + historyFile);
            }
            Iterable $this$partition$iv = allBuilds;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv4 : $this$partition$iv) {
                BuildDifference it3 = (BuildDifference)element$iv4;
                boolean bl3 = false;
                if (it3.getTs() <= lastBuildTS) {
                    first$iv.add(element$iv4);
                    continue;
                }
                second$iv.add(element$iv4);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list2 = (List)pair.component1();
            List newBuilds = (List)pair.component2();
            if (knownBuilds.isEmpty()) {
                return new ChangesEither.Unknown("No previously known builds for " + historyFile);
            }
            for (BuildDifference buildDiff : newBuilds) {
                if (!buildDiff.isIncremental()) {
                    return new ChangesEither.Unknown("Non-incremental build from dependency " + historyFile);
                }
                DirtyData dirtyData = buildDiff.getDirtyData();
                symbols2.addAll(dirtyData.getDirtyLookupSymbols());
                fqNames.addAll(dirtyData.getDirtyClassesFqNames());
            }
        }
        return new ChangesEither.Known((Collection<LookupSymbol>)symbols2, (Collection<FqName>)fqNames);
    }
}

