/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.lower.FieldAccessTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.FieldNameCollector;
import org.jetbrains.kotlin.backend.jvm.lower.FieldRenamer;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "isJvmField", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Z", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm"})
final class RenameFieldsLowering
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        FieldNameCollector collector2 = new FieldNameCollector();
        IrElementVisitorVoidKt.acceptVoid(irFile, collector2);
        boolean bl = false;
        Map newNames = new LinkedHashMap();
        Map<Pair<IrDeclarationParent, Name>, List<IrField>> map2 = collector2.getNameToField();
        boolean bl2 = false;
        Iterator<Map.Entry<Pair<IrDeclarationParent, Name>, List<IrField>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Pair<IrDeclarationParent, Name>, List<IrField>> entry;
            Map.Entry<Pair<IrDeclarationParent, Name>, List<IrField>> entry2 = entry = iterator2.next();
            boolean bl3 = false;
            List<IrField> fields2 = entry2.getValue();
            if (fields2.size() < 2) continue;
            int count2 = 0;
            Iterable $this$sortedBy$iv = fields2;
            boolean $i$f$sortedBy = false;
            Iterable iterable = $this$sortedBy$iv;
            boolean bl4 = false;
            Comparator comparator = new Comparator<T>(this){
                final /* synthetic */ RenameFieldsLowering this$0;
                {
                    this.this$0 = renameFieldsLowering;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    IrField it = (IrField)a;
                    boolean bl2 = false;
                    int n = RenameFieldsLowering.access$isJvmField$p(this.this$0, it) ? 0 : (it.isStatic() ? 1 : 2);
                    it = (IrField)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl2 = false;
                    Integer n2 = RenameFieldsLowering.access$isJvmField$p(this.this$0, it) ? 0 : (it.isStatic() ? 1 : 2);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
                }
            };
            for (IrField field : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator)) {
                Name name2;
                Name oldName = field.getName();
                if (count2 == 0) {
                    name2 = oldName;
                } else {
                    Name name3 = Name.identifier(oldName.asString() + '$' + count2);
                    name2 = name3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(oldName.asString() + \"$$count\")");
                }
                Name newName2 = name2;
                ++count2;
                if (this.isJvmField(field)) continue;
                newNames.put(field, newName2);
            }
        }
        FieldRenamer renamer = new FieldRenamer(newNames);
        irFile.transform(renamer, null);
        irFile.transform(new FieldAccessTransformer(renamer.getNewSymbols()), null);
    }

    private final boolean isJvmField(@NotNull IrField $this$isJvmField) {
        IrAnnotationContainer irAnnotationContainer = $this$isJvmField;
        FqName fqName2 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME");
        return IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public RenameFieldsLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }

    public static final /* synthetic */ boolean access$isJvmField$p(RenameFieldsLowering $this, IrField $this$access_u24isJvmField_u24p) {
        return $this.isJvmField($this$access_u24isJvmField_u24p);
    }
}

