/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticUtils {
    @NotNull
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() != o2.getStartOffset()) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
        return o1.getEndOffset() - o2.getEndOffset();
    };

    private DiagnosticUtils() {
    }

    public static String atLocation(DeclarationDescriptor descriptor2) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element == null) {
            element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2.getOriginal());
        }
        if (element == null && descriptor2 instanceof ASTNode) {
            element = PsiUtilsKt.closestPsiElement((ASTNode)descriptor2);
        }
        if (element != null) {
            return PsiDiagnosticUtils.atLocation(element);
        }
        return "unknown location";
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull ASTNode node) {
        if (node == null) {
            DiagnosticUtils.$$$reportNull$$$0(0);
        }
        PsiElement closestPsiElement = PsiUtilsKt.closestPsiElement(node);
        assert (closestPsiElement != null) : "This node is not contained by a file";
        PsiFile psiFile = closestPsiElement.getContainingFile();
        if (psiFile == null) {
            DiagnosticUtils.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumn getLineAndColumn(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            DiagnosticUtils.$$$reportNull$$$0(2);
        }
        PsiFile file2 = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        if (textRanges.isEmpty()) {
            PsiDiagnosticUtils.LineAndColumn lineAndColumn = PsiDiagnosticUtils.LineAndColumn.NONE;
            if (lineAndColumn == null) {
                DiagnosticUtils.$$$reportNull$$$0(3);
            }
            return lineAndColumn;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        return DiagnosticUtils.getLineAndColumnInPsiFile(file2, firstRange);
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumn getLineAndColumnInPsiFile(PsiFile file2, TextRange range) {
        Document document = file2.getViewProvider().getDocument();
        PsiDiagnosticUtils.LineAndColumn lineAndColumn = PsiDiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset());
        if (lineAndColumn == null) {
            DiagnosticUtils.$$$reportNull$$$0(4);
        }
        return lineAndColumn;
    }

    public static void throwIfRunningOnServer(Throwable e) {
        if (System.getProperty("kotlin.running.in.server.mode", "false").equals("true") || ApplicationManager.getApplication().isUnitTestMode()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static TextRange firstRange(@NotNull List<TextRange> ranges2) {
        if (ranges2 == null) {
            DiagnosticUtils.$$$reportNull$$$0(5);
        }
        TextRange textRange = Collections.min(ranges2, TEXT_RANGE_COMPARATOR);
        if (textRange == null) {
            DiagnosticUtils.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    public static List<Diagnostic> sortedDiagnostics(@NotNull Collection<Diagnostic> diagnostics2) {
        if (diagnostics2 == null) {
            DiagnosticUtils.$$$reportNull$$$0(7);
        }
        ArrayList result2 = Lists.newArrayList(diagnostics2);
        result2.sort((d1, d2) -> {
            TextRange range2;
            String path2;
            String path1 = d1.getPsiFile().getViewProvider().getVirtualFile().getPath();
            if (!path1.equals(path2 = d2.getPsiFile().getViewProvider().getVirtualFile().getPath())) {
                return path1.compareTo(path2);
            }
            TextRange range1 = DiagnosticUtils.firstRange(d1.getTextRanges());
            if (!range1.equals((Object)(range2 = DiagnosticUtils.firstRange(d2.getTextRanges())))) {
                return TEXT_RANGE_COMPARATOR.compare(range1, range2);
            }
            return d1.getFactory().getName().compareTo(d2.getFactory().getName());
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DiagnosticUtils.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static boolean hasError(Diagnostics diagnostics2) {
        for (Diagnostic diagnostic : diagnostics2.all()) {
            if (diagnostic.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/diagnostics/DiagnosticUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/diagnostics/DiagnosticUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAndColumn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAndColumnInPsiFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "firstRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineAndColumn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "firstRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sortedDiagnostics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

