/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KotlinClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final SimpleModificationTracker myTracker;
    private final List<Object> dependencies;
    private static final String VALUES_METHOD = "values";
    private static final String VALUE_OF_METHOD = "valueOf";

    public KotlinClassInnerStuffCache(@NotNull PsiExtensibleClass aClass2, @NotNull List<Object> externalDependencies) {
        if (aClass2 == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(0);
        }
        if (externalDependencies == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(1);
        }
        this.myTracker = new SimpleModificationTracker();
        this.myClass = aClass2;
        this.dependencies = new SmartList();
        this.dependencies.addAll(externalDependencies);
        this.dependencies.add(this.myTracker);
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = (PsiMethod[])KotlinClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(PsiImplUtil.getConstructors((PsiClass)this.myClass))));
        if (psiMethodArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])KotlinClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getAllFields())));
        if (psiFieldArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(3);
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])KotlinClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getAllMethods())));
        if (psiMethodArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = (PsiClass[])KotlinClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getAllInnerClasses())));
        if (psiClassArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName((PsiClass)this.myClass, (String)name2, (boolean)true);
        }
        return (PsiField)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getFieldsMap()))).get(name2);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name2, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName((PsiClass)this.myClass, (String)name2, (boolean)true);
            if (psiMethodArray == null) {
                KotlinClassInnerStuffCache.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])KotlinClassInnerStuffCache.copy((Object[])ObjectUtils.notNull(((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getMethodsMap()))).get(name2), (Object)PsiMethod.EMPTY_ARRAY));
        if (psiMethodArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName((PsiClass)this.myClass, (String)name2, (boolean)true);
        }
        return (PsiClass)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getInnerClassesMap()))).get(name2);
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return this.myClass.isEnum() && this.myClass.getName() != null ? (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.makeValuesMethod())) : null;
    }

    @Nullable
    public PsiMethod getValueOfMethod() {
        return this.myClass.isEnum() && this.myClass.getName() != null ? (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.makeValueOfMethod())) : null;
    }

    private static <T> T[] copy(T[] value) {
        return value.length == 0 ? value : (Object[])value.clone();
    }

    private <T> CachedValueProvider.Result<T> makeResult(T value) {
        return CachedValueProvider.Result.create(value, this.dependencies);
    }

    @NotNull
    private PsiField[] getAllFields() {
        List own = this.myClass.getOwnFields();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class);
        PsiField[] psiFieldArray = (PsiField[])ArrayUtil.mergeCollections((Collection)own, (Collection)ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @NotNull
    private PsiMethod[] getAllMethods() {
        List own = this.myClass.getOwnMethods();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class);
        PsiMethod[] psiMethodArray = (PsiMethod[])ArrayUtil.mergeCollections((Collection)own, (Collection)ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    @NotNull
    private PsiClass[] getAllInnerClasses() {
        List own = this.myClass.getOwnInnerClasses();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class);
        PsiClass[] psiClassArray = (PsiClass[])ArrayUtil.mergeCollections((Collection)own, (Collection)ext, (ArrayFactory)PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields2 = this.getFields();
        if (fields2.length == 0) {
            Map<String, PsiField> map2 = Collections.emptyMap();
            if (map2 == null) {
                KotlinClassInnerStuffCache.$$$reportNull$$$0(11);
            }
            return map2;
        }
        THashMap cachedFields = new THashMap();
        for (PsiField field : fields2) {
            String name2 = field.getName();
            if (cachedFields.containsKey(name2)) continue;
            cachedFields.put(name2, field);
        }
        THashMap tHashMap = cachedFields;
        if (tHashMap == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(12);
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        PsiMethod[] methods2 = this.getMethods();
        if (methods2.length == 0) {
            Map<String, PsiMethod[]> map2 = Collections.emptyMap();
            if (map2 == null) {
                KotlinClassInnerStuffCache.$$$reportNull$$$0(13);
            }
            return map2;
        }
        HashMap collectedMethods = ContainerUtil.newHashMap();
        for (PsiMethod method : methods2) {
            List list2 = (List)collectedMethods.get(method.getName());
            if (list2 == null) {
                list2 = ContainerUtil.newSmartList();
                collectedMethods.put(method.getName(), list2);
            }
            list2.add(method);
        }
        THashMap cachedMethods = ContainerUtil.newTroveMap();
        for (Map.Entry entry : collectedMethods.entrySet()) {
            List list3 = (List)entry.getValue();
            cachedMethods.put(entry.getKey(), list3.toArray(PsiMethod.EMPTY_ARRAY));
        }
        THashMap tHashMap = cachedMethods;
        if (tHashMap == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(14);
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes2 = this.getInnerClasses();
        if (classes2.length == 0) {
            Map<String, PsiClass> map2 = Collections.emptyMap();
            if (map2 == null) {
                KotlinClassInnerStuffCache.$$$reportNull$$$0(15);
            }
            return map2;
        }
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : classes2) {
            String name2 = psiClass.getName();
            if (name2 == null) {
                Logger.getInstance(KotlinClassInnerStuffCache.class).error((Object)psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name2)) continue;
            cachedInners.put(name2, psiClass);
        }
        THashMap tHashMap = cachedInners;
        if (tHashMap == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(16);
        }
        return tHashMap;
    }

    private PsiMethod makeValuesMethod() {
        return this.getSyntheticMethod("public static " + this.myClass.getName() + "[] values() { }");
    }

    private PsiMethod makeValueOfMethod() {
        return this.getSyntheticMethod("public static " + this.myClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }");
    }

    private PsiMethod getSyntheticMethod(String text2) {
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)this.myClass.getProject());
        PsiMethod method = factory2.createMethodFromText(text2, (PsiElement)this.myClass);
        return new LightMethod(this.myClass.getManager(), method, (PsiClass)this.myClass){

            public int getTextOffset() {
                return KotlinClassInnerStuffCache.this.myClass.getTextOffset();
            }
        };
    }

    public void dropCaches() {
        this.myTracker.incModificationCount();
    }

    public static boolean processDeclarationsInEnum(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull KotlinClassInnerStuffCache innerStuffCache) {
        ElementClassHint classHint;
        if (processor2 == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(17);
        }
        if (state == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(18);
        }
        if (innerStuffCache == null) {
            KotlinClassInnerStuffCache.$$$reportNull$$$0(19);
        }
        if ((classHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY)) == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod method;
            NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
            if ((nameHint == null || VALUES_METHOD.equals(nameHint.getName(state))) && (method = innerStuffCache.getValuesMethod()) != null && !processor2.execute((PsiElement)method, ResolveState.initial())) {
                return false;
            }
            if ((nameHint == null || VALUE_OF_METHOD.equals(nameHint.getName(state))) && (method = innerStuffCache.getValueOfMethod()) != null && !processor2.execute((PsiElement)method, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalDependencies";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/asJava/classes/KotlinClassInnerStuffCache";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerStuffCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/asJava/classes/KotlinClassInnerStuffCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsMap";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInEnum";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

