/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.backend.ast.metadata.TypeCheck;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final String EQUALS_METHOD_NAME = Namer.getStableMangledNameForDescriptor(JsPlatformAnalyzerServices.INSTANCE.getBuiltIns().getAny(), "equals");
    public static final String COMPARE_TO_METHOD_NAME = Namer.getStableMangledNameForDescriptor(JsPlatformAnalyzerServices.INSTANCE.getBuiltIns().getComparable(), "compareTo");
    public static final String LONG_FROM_NUMBER = "fromNumber";
    public static final String LONG_TO_NUMBER = "toNumber";
    public static final String LONG_FROM_INT = "fromInt";
    public static final String UINT_FROM_INT = "toUInt";
    public static final String LONG_ZERO = "ZERO";
    public static final String LONG_ONE = "ONE";
    public static final String LONG_NEG_ONE = "NEG_ONE";
    public static final String LONG_MAX_VALUE = "MAX_VALUE";
    public static final String LONG_MIN_VALUE = "MIN_VALUE";
    public static final String PRIMITIVE_COMPARE_TO = "primitiveCompareTo";
    public static final String IS_CHAR = "isChar";
    public static final String IS_NUMBER = "isNumber";
    private static final String IS_CHAR_SEQUENCE = "isCharSequence";
    public static final String GET_KCLASS = "getKClass";
    public static final String GET_KCLASS_FROM_EXPRESSION = "getKClassFromExpression";
    public static final String CALLEE_NAME = "$fun";
    public static final String CALL_FUNCTION = "call";
    private static final String APPLY_FUNCTION = "apply";
    public static final String OUTER_FIELD_NAME = "$outer";
    private static final String DELEGATE = "$delegate";
    private static final String ROOT_PACKAGE = "_";
    private static final String RECEIVER_PARAMETER_NAME = "$receiver";
    public static final String ANOTHER_THIS_PARAMETER_NAME = "$this";
    public static final String THROW_CLASS_CAST_EXCEPTION_FUN_NAME = "throwCCE";
    public static final String THROW_ILLEGAL_STATE_EXCEPTION_FUN_NAME = "throwISE";
    public static final String THROW_UNINITIALIZED_PROPERTY_ACCESS_EXCEPTION = "throwUPAE";
    public static final String NULL_CHECK_INTRINSIC_NAME = "ensureNotNull";
    private static final String PROTOTYPE_NAME = "prototype";
    private static final String CAPTURED_VAR_FIELD = "v";
    public static final JsNameRef IS_ARRAY_FUN_REF = new JsNameRef("isArray", "Array");
    public static final String DEFINE_INLINE_FUNCTION = "defineInlineFunction";
    public static final String DEFAULT_PARAMETER_IMPLEMENTOR_SUFFIX = "$default";
    private static final JsNameRef JS_OBJECT = new JsNameRef("Object");
    private static final JsNameRef JS_OBJECT_CREATE_FUNCTION = new JsNameRef("create", (JsExpression)JS_OBJECT);
    public static final String LOCAL_MODULE_PREFIX = "$module$";
    public static final String METADATA = "$metadata$";
    public static final String METADATA_SUPERTYPES = "interfaces";
    public static final String METADATA_SIMPLE_NAME = "simpleName";
    public static final String METADATA_CLASS_KIND = "kind";
    public static final String CLASS_KIND_ENUM = "Kind";
    public static final String CLASS_KIND_CLASS = "CLASS";
    public static final String CLASS_KIND_INTERFACE = "INTERFACE";
    public static final String CLASS_KIND_OBJECT = "OBJECT";
    public static final String OBJECT_INSTANCE_VAR_SUFFIX = "_instance";
    public static final String OBJECT_INSTANCE_FUNCTION_SUFFIX = "_getInstance";
    public static final String ENUM_NAME_FIELD = "name$";
    public static final String ENUM_ORDINAL_FIELD = "ordinal$";
    public static final String IMPORTS_FOR_INLINE_PROPERTY = "$$importsForInline$$";
    @NotNull
    private final JsObjectScope kotlinScope;
    @NotNull
    public static final String FUNCTION_CALLABLE_REF = "getCallableRef";
    @NotNull
    public static final String PROPERTY_CALLABLE_REF = "getPropertyCallableRef";
    @NotNull
    private final JsExpression callGetProperty;
    @NotNull
    private final JsExpression callSetProperty;

    @NotNull
    public static String getFunctionTag(@NotNull CallableDescriptor functionDescriptor, @NotNull JsConfig config) {
        String intrinsicTag;
        if (functionDescriptor == null) {
            Namer.$$$reportNull$$$1(0);
        }
        if (config == null) {
            Namer.$$$reportNull$$$1(1);
        }
        if (functionDescriptor == null) {
            Namer.$$$reportNull$$$0(0);
        }
        if (config == null) {
            Namer.$$$reportNull$$$0(1);
        }
        if ((intrinsicTag = ArrayFIF.INSTANCE.getTag(functionDescriptor, config)) != null) {
            String string = intrinsicTag;
            if (string == null) {
                Namer.$$$reportNull$$$0(2);
            }
            if (string == null) {
                Namer.$$$reportNull$$$1(2);
            }
            return string;
        }
        functionDescriptor = (CallableDescriptor)JsDescriptorUtils.findRealInlineDeclaration(functionDescriptor);
        String moduleName = JsDescriptorUtils.getModuleName(functionDescriptor);
        FqNameUnsafe fqNameParent = DescriptorUtils.getFqName(functionDescriptor).parent();
        String qualifier = null;
        if (!fqNameParent.isRoot()) {
            qualifier = fqNameParent.asString();
        }
        SuggestedName suggestedName = new NameSuggestion().suggest(functionDescriptor);
        assert (suggestedName != null) : "Suggested name can be null only for module descriptors: " + functionDescriptor;
        String mangledName = suggestedName.getNames().get(0);
        String string = StringUtil.join(Arrays.asList(moduleName, qualifier, mangledName), (String)".");
        if (string == null) {
            Namer.$$$reportNull$$$0(3);
        }
        if (string == null) {
            Namer.$$$reportNull$$$1(3);
        }
        return string;
    }

    @NotNull
    public static String getReceiverParameterName() {
        return RECEIVER_PARAMETER_NAME;
    }

    @NotNull
    public static String getRootPackageName() {
        return ROOT_PACKAGE;
    }

    @NotNull
    public static String getPrototypeName() {
        return PROTOTYPE_NAME;
    }

    @NotNull
    public static String getDelegatePrefix() {
        return DELEGATE;
    }

    @NotNull
    public static JsNameRef getFunctionCallRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            Namer.$$$reportNull$$$1(4);
        }
        if (functionExpression == null) {
            Namer.$$$reportNull$$$0(4);
        }
        JsNameRef result2 = JsAstUtils.pureFqn(CALL_FUNCTION, functionExpression);
        MetadataProperties.setJsCall(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(5);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(5);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef getFunctionApplyRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            Namer.$$$reportNull$$$1(6);
        }
        if (functionExpression == null) {
            Namer.$$$reportNull$$$0(6);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(APPLY_FUNCTION, functionExpression);
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(7);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(7);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation createObjectWithPrototypeFrom(@NotNull JsExpression referenceToClass) {
        if (referenceToClass == null) {
            Namer.$$$reportNull$$$1(8);
        }
        if (referenceToClass == null) {
            Namer.$$$reportNull$$$0(8);
        }
        return new JsInvocation((JsExpression)JS_OBJECT_CREATE_FUNCTION.deepCopy(), JsAstUtils.prototypeOf(referenceToClass));
    }

    @NotNull
    public static JsNameRef getCapturedVarAccessor(@NotNull JsExpression ref) {
        if (ref == null) {
            Namer.$$$reportNull$$$1(9);
        }
        if (ref == null) {
            Namer.$$$reportNull$$$0(9);
        }
        JsNameRef result2 = new JsNameRef(CAPTURED_VAR_FIELD, ref);
        MetadataProperties.setSideEffects(result2, SideEffectKind.DEPENDS_ON_STATE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(10);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(10);
        }
        return jsNameRef;
    }

    @NotNull
    public static String isInstanceSuggestedName(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            Namer.$$$reportNull$$$1(11);
        }
        if (descriptor2 == null) {
            Namer.$$$reportNull$$$0(11);
        }
        String string = "is" + NameSuggestion.sanitizeName(descriptor2.getName().getIdentifier());
        if (string == null) {
            Namer.$$$reportNull$$$0(12);
        }
        if (string == null) {
            Namer.$$$reportNull$$$1(12);
        }
        return string;
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope) {
        if (rootScope == null) {
            Namer.$$$reportNull$$$1(13);
        }
        if (rootScope == null) {
            Namer.$$$reportNull$$$0(13);
        }
        return new Namer(rootScope);
    }

    private Namer(@NotNull JsScope rootScope) {
        if (rootScope == null) {
            Namer.$$$reportNull$$$1(14);
        }
        if (rootScope == null) {
            Namer.$$$reportNull$$$0(14);
        }
        this.kotlinScope = new JsObjectScope(rootScope, "Kotlin standard object");
        this.callGetProperty = this.kotlin("callGetter");
        this.callSetProperty = this.kotlin("callSetter");
    }

    @NotNull
    private static String getStableMangledNameForDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull String functionName) {
        if (descriptor2 == null) {
            Namer.$$$reportNull$$$1(15);
        }
        if (functionName == null) {
            Namer.$$$reportNull$$$1(16);
        }
        if (descriptor2 == null) {
            Namer.$$$reportNull$$$0(15);
        }
        if (functionName == null) {
            Namer.$$$reportNull$$$0(16);
        }
        Collection<? extends SimpleFunctionDescriptor> functions2 = descriptor2.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier(functionName), NoLookupLocation.FROM_BACKEND);
        assert (functions2.size() == 1) : "Can't select a single function: " + functionName + " in " + descriptor2;
        SuggestedName suggested = new NameSuggestion().suggest(functions2.iterator().next());
        assert (suggested != null) : "Suggested name for class members is always non-null: " + functions2.iterator().next();
        String string = suggested.getNames().get(0);
        if (string == null) {
            Namer.$$$reportNull$$$0(17);
        }
        if (string == null) {
            Namer.$$$reportNull$$$1(17);
        }
        return string;
    }

    @NotNull
    public static JsNameRef kotlin(@NotNull JsName name2) {
        if (name2 == null) {
            Namer.$$$reportNull$$$1(18);
        }
        if (name2 == null) {
            Namer.$$$reportNull$$$0(18);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name2, (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(19);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(19);
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef kotlin(@NotNull String name2) {
        if (name2 == null) {
            Namer.$$$reportNull$$$1(20);
        }
        if (name2 == null) {
            Namer.$$$reportNull$$$0(20);
        }
        return Namer.kotlin(this.kotlinScope.declareName(name2));
    }

    @NotNull
    public static JsNameRef kotlinObject() {
        JsNameRef jsNameRef = JsAstUtils.pureFqn(KOTLIN_NAME, null);
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(21);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(21);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isTypeOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            Namer.$$$reportNull$$$1(22);
        }
        if (type2 == null) {
            Namer.$$$reportNull$$$0(22);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("isTypeOf", type2, TypeCheck.TYPEOF);
    }

    @NotNull
    public JsExpression isInstanceOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            Namer.$$$reportNull$$$1(23);
        }
        if (type2 == null) {
            Namer.$$$reportNull$$$0(23);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("isInstanceOf", type2, TypeCheck.INSTANCEOF);
    }

    @NotNull
    public JsExpression orNull(@NotNull JsExpression callable) {
        if (callable == null) {
            Namer.$$$reportNull$$$1(24);
        }
        if (callable == null) {
            Namer.$$$reportNull$$$0(24);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("orNull", callable, TypeCheck.OR_NULL);
    }

    @NotNull
    public JsExpression andPredicate(@NotNull JsExpression a, @NotNull JsExpression b) {
        if (a == null) {
            Namer.$$$reportNull$$$1(25);
        }
        if (b == null) {
            Namer.$$$reportNull$$$1(26);
        }
        if (a == null) {
            Namer.$$$reportNull$$$0(25);
        }
        if (b == null) {
            Namer.$$$reportNull$$$0(26);
        }
        return this.invokeFunctionAndSetTypeCheckMetadata("andPredicate", Arrays.asList(a, b), TypeCheck.AND_PREDICATE);
    }

    @NotNull
    public JsExpression isComparable() {
        JsNameRef jsNameRef = this.kotlin("isComparable");
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(27);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(27);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isCharSequence() {
        JsNameRef jsNameRef = this.kotlin(IS_CHAR_SEQUENCE);
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(28);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(28);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isArray() {
        JsNameRef jsNameRef = this.kotlin("isArray");
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(29);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(29);
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isPrimitiveArray(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            Namer.$$$reportNull$$$1(30);
        }
        if (type2 == null) {
            Namer.$$$reportNull$$$0(30);
        }
        JsNameRef jsNameRef = this.kotlin("is" + type2.getArrayTypeName().asString());
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(31);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(31);
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @Nullable JsExpression argument, @NotNull TypeCheck metadata) {
        if (functionName == null) {
            Namer.$$$reportNull$$$1(32);
        }
        if (metadata == null) {
            Namer.$$$reportNull$$$1(33);
        }
        if (functionName == null) {
            Namer.$$$reportNull$$$0(32);
        }
        if (metadata == null) {
            Namer.$$$reportNull$$$0(33);
        }
        List<JsExpression> arguments2 = argument != null ? Collections.singletonList(argument) : Collections.emptyList();
        return this.invokeFunctionAndSetTypeCheckMetadata(functionName, arguments2, metadata);
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @NotNull List<JsExpression> arguments2, @NotNull TypeCheck metadata) {
        if (functionName == null) {
            Namer.$$$reportNull$$$1(34);
        }
        if (arguments2 == null) {
            Namer.$$$reportNull$$$1(35);
        }
        if (metadata == null) {
            Namer.$$$reportNull$$$1(36);
        }
        if (functionName == null) {
            Namer.$$$reportNull$$$0(34);
        }
        if (arguments2 == null) {
            Namer.$$$reportNull$$$0(35);
        }
        if (metadata == null) {
            Namer.$$$reportNull$$$0(36);
        }
        JsInvocation invocation = new JsInvocation((JsExpression)this.kotlin(functionName), new JsExpression[0]);
        invocation.getArguments().addAll(arguments2);
        MetadataProperties.setTypeCheck(invocation, metadata);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        JsInvocation jsInvocation = invocation;
        if (jsInvocation == null) {
            Namer.$$$reportNull$$$0(37);
        }
        if (jsInvocation == null) {
            Namer.$$$reportNull$$$1(37);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression isInstanceOf(@NotNull JsExpression instance, @NotNull JsExpression type2) {
        if (instance == null) {
            Namer.$$$reportNull$$$1(38);
        }
        if (type2 == null) {
            Namer.$$$reportNull$$$1(39);
        }
        if (instance == null) {
            Namer.$$$reportNull$$$0(38);
        }
        if (type2 == null) {
            Namer.$$$reportNull$$$0(39);
        }
        JsInvocation result2 = new JsInvocation((JsExpression)new JsNameRef("isType", KOTLIN_NAME), instance, type2);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsInvocation jsInvocation = result2;
        if (jsInvocation == null) {
            Namer.$$$reportNull$$$0(40);
        }
        if (jsInvocation == null) {
            Namer.$$$reportNull$$$1(40);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression getUndefinedExpression() {
        return new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(0));
    }

    @NotNull
    public JsExpression getCallGetProperty() {
        JsExpression jsExpression = this.callGetProperty.deepCopy();
        if (jsExpression == null) {
            Namer.$$$reportNull$$$0(41);
        }
        if (jsExpression == null) {
            Namer.$$$reportNull$$$1(41);
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getCallSetProperty() {
        JsExpression jsExpression = this.callSetProperty.deepCopy();
        if (jsExpression == null) {
            Namer.$$$reportNull$$$0(42);
        }
        if (jsExpression == null) {
            Namer.$$$reportNull$$$1(42);
        }
        return jsExpression;
    }

    public static JsNameRef kotlinLong() {
        return JsAstUtils.pureFqn("Long", (JsExpression)Namer.kotlinObject());
    }

    @NotNull
    public static JsExpression createSpecialFunction(@NotNull SpecialFunction specialFunction) {
        if (specialFunction == null) {
            Namer.$$$reportNull$$$1(43);
        }
        if (specialFunction == null) {
            Namer.$$$reportNull$$$0(43);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(specialFunction.getSuggestedName(), (JsExpression)Namer.kotlinObject());
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$0(44);
        }
        if (jsNameRef == null) {
            Namer.$$$reportNull$$$1(44);
        }
        return jsNameRef;
    }

    @NotNull
    public static String suggestedModuleName(@NotNull String id) {
        if (id == null) {
            Namer.$$$reportNull$$$1(45);
        }
        if (id == null) {
            Namer.$$$reportNull$$$0(45);
        }
        if (id.isEmpty()) {
            return ROOT_PACKAGE;
        }
        StringBuilder sb = new StringBuilder(id.length());
        char c = id.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            sb.append(c);
        } else {
            sb.append('_');
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
        }
        for (int i = 1; i < id.length(); ++i) {
            c = id.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        String string = sb.toString();
        if (string == null) {
            Namer.$$$reportNull$$$0(46);
        }
        if (string == null) {
            Namer.$$$reportNull$$$1(46);
        }
        return string;
    }

    public static JsNameRef imul() {
        return JsAstUtils.pureFqn("imul", (JsExpression)Namer.kotlinObject());
    }

    public static boolean requiresEscaping(@NotNull String name2) {
        if (name2 == null) {
            Namer.$$$reportNull$$$1(47);
        }
        if (name2 == null) {
            Namer.$$$reportNull$$$0(47);
        }
        if (name2.isEmpty() || !Character.isJavaIdentifierStart(name2.charAt(0))) {
            return true;
        }
        for (int i = 1; i < name2.length(); ++i) {
            if (Character.isJavaIdentifierPart(name2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/Namer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootScope";
                break;
            }
            case 16: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 18: 
            case 20: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 23: 
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialFunction";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/Namer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionCallRef";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionApplyRef";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedVarAccessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isInstanceSuggestedName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStableMangledNameForDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlinObject";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isComparable";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = IS_CHAR_SEQUENCE;
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "isArray";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "isPrimitiveArray";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeFunctionAndSetTypeCheckMetadata";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "isInstanceOf";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallGetProperty";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSetProperty";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpecialFunction";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestedModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTag";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionCallRef";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionApplyRef";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createObjectWithPrototypeFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedVarAccessor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceSuggestedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStableMangledNameForDescriptor";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "kotlin";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOf";
                break;
            }
            case 23: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOf";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "orNull";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "andPredicate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveArray";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invokeFunctionAndSetTypeCheckMetadata";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createSpecialFunction";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "suggestedModuleName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "requiresEscaping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/Namer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootScope";
                break;
            }
            case 16: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 18: 
            case 20: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 23: 
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialFunction";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/Namer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionCallRef";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionApplyRef";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedVarAccessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isInstanceSuggestedName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStableMangledNameForDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlinObject";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isComparable";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = IS_CHAR_SEQUENCE;
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "isArray";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "isPrimitiveArray";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeFunctionAndSetTypeCheckMetadata";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "isInstanceOf";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallGetProperty";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSetProperty";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpecialFunction";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestedModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTag";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionCallRef";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionApplyRef";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createObjectWithPrototypeFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedVarAccessor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceSuggestedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStableMangledNameForDescriptor";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "kotlin";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOf";
                break;
            }
            case 23: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOf";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "orNull";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "andPredicate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveArray";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invokeFunctionAndSetTypeCheckMetadata";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createSpecialFunction";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "suggestedModuleName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "requiresEscaping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

