/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ArgumentsKt;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.InternalArgument;
import org.jetbrains.kotlin.cli.common.arguments.ManualLanguageFeatureSetting;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CompatKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.Services;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 $*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J5\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0004\u00a2\u0006\u0002\u0010\u0015J#\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001b\u001a\u00020\u000fH&J#\u0010\u001c\u001a\u00020\b2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ'\u0010\u001e\u001a\u00020\b\"\b\b\u0001\u0010\u0001*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010\"\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010#\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool;", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "", "()V", "createArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "disableURLConnectionCaches", "", "exec", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "errStream", "Ljava/io/PrintStream;", "args", "", "", "(Ljava/io/PrintStream;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "services", "Lorg/jetbrains/kotlin/config/Services;", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "arguments", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "execImpl", "executableScriptFileName", "parseArguments", "([Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "printVersionIfNeeded", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "reportArgumentParseProblems", "collector", "reportUnsafeInternalArgumentsIfAny", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "Companion", "cli"})
public abstract class CLITool<A extends CommonToolArguments> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        MessageRenderer messageRenderer;
        MessageRenderer messageRenderer2;
        String rendererType;
        Intrinsics.checkParameterIsNotNull((Object)errStream, (String)"errStream");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String string2 = rendererType = System.getProperty("org.jetbrains.kotlin.cliMessageRenderer");
        MessageRenderer messageRenderer3 = MessageRenderer.XML;
        Intrinsics.checkExpressionValueIsNotNull((Object)messageRenderer3, (String)"MessageRenderer.XML");
        if (Intrinsics.areEqual((Object)string2, (Object)messageRenderer3.getName())) {
            messageRenderer2 = MessageRenderer.XML;
        } else {
            MessageRenderer messageRenderer4 = MessageRenderer.GRADLE_STYLE;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageRenderer4, (String)"MessageRenderer.GRADLE_STYLE");
            if (Intrinsics.areEqual((Object)string2, (Object)messageRenderer4.getName())) {
                messageRenderer2 = MessageRenderer.GRADLE_STYLE;
            } else {
                MessageRenderer messageRenderer5 = MessageRenderer.WITHOUT_PATHS;
                Intrinsics.checkExpressionValueIsNotNull((Object)messageRenderer5, (String)"MessageRenderer.WITHOUT_PATHS");
                if (Intrinsics.areEqual((Object)string2, (Object)messageRenderer5.getName())) {
                    messageRenderer2 = MessageRenderer.WITHOUT_PATHS;
                } else {
                    MessageRenderer messageRenderer6 = MessageRenderer.PLAIN_FULL_PATHS;
                    Intrinsics.checkExpressionValueIsNotNull((Object)messageRenderer6, (String)"MessageRenderer.PLAIN_FULL_PATHS");
                    messageRenderer2 = Intrinsics.areEqual((Object)string2, (Object)messageRenderer6.getName()) ? MessageRenderer.PLAIN_FULL_PATHS : MessageRenderer.PLAIN_RELATIVE_PATHS;
                }
            }
        }
        MessageRenderer messageRenderer7 = messageRenderer = messageRenderer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)messageRenderer7, (String)"messageRenderer");
        return this.exec(errStream, Services.EMPTY, messageRenderer7, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)errStream, (String)"errStream");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull((Object)messageRenderer, (String)"messageRenderer");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        A arguments2 = this.createArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments(ArraysKt.asList((Object[])args), arguments2);
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonToolArguments)arguments2).getVerbose());
        try {
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemInstall();
            }
            errStream.print(messageRenderer.renderPreamble());
            String errorMessage2 = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
            if (errorMessage2 != null) {
                collector2.report(CompilerMessageSeverity.ERROR, errorMessage2, null);
                collector2.report(CompilerMessageSeverity.INFO, "Use -help for more information", null);
                ExitCode exitCode2 = ExitCode.COMPILATION_ERROR;
                return exitCode2;
            }
            if (((CommonToolArguments)arguments2).getHelp() || ((CommonToolArguments)arguments2).getExtraHelp()) {
                errStream.print(messageRenderer.renderUsage(Usage.render(this, arguments2)));
                ExitCode exitCode3 = ExitCode.OK;
                return exitCode3;
            }
            ExitCode exitCode4 = this.exec(collector2, services, arguments2);
            return exitCode4;
        }
        finally {
            errStream.print(messageRenderer.renderConclusion());
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemUninstall();
            }
        }
    }

    @NotNull
    public final ExitCode exec(@NotNull MessageCollector messageCollector2, @NotNull Services services, @NotNull A arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        this.disableURLConnectionCaches();
        this.printVersionIfNeeded(messageCollector2, arguments2);
        MessageCollector fixedMessageCollector = ((CommonToolArguments)arguments2).getSuppressWarnings() && !((CommonToolArguments)arguments2).getAllWarningsAsErrors() ? (MessageCollector)new FilteringMessageCollector(messageCollector2, Predicate.isEqual((Object)CompilerMessageSeverity.WARNING)) : messageCollector2;
        ArgumentsKt.reportArgumentParseProblems(fixedMessageCollector, arguments2);
        return this.execImpl(fixedMessageCollector, services, arguments2);
    }

    private final void disableURLConnectionCaches() {
        new URLConnection(new URL("file:.")){

            @NotNull
            public Void connect() {
                throw (Throwable)new UnsupportedOperationException();
            }
        }.setDefaultUseCaches(false);
    }

    @NotNull
    protected abstract ExitCode execImpl(@NotNull MessageCollector var1, @NotNull Services var2, @NotNull A var3);

    @NotNull
    public abstract A createArguments();

    public final void parseArguments(@NotNull String[] args, @NotNull A arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        ParseCommandLineArgumentsKt.parseCommandLineArguments(ArraysKt.asList((Object[])args), arguments2);
        String message2 = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
        if (message2 != null) {
            throw (Throwable)new IllegalArgumentException(message2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportArgumentParseProblems(MessageCollector collector2, A arguments2) {
        Object key;
        boolean bl;
        Map.Entry entry;
        this.reportUnsafeInternalArgumentsIfAny(arguments2, collector2);
        ArgumentParseErrors argumentParseErrors = ((CommonToolArguments)arguments2).getErrors();
        if (argumentParseErrors == null) {
            return;
        }
        ArgumentParseErrors errors = argumentParseErrors;
        for (String string2 : errors.getUnknownExtraFlags()) {
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Flag is not supported by this version of the compiler: " + string2, null, 4, null);
        }
        for (String string3 : errors.getExtraArgumentsPassedInObsoleteForm()) {
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Advanced option value is passed in an obsolete form. Please use the '=' character " + "to specify the value: " + string3 + "=...", null, 4, null);
        }
        Object object = errors.getDuplicateArguments();
        boolean bl2 = false;
        Iterator<Object> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2;
            entry = entry2 = (Map.Entry)iterator2.next();
            bl = false;
            object = (String)entry.getKey();
            entry = entry2;
            bl = false;
            String value2 = (String)entry.getValue();
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Argument " + (String)key + " is passed multiple times. Only the last value will be used: " + value2, null, 4, null);
        }
        key = errors.getDeprecatedArguments();
        boolean value2 = false;
        iterator2 = key.entrySet().iterator();
        while (iterator2.hasNext()) {
            void deprecatedName;
            Map.Entry entry3;
            entry = entry3 = (Map.Entry)iterator2.next();
            bl = false;
            key = (String)entry.getKey();
            entry = entry3;
            bl = false;
            String newName2 = (String)entry.getValue();
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Argument " + (String)deprecatedName + " is deprecated. Please use " + newName2 + " instead", null, 4, null);
        }
        for (String string4 : errors.getArgfileErrors()) {
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, string4, null, 4, null);
        }
        for (String string5 : errors.getInternalArgumentsParsingProblems()) {
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, string5, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportUnsafeInternalArgumentsIfAny(A arguments2, MessageCollector collector2) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = ((CommonToolArguments)arguments2).getInternalArguments();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            InternalArgument it = (InternalArgument)element$iv$iv;
            boolean bl = false;
            if (it instanceof ManualLanguageFeatureSetting && ((ManualLanguageFeatureSetting)it).getLanguageFeature().getKind() == LanguageFeature.Kind.BUG_FIX && ((ManualLanguageFeatureSetting)it).getState() == LanguageFeature.State.ENABLED) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsafeArguments = (List)destination$iv$iv;
        $this$filterNot$iv = unsafeArguments;
        boolean bl = false;
        if (!$this$filterNot$iv.isEmpty()) {
            Function1 function1 = reportUnsafeInternalArgumentsIfAny.unsafeArgumentsString.1.INSTANCE;
            iterable = null;
            int n = 0;
            CharSequence charSequence = "\n";
            CharSequence charSequence2 = "\n\n";
            CharSequence charSequence3 = "\n";
            String unsafeArgumentsString2 = CollectionsKt.joinToString$default((Iterable)unsafeArguments, (CharSequence)charSequence, (CharSequence)charSequence3, (CharSequence)charSequence2, (int)n, (CharSequence)((Object)iterable), (Function1)function1, (int)24, null);
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "ATTENTION!\nThis build uses unsafe internal compiler arguments:\n" + unsafeArgumentsString2 + "This mode is not recommended for production use,\n" + "as no stability/compatibility guarantees are given on\n" + "compiler or generated code. Use it at your own risk!\n", null, 4, null);
        }
    }

    private final <A extends CommonToolArguments> void printVersionIfNeeded(MessageCollector messageCollector2, A arguments2) {
        if (arguments2.getVersion()) {
            String jreVersion = System.getProperty("java.runtime.version");
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, this.executableScriptFileName() + " @snapshot@ (JRE " + jreVersion + ')', null, 4, null);
        }
    }

    @NotNull
    public abstract String executableScriptFileName();

    @JvmStatic
    public static final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        Companion.doMain(compiler, args);
    }

    @JvmStatic
    @NotNull
    public static final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        return Companion.doMainNoExit(compiler, args);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u00020\f2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool$Companion;", "", "()V", "doMain", "", "compiler", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "args", "", "", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;)V", "doMainNoExit", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "cli"})
    public static final class Companion {
        @JvmStatic
        public final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(compiler, (String)"compiler");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            if (System.getProperty("java.awt.headless") == null) {
                System.setProperty("java.awt.headless", "true");
            }
            if (System.getProperty("kotlin.colors.enabled") == null) {
                System.setProperty("kotlin.colors.enabled", "true");
            }
            CompatKt.setupIdeaStandaloneExecution();
            ExitCode exitCode2 = this.doMainNoExit(compiler, args);
            if (exitCode2 != ExitCode.OK) {
                int n = exitCode2.getCode();
                boolean bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }

        @JvmStatic
        @NotNull
        public final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            ExitCode exitCode2;
            Intrinsics.checkParameterIsNotNull(compiler, (String)"compiler");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            try {
                PrintStream printStream = System.err;
                Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.err");
                exitCode2 = compiler.exec(printStream, Arrays.copyOf(args, args.length));
            }
            catch (CompileEnvironmentException e) {
                System.err.println(e.getMessage());
                exitCode2 = ExitCode.INTERNAL_ERROR;
            }
            return exitCode2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

