/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.js.ProduceKind;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.JsIrCompilationError;
import org.jetbrains.kotlin.ir.backend.js.JsLibraryResolverKt;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "performanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "addPlatformOptions", "", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    private final CommonCompilerPerformanceManager performanceManager = new CommonCompilerPerformanceManager("Kotlin to JS (IR) Compiler"){};
    private static final Map<String, ModuleKind> moduleKindMap;
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    private static final Map<String, ProduceKind> produceMap;
    public static final Companion Companion;

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        CompilerResult $this$filterTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector2, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector3 = messageCollector2;
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (arguments2.getScript()) {
            Object v2;
            KotlinCoreEnvironment.ProjectEnvironment projectEnv;
            block34: {
                if (!arguments2.getEnableJsScripting()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector3, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                configuration.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                KotlinCoreApplicationEnvironment environment2 = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration);
                projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment2);
                projectEnv.registerExtensionsFromPlugins(configuration);
                MockProject mockProject = projectEnv.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)mockProject, (String)"projectEnv.project");
                List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances((Project)mockProject);
                Iterable iterable = scriptingEvaluators;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                    boolean bl3 = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v2 = t;
                    break block34;
                }
                v2 = null;
            }
            ScriptEvaluationExtension scriptingEvaluator = v2;
            if (scriptingEvaluator == null) {
                MessageCollector.DefaultImpls.report$default(messageCollector3, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return scriptingEvaluator.eval(arguments2, configuration, projectEnv);
        }
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            messageCollector3.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List libraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries());
        List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        Object[] commonSourcesArray = arguments2.getCommonSources();
        Object object2 = commonSourcesArray;
        if (commonSourcesArray == null || (object2 = ArraysKt.toSet((Object[])object2)) == null) {
            object2 = SetsKt.emptySet();
        }
        Object commonSources = object2;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project projectJs = environmentForJS.getProject();
        CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector3.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector3.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            messageCollector3.report(CompilerMessageSeverity.ERROR, "No source files", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector3, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        configurationJs.put(CommonConfigurationKeys.MODULE_NAME, FileUtil.getNameWithoutExtension((File)outputFile));
        JsConfig config = new JsConfig(projectJs, configurationJs);
        File file2 = outputFile.getParentFile();
        if (file2 == null) {
            File file3 = outputFile.getAbsoluteFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"outputFile.absoluteFile");
            file2 = file3.getParentFile();
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
        }
        File outputDir2 = file2;
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector3.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual((Object)"noCall", (Object)arguments2.getMain()) ? null : CollectionsKt.emptyList();
        List list2 = libraries;
        MessageCollector messageCollector4 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector4 == null) {
            String string2 = "Could not find message collector";
            List list3 = list2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector4, (String)"configuration[CLIConfigu\u2026 find message collector\")");
        KotlinLibraryResolveResult resolvedLibraries2 = JsLibraryResolverKt.jsResolveLibraries(list2, K2JsIrCompilerKt.messageCollectorLogger(messageCollector4));
        Iterable $this$map$iv = friendLibraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string4 = new File((String)it).getAbsolutePath();
            object.add(string4);
        }
        List friendAbsolutePaths = (List)destination$iv$iv;
        Iterable $this$filter$iv = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries2, null, 1, null);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            KotlinLibrary it = (KotlinLibrary)element$iv$iv;
            boolean bl = false;
            if (!friendAbsolutePaths.contains(it.getLibraryFile().getAbsolutePath())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List friendDependencies = (List)destination$iv$iv2;
        if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
            String outputKlibPath = arguments2.getIrProduceKlibDir() ? new File(outputFilePath).getParent() : outputFilePath;
            try {
                Project project = config.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"config.project");
                CompilerConfiguration compilerConfiguration = config.getConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"config.configuration");
                String string5 = outputKlibPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"outputKlibPath");
                KlibKt.generateKLib(project, sourcesFiles, compilerConfiguration, resolvedLibraries2, friendDependencies, string5, arguments2.getIrProduceKlibDir());
            }
            catch (JsIrCompilationError e) {
                return ExitCode.COMPILATION_ERROR;
            }
        }
        if (arguments2.getIrProduceJs()) {
            String string6;
            PhaseConfig phaseConfig = CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector3);
            try {
                CompilerConfiguration compilerConfiguration = config.getConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"config.configuration");
                $this$filterTo$iv$iv = CompilerKt.compile$default(projectJs, sourcesFiles, compilerConfiguration, phaseConfig, resolvedLibraries2, friendDependencies, mainCallArguments, null, !arguments2.getIrDce(), arguments2.getIrDce(), 128, null);
            }
            catch (JsIrCompilationError e) {
                return ExitCode.COMPILATION_ERROR;
            }
            CompilerResult compiledModule = $this$filterTo$iv$iv;
            if (arguments2.getIrDce()) {
                string6 = compiledModule.getDceJsCode();
                if (string6 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                string6 = compiledModule.getJsCode();
                if (string6 == null) {
                    Intrinsics.throwNpe();
                }
            }
            String jsCode = string6;
            FilesKt.writeText$default((File)outputFile, (String)jsCode, null, (int)2, null);
            if (arguments2.getGenerateDts()) {
                File dtsFile;
                File file4 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "d.ts");
                if (file4 == null) {
                    Intrinsics.throwNpe();
                }
                File file5 = dtsFile = file4;
                String string7 = compiledModule.getTsDefinitions();
                if (string7 == null) {
                    String string8 = "No ts definitions";
                    object = file5;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string8.toString());
                }
                FilesKt.writeText$default((File)file5, (String)string7, null, (int)2, null);
            }
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ExpectActualTracker expectActualTracker;
        LookupTracker lookupTracker;
        IncrementalResultsConsumer incrementalResultsConsumer;
        String moduleKindName;
        ModuleKind moduleKind;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector2, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector3 = messageCollector2;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual((Object)"v5", (Object)arguments2.getTarget());
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("Unsupported ECMA version: ");
                String string2 = arguments2.getTarget();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = stringBuilder2.append(string2).toString();
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22));
            }
        }
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            messageCollector3.report(CompilerMessageSeverity.WARNING, "source-map argument is not supported yet", null);
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector3.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector3.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = friendModules;
            String string3 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.pathSeparator");
            String string4 = string3;
            int n = 0;
            string4 = new Regex(string4);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string4.split($i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl3 = false;
                    CharSequence charSequence = it;
                    boolean bl4 = false;
                    if (charSequence.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$filterNot$iv = list2;
            boolean $i$f$filterNot = false;
            Iterable iterator$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                CharSequence charSequence = it;
                boolean bl6 = false;
                if (charSequence.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector3.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        IncrementalDataProvider incrementalDataProvider = services.get(IncrementalDataProvider.class);
        if (incrementalDataProvider != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, incrementalDataProvider);
        }
        if ((incrementalResultsConsumer = services.get(IncrementalResultsConsumer.class)) != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, incrementalResultsConsumer);
        }
        if ((lookupTracker = services.get(LookupTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, lookupTracker);
        }
        if ((expectActualTracker = services.get(ExpectActualTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, expectActualTracker);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message2 = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection)sourceMapContentEmbeddingMap.keySet(), (String)", ");
            messageCollector3.report(CompilerMessageSeverity.ERROR, message2, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector3.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-js -Xir";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkParameterIsNotNull((Object)versionArray, (String)"versionArray");
        return new KlibMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull($this$addPlatformOptions, (String)"$this$addPlatformOptions");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
    }

    static {
        Companion = new Companion(null);
        moduleKindMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"plain", (Object)((Object)ModuleKind.PLAIN)), TuplesKt.to((Object)"commonjs", (Object)((Object)ModuleKind.COMMON_JS)), TuplesKt.to((Object)"amd", (Object)((Object)ModuleKind.AMD)), TuplesKt.to((Object)"umd", (Object)((Object)ModuleKind.UMD))});
        sourceMapContentEmbeddingMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"always", (Object)((Object)SourceMapSourceEmbedding.ALWAYS)), TuplesKt.to((Object)"never", (Object)((Object)SourceMapSourceEmbedding.NEVER)), TuplesKt.to((Object)"inlining", (Object)((Object)SourceMapSourceEmbedding.INLINING))});
        produceMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(null, (Object)((Object)ProduceKind.DEFAULT)), TuplesKt.to((Object)"js", (Object)((Object)ProduceKind.JS)), TuplesKt.to((Object)"klib", (Object)((Object)ProduceKind.KLIB))});
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "produceMap", "Lorg/jetbrains/kotlin/cli/js/ProduceKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector2, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                String string2 = virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : file2.getName() + " (no virtual file)";
                collection.add(string2);
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector2.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            Object object = libraryString;
            if (object == null || (object = this.splitByPathSeparator((String)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(@NotNull String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence = $this$splitByPathSeparator;
            String string2 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
            String string3 = string2;
            int n = 0;
            string3 = new Regex(string3);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string3.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    int n2 = 0;
                    if (charSequence2.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (CharSequence element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                CharSequence charSequence3 = it;
                boolean bl4 = false;
                if (charSequence3.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

