/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "source", "", "refreshLabelNames", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "renameLocalNames", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "js.translator"})
public final class NamingUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context2, @NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2, @Nullable Object source) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        boolean bl = arguments2.size() <= parameters2.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "arguments.size (" + arguments2.size() + ") should be less or equal to parameters.size (" + parameters2.size() + ')';
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl2 = false;
        List defaultParams = new ArrayList();
        for (Pair pair : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsNameRef replacement2;
            JsName paramName;
            void arg;
            JsExpression bl4 = (JsExpression)pair.component1();
            JsParameter param = (JsParameter)pair.component2();
            if (JsAstUtils.isUndefinedExpression((JsExpression)arg)) {
                Collection collection = defaultParams;
                boolean bl5 = false;
                collection.add(param);
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)param.getName(), (String)"param.name");
            JsName jsName = JsScope.declareTemporaryName(paramName.getIdent());
            boolean bl6 = false;
            boolean bl7 = false;
            JsName $this$apply = jsName;
            boolean bl8 = false;
            MetadataProperties.setStaticRef($this$apply, (JsNode)arg);
            JsName jsName2 = $this$apply;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"this");
            context2.newVar(jsName2, arg.deepCopy(), source);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName.makeRef(), (String)"JsScope.declareTemporary\u2026urce)\n        }.makeRef()");
            replacement2.setSource(arg.getSource());
            context2.replaceName(paramName, replacement2);
        }
        Collection collection = defaultParams;
        Iterator iterator2 = parameters2.subList(arguments2.size(), parameters2.size());
        boolean arg = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)((Object)iterator2));
        for (JsParameter defaultParam : defaultParams) {
            JsName freshName;
            JsName paramName;
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultParam.getName(), (String)"defaultParam.name");
            Intrinsics.checkExpressionValueIsNotNull((Object)JsScope.declareTemporaryName(paramName.getIdent()), (String)"JsScope.declareTemporaryName(paramName.ident)");
            freshName.copyMetadataFrom(paramName);
            NamingContext.newVar$default(context2, freshName, null, source, 2, null);
            JsNameRef jsNameRef = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"freshName.makeRef()");
            context2.replaceName(paramName, jsNameRef);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context2, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"function.body");
        for (JsName name2 : CollectUtilsKt.collectDefinedNames(jsBlock)) {
            JsName temporaryName;
            JsName jsName = JsScope.declareTemporaryName(name2.getIdent());
            boolean bl = false;
            boolean bl2 = false;
            JsName $this$apply = jsName;
            boolean bl3 = false;
            MetadataProperties.setStaticRef($this$apply, MetadataProperties.getStaticRef(name2));
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"JsScope.declareTemporary\u2026ticRef = name.staticRef }");
            JsNameRef jsNameRef = temporaryName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"temporaryName.makeRef()");
            context2.replaceName(name2, jsNameRef);
        }
    }

    @NotNull
    public static final JsNode refreshLabelNames(@NotNull JsNode node, @NotNull JsScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        if (!(scope2 instanceof JsFunctionScope)) {
            throw (Throwable)((Object)new AssertionError((Object)"JsFunction is expected to have JsFunctionScope"));
        }
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor((JsFunctionScope)scope2);
        JsNode jsNode = visitor2.accept(node);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNode, (String)"visitor.accept(node)");
        return jsNode;
    }
}

