/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDomSerializationUtil {
    @NonNls
    public static final String COMPONENT_ELEMENT = "component";
    @NonNls
    protected static final String OPTION_ELEMENT = "option";
    @NonNls
    protected static final String NAME_ATTRIBUTE = "name";
    @NonNls
    protected static final String VALUE_ATTRIBUTE = "value";

    @Nullable
    public static Element findComponent(@Nullable Element root2, @NonNls String componentName) {
        for (Element element : JDOMUtil.getChildren((Element)root2, (String)COMPONENT_ELEMENT)) {
            if (!JDomSerializationUtil.isComponent(componentName, element)) continue;
            return element;
        }
        return null;
    }

    public static boolean isComponent(@NotNull String componentName, @NotNull Element element) {
        if (componentName == null) {
            JDomSerializationUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JDomSerializationUtil.$$$reportNull$$$0(1);
        }
        return componentName.equals(element.getAttributeValue(NAME_ATTRIBUTE));
    }

    public static Element createComponentElement(String componentName) {
        Element element = new Element(COMPONENT_ELEMENT);
        element.setAttribute(NAME_ATTRIBUTE, componentName);
        return element;
    }

    @NotNull
    public static Element findOrCreateComponentElement(@NotNull Element root2, @NotNull String componentName) {
        Element component;
        if (root2 == null) {
            JDomSerializationUtil.$$$reportNull$$$0(2);
        }
        if (componentName == null) {
            JDomSerializationUtil.$$$reportNull$$$0(3);
        }
        if ((component = JDomSerializationUtil.findComponent(root2, componentName)) == null) {
            component = JDomSerializationUtil.createComponentElement(componentName);
            JDomSerializationUtil.addComponent(root2, component);
        }
        Element element = component;
        if (element == null) {
            JDomSerializationUtil.$$$reportNull$$$0(4);
        }
        return element;
    }

    public static void addComponent(Element root2, Element component) {
        String componentName = component.getAttributeValue(NAME_ATTRIBUTE);
        Element old = JDomSerializationUtil.findComponent(root2, componentName);
        if (old != null) {
            root2.removeContent((Content)old);
        }
        for (int i = 0; i < root2.getContent().size(); ++i) {
            String name2;
            Element element;
            Object o = root2.getContent().get(i);
            if (!(o instanceof Element) || !(element = (Element)o).getName().equals(COMPONENT_ELEMENT) || componentName.compareTo(name2 = element.getAttributeValue(NAME_ATTRIBUTE)) >= 0) continue;
            root2.addContent(i, (Content)component);
            return;
        }
        root2.addContent(component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JDomSerializationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JDomSerializationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateComponentElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateComponentElement";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

