/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionBase;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.converter.DeclarationsConverter;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.parsing.KotlinLightParser;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "stubMode", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/fir/FirSession;ZLcom/intellij/openapi/project/Project;)V", "buildFirFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "code", "", "fileName", "buildLightTree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "Companion", "lightTree"})
public final class LightTree2Fir {
    private final FirSession session;
    private final boolean stubMode;
    private final Project project;
    private static final KotlinParserDefinition parserDefinition;
    private static final KotlinLexer lexer;
    public static final Companion Companion;

    @NotNull
    public final FirFile buildFirFile(@NotNull Path path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        File file2 = path2.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"path.toFile()");
        return this.buildFirFile(file2);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String string2 = FileUtil.loadFile((File)file2, (String)"UTF-8", (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.loadFile(file, CharsetToolkit.UTF8, true)");
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String code = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        String string5 = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"file.name");
        return this.buildFirFile(code, string5);
    }

    @NotNull
    public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTree(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        PsiBuilder psiBuilder = new PsiBuilderFactoryImpl().createBuilder((ParserDefinition)parserDefinition, (Lexer)lexer, (CharSequence)code);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiBuilder, (String)"PsiBuilderFactoryImpl().\u2026rDefinition, lexer, code)");
        PsiBuilder builder = psiBuilder;
        KotlinLightParser.parse(builder);
        FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder.getLightTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)flyweightCapableTreeStructure, (String)"builder.lightTree");
        return flyweightCapableTreeStructure;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull String code, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        FlyweightCapableTreeStructure<LighterASTNode> lightTree = this.buildLightTree(code);
        DeclarationsConverter declarationsConverter = new DeclarationsConverter(this.session, this.stubMode, lightTree, null, 8, null);
        Object object = lightTree.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"lightTree.root");
        return declarationsConverter.convertFile((LighterASTNode)object, fileName);
    }

    public LightTree2Fir(@NotNull FirSession session, boolean stubMode, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.session = session;
        this.stubMode = stubMode;
        this.project = project;
    }

    public /* synthetic */ LightTree2Fir(FirSession firSession, boolean bl, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            firSession = new FirSessionBase(null){};
        }
        this(firSession, bl, project);
    }

    static {
        Companion = new Companion(null);
        parserDefinition = new KotlinParserDefinition();
        lexer = new KotlinLexer();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir$Companion;", "", "()V", "lexer", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "parserDefinition", "Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "buildLightTreeBlockExpression", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "code", "", "buildLightTreeLambdaExpression", "lightTree"})
    public static final class Companion {
        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTreeBlockExpression(@NotNull String code) {
            Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
            PsiBuilder psiBuilder = new PsiBuilderFactoryImpl().createBuilder((ParserDefinition)parserDefinition, (Lexer)lexer, (CharSequence)code);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiBuilder, (String)"PsiBuilderFactoryImpl().\u2026rDefinition, lexer, code)");
            PsiBuilder builder = psiBuilder;
            KotlinLightParser.parseBlockExpression(builder);
            FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder.getLightTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)flyweightCapableTreeStructure, (String)"builder.lightTree");
            return flyweightCapableTreeStructure;
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTreeLambdaExpression(@NotNull String code) {
            Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
            PsiBuilder psiBuilder = new PsiBuilderFactoryImpl().createBuilder((ParserDefinition)parserDefinition, (Lexer)lexer, (CharSequence)code);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiBuilder, (String)"PsiBuilderFactoryImpl().\u2026rDefinition, lexer, code)");
            PsiBuilder builder = psiBuilder;
            KotlinLightParser.parseLambdaExpression(builder);
            FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder.getLightTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)flyweightCapableTreeStructure, (String)"builder.lightTree");
            return flyweightCapableTreeStructure;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

