/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.jvm;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u0006*\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u0006*\u00060\u0007j\u0002`\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\u000f\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\rH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"PRIMITIVE_TYPE_SIGNATURE", "", "", "unitClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "appendConeType", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "coneType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "appendErasedType", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "computeJvmDescriptor", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isVoid", "", "jvm"})
public final class DescriptorUtilsKt {
    private static final Map<String, String> PRIMITIVE_TYPE_SIGNATURE = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Boolean", (Object)"Z"), TuplesKt.to((Object)"Byte", (Object)"B"), TuplesKt.to((Object)"Char", (Object)"C"), TuplesKt.to((Object)"Short", (Object)"S"), TuplesKt.to((Object)"Int", (Object)"I"), TuplesKt.to((Object)"Long", (Object)"J"), TuplesKt.to((Object)"Float", (Object)"F"), TuplesKt.to((Object)"Double", (Object)"D")});
    private static final ClassId unitClassId;

    @NotNull
    public static final String computeJvmDescriptor(@NotNull FirFunction<?> $this$computeJvmDescriptor) {
        Intrinsics.checkNotNullParameter($this$computeJvmDescriptor, (String)"$this$computeJvmDescriptor");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl5 = false;
        if ($this$computeJvmDescriptor instanceof FirSimpleFunction) {
            $this$buildString.append(((FirSimpleFunction)$this$computeJvmDescriptor).getName().asString());
        } else {
            $this$buildString.append("<init>");
        }
        $this$buildString.append("(");
        for (FirValueParameter parameter : $this$computeJvmDescriptor.getValueParameters()) {
            DescriptorUtilsKt.appendErasedType($this$buildString, parameter.getReturnTypeRef());
        }
        $this$buildString.append(")");
        if (!($this$computeJvmDescriptor instanceof FirSimpleFunction) || DescriptorUtilsKt.isVoid($this$computeJvmDescriptor.getReturnTypeRef())) {
            $this$buildString.append("V");
        } else {
            DescriptorUtilsKt.appendErasedType($this$buildString, $this$computeJvmDescriptor.getReturnTypeRef());
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private static final void appendErasedType(StringBuilder $this$appendErasedType, FirTypeRef typeRef) {
        block10: {
            JavaType javaType;
            FirTypeRef firTypeRef;
            Function1<JavaClass, Unit> $fun$appendClass$1;
            block9: {
                $fun$appendClass$1 = new Function1<JavaClass, Unit>($this$appendErasedType){
                    final /* synthetic */ StringBuilder $this_appendErasedType;

                    public final void invoke(@NotNull JavaClass klass) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                            FqName fqName2 = klass.getFqName();
                            if (fqName2 == null) break block0;
                            FqName fqName3 = fqName2;
                            boolean bl = false;
                            boolean bl2 = false;
                            FqName it = fqName3;
                            boolean bl3 = false;
                            this.$this_appendErasedType.append("L");
                            String string2 = it.asString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.asString()");
                            this.$this_appendErasedType.append(StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null));
                        }
                    }
                    {
                        this.$this_appendErasedType = stringBuilder2;
                        super(1);
                    }
                };
                firTypeRef = typeRef;
                if (!(firTypeRef instanceof FirResolvedTypeRef)) break block9;
                DescriptorUtilsKt.appendConeType($this$appendErasedType, ((FirResolvedTypeRef)typeRef).getType());
                break block10;
            }
            if (!(firTypeRef instanceof FirJavaTypeRef) || !((javaType = ((FirJavaTypeRef)typeRef).getType()) instanceof JavaClassifierType)) break block10;
            JavaClassifier classifier2 = ((JavaClassifierType)javaType).getClassifier();
            if (classifier2 instanceof JavaClass) {
                $fun$appendClass$1.invoke((JavaClass)classifier2);
            } else if (classifier2 instanceof JavaTypeParameter) {
                Object v0;
                block8: {
                    Iterable $this$firstOrNull$iv = ((JavaTypeParameter)classifier2).getUpperBounds();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        JavaClassifierType it = (JavaClassifierType)element$iv;
                        boolean bl = false;
                        if (!(it.getClassifier() instanceof JavaClass)) continue;
                        v0 = element$iv;
                        break block8;
                    }
                    v0 = null;
                }
                JavaClassifierType representative = v0;
                if (representative == null) {
                    $this$appendErasedType.append("Ljava/lang/Object");
                } else {
                    JavaClassifier javaClassifier = representative.getClassifier();
                    if (javaClassifier == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.JavaClass");
                    }
                    $fun$appendClass$1.invoke((JavaClass)javaClassifier);
                }
            } else {
                return;
            }
            $this$appendErasedType.append(";");
        }
    }

    private static final void appendConeType(StringBuilder $this$appendConeType, ConeKotlinType coneType) {
        ConeKotlinType coneKotlinType = coneType;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
        if (coneClassLikeType != null) {
            ConeClassLikeType coneClassLikeType2 = coneClassLikeType;
            boolean bl = false;
            boolean bl2 = false;
            ConeClassLikeType it = coneClassLikeType2;
            boolean bl3 = false;
            ClassId classId = it.getLookupTag().getClassId();
            if (Intrinsics.areEqual((Object)classId.getPackageFqName().toString(), (Object)"kotlin")) {
                Name name2 = classId.getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
                String string2 = PRIMITIVE_TYPE_SIGNATURE.get(name2.getIdentifier());
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it2 = string3;
                    boolean bl6 = false;
                    $this$appendConeType.append(it2);
                    return;
                }
            }
        }
        Function1<ConeClassLikeType, Unit> $fun$appendClassLikeType$2 = new Function1<ConeClassLikeType, Unit>($this$appendConeType){
            final /* synthetic */ StringBuilder $this_appendConeType;

            public final void invoke(@NotNull ConeClassLikeType type2) {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                this.$this_appendConeType.append("L");
                ClassId classId = type2.getLookupTag().getClassId();
                String string2 = classId.getPackageFqName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.packageFqName.asString()");
                this.$this_appendConeType.append(StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null));
                this.$this_appendConeType.append("/");
                this.$this_appendConeType.append(classId.getRelativeClassName());
            }
            {
                this.$this_appendConeType = stringBuilder2;
                super(1);
            }
        };
        if (coneType instanceof ConeClassErrorType) {
            return;
        }
        ConeKotlinType coneKotlinType2 = coneType;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            $fun$appendClassLikeType$2.invoke((ConeClassLikeType)coneType);
        } else if (coneKotlinType2 instanceof ConeTypeParameterType) {
            Object v6;
            block16: {
                Iterable $this$firstOrNull$iv = ((FirTypeParameter)((ConeTypeParameterType)coneType).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl = false;
                    FirTypeRef firTypeRef = it;
                    if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                        firTypeRef = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                    if (!((firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null) instanceof ConeClassLikeType)) continue;
                    v6 = element$iv;
                    break block16;
                }
                v6 = null;
            }
            FirTypeRef representative = v6;
            if (representative == null || representative instanceof FirImplicitNullableAnyTypeRef || representative instanceof FirImplicitAnyTypeRef) {
                $this$appendConeType.append("Ljava/lang/Object");
            } else {
                FirTypeRef $this$coneTypeUnsafe$iv = representative;
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType3 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
                if (coneKotlinType3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
                }
                $fun$appendClassLikeType$2.invoke((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType3)));
            }
        } else {
            if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                DescriptorUtilsKt.appendConeType($this$appendConeType, ((ConeDefinitelyNotNullType)coneType).getOriginal());
                return;
            }
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                DescriptorUtilsKt.appendConeType($this$appendConeType, ((ConeFlexibleType)coneType).getLowerBound());
                return;
            }
        }
        $this$appendConeType.append(";");
    }

    private static final boolean isVoid(FirTypeRef $this$isVoid) {
        JavaType type2;
        FirTypeRef firTypeRef = $this$isVoid;
        boolean bl = firTypeRef instanceof FirJavaTypeRef ? (type2 = ((FirJavaTypeRef)$this$isVoid).getType()) instanceof JavaPrimitiveType && ((JavaPrimitiveType)type2).getType() == null : (firTypeRef instanceof FirResolvedTypeRef ? (type = ((FirResolvedTypeRef)$this$isVoid).getType()) instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)type).getLookupTag().getClassId(), (Object)unitClassId) : false);
        return bl;
    }

    static {
        ClassId classId = ClassId.topLevel(new FqName("kotlin.Unit"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.topLevel(FqName(\"kotlin.Unit\"))");
        unitClassId = classId;
    }
}

