/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.impl.JdkVendorDetector;
import org.jetbrains.jps.service.SharedThreadPool;

public class JdkVersionDetectorImpl
extends JdkVersionDetector {
    private static final Logger LOG = Logger.getInstance(JdkVersionDetectorImpl.class);

    @Override
    @Nullable
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath) {
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(0);
        }
        return this.detectJdkVersionInfo(homePath, (ExecutorService)SharedThreadPool.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath, @NotNull ExecutorService runner) {
        File rtFile;
        File releaseFile;
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(2);
        }
        if ((releaseFile = new File(homePath, "release")).isFile()) {
            Properties p = new Properties();
            try (FileInputStream stream = new FileInputStream(releaseFile);){
                p.load(stream);
                String versionString2 = p.getProperty("JAVA_FULL_VERSION", p.getProperty("JAVA_VERSION"));
                if (versionString2 != null) {
                    JavaVersion version = JavaVersion.parse((String)versionString2);
                    String arch = StringUtil.unquoteString((String)p.getProperty("OS_ARCH", ""));
                    boolean x64 = "x86_64".equals(arch) || "amd64".equals(arch);
                    Bitness bitness = x64 ? Bitness.x64 : Bitness.x32;
                    JdkVendorDetector.Vendor vendor = JdkVendorDetector.detectJdkVendorByReleaseFile(p);
                    JdkVersionDetector.JdkVersionInfo jdkVersionInfo = vendor != null ? new JdkVersionDetector.JdkVersionInfo(version, bitness, vendor.getPrefix(), vendor.displayName) : new JdkVersionDetector.JdkVersionInfo(version, bitness);
                    return jdkVersionInfo;
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.info(releaseFile.getPath(), (Throwable)e);
            }
        }
        if ((rtFile = new File(homePath, "jre/lib/rt.jar")).isFile()) {
            try (JarFile rtJar = new JarFile(rtFile, false);){
                String versionString3;
                Manifest manifest2 = rtJar.getManifest();
                if (manifest2 != null && (versionString3 = manifest2.getMainAttributes().getValue("Implementation-Version")) != null) {
                    JavaVersion version = JavaVersion.parse((String)versionString3);
                    boolean x64 = SystemInfo.isMac || new File(rtFile.getParent(), "amd64").isDirectory();
                    JdkVersionDetector.JdkVersionInfo bitness = new JdkVersionDetector.JdkVersionInfo(version, x64 ? Bitness.x64 : Bitness.x32);
                    return bitness;
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.info(rtFile.getPath(), (Throwable)e);
            }
        }
        File javaExe = new File(homePath, "bin/" + (SystemInfo.isWindows ? "java.exe" : "java"));
        if (!javaExe.canExecute()) return null;
        try {
            Bitness bitness;
            Process process2 = new ProcessBuilder(javaExe.getPath(), "-version").redirectErrorStream(true).start();
            VersionOutputReader reader = new VersionOutputReader(process2.getInputStream(), runner);
            try {
                reader.waitFor();
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
                process2.destroy();
            }
            List lines = reader.myLines;
            while (!lines.isEmpty() && ((String)lines.get(0)).startsWith("Picked up ")) {
                lines.remove(0);
            }
            if (lines.isEmpty()) return null;
            JavaVersion base2 = JavaVersion.parse((String)((String)lines.get(0)));
            JavaVersion rt = JavaVersion.tryParse(lines.size() > 2 ? (String)lines.get(1) : null);
            JavaVersion version = rt != null && rt.feature == base2.feature && rt.minor == base2.minor ? rt : base2;
            boolean x64 = lines.stream().anyMatch(s -> s.contains("64-Bit") || s.contains("x86_64") || s.contains("amd64"));
            if (x64) {
                bitness = Bitness.x64;
                return new JdkVersionDetector.JdkVersionInfo(version, bitness);
            }
            bitness = Bitness.x32;
            return new JdkVersionDetector.JdkVersionInfo(version, bitness);
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.info(javaExe.getPath(), (Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "homePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "runner";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl";
        objectArray[2] = "detectJdkVersionInfo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionOutputReader
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            public boolean splitToLines() {
                return true;
            }

            public boolean sendIncompleteLines() {
                return false;
            }

            public boolean withSeparators() {
                return false;
            }
        };
        private final ExecutorService myRunner;
        private final List<String> myLines;

        VersionOutputReader(@NotNull InputStream stream, @NotNull ExecutorService runner) {
            if (stream == null) {
                VersionOutputReader.$$$reportNull$$$0(0);
            }
            if (runner == null) {
                VersionOutputReader.$$$reportNull$$$0(1);
            }
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myRunner = runner;
            this.myLines = new CopyOnWriteArrayList<String>();
            this.start("java -version");
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                VersionOutputReader.$$$reportNull$$$0(2);
            }
            Future<?> future = this.myRunner.submit(runnable);
            if (future == null) {
                VersionOutputReader.$$$reportNull$$$0(3);
            }
            return future;
        }

        protected void onTextAvailable(@NotNull String text2) {
            if (text2 == null) {
                VersionOutputReader.$$$reportNull$$$0(4);
            }
            this.myLines.add(text2);
            LOG.trace("text: " + text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

